/*
 * Decompiled with CFR 0.152.
 */
package tcl.pkg.tjc;

import java.util.ArrayList;
import tcl.lang.Interp;
import tcl.lang.TclClassLoader;
import tcl.lang.TclEvent;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclString;
import tcl.pkg.tjc.TJC;
import tcl.pkg.tjc.TJCThread;

class TJCCompileTclCmd
extends TclEvent
implements TJCThread.CompiledClassReady {
    final boolean debug = false;
    final Interp interp;
    final String cmd;
    final String readyCmd;
    final String readyVar;
    boolean status;
    String errorMsg = "";
    String className = null;
    byte[] classBytes = null;

    TJCCompileTclCmd(Interp interp, String string, String string2, String string3) {
        this.interp = interp;
        this.cmd = string;
        this.readyCmd = string2;
        this.readyVar = string3;
    }

    @Override
    public void compiled(String string, String string2, String string3, ArrayList arrayList, ArrayList arrayList2, int n, String string4) {
        if (n == 0) {
            this.status = true;
        } else {
            this.status = false;
            this.errorMsg = string4;
        }
        if (arrayList2 != null) {
            if (arrayList2.size() == 1) {
                this.className = (String)arrayList.get(0);
                this.classBytes = (byte[])arrayList2.get(0);
            } else {
                this.status = false;
                this.errorMsg = "unexpected number of class files " + arrayList2.size();
            }
        }
        this.interp.getNotifier().queueEvent(this, 0);
    }

    @Override
    public int processEvent(int n) {
        Class clazz;
        if (!this.status) {
            this.readyReport();
            return 1;
        }
        TclClassLoader tclClassLoader = (TclClassLoader)this.interp.getClassLoader();
        if (this.className != null) {
            tclClassLoader.removeCache(this.className);
        }
        if ((clazz = tclClassLoader.defineClass(this.className, this.classBytes)) == null) {
            this.status = false;
            this.errorMsg = "class not loaded by TclClassLoader";
            this.readyReport();
            return 1;
        }
        Object var4_4 = null;
        String string = null;
        if (this.className == null) {
            this.className = clazz.getName();
        }
        try {
            var4_4 = clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            string = "instance of class " + this.className + " could not be created";
        }
        catch (IllegalAccessException illegalAccessException) {
            string = "instance of class " + this.className + " could not be created";
        }
        if (!(var4_4 instanceof TJC.CompiledCommand)) {
            string = "instance of class " + this.className + " must extend TJC.CompiledCommand";
        }
        if (string != null) {
            this.status = false;
            this.errorMsg = string;
            this.readyReport();
            return 1;
        }
        TJC.CompiledCommand compiledCommand = var4_4;
        try {
            TJC.createCommand(this.interp, this.cmd, compiledCommand);
        }
        catch (TclException tclException) {
            this.status = false;
            this.errorMsg = tclException.getMessage();
            this.readyReport();
            return 1;
        }
        this.readyReport();
        return 1;
    }

    void readyReport() {
        try {
            if (this.readyVar != null) {
                TclObject tclObject = TclList.newInstance();
                if (this.status) {
                    TclList.append(this.interp, tclObject, TclString.newInstance("OK"));
                } else {
                    TclList.append(this.interp, tclObject, TclString.newInstance("FAIL"));
                }
                TclList.append(this.interp, tclObject, TclString.newInstance(this.cmd));
                TclList.append(this.interp, tclObject, TclString.newInstance(this.errorMsg));
                this.interp.setVar(this.readyVar, null, tclObject, 1);
            } else if (this.readyCmd != null) {
                TclObject tclObject = TclList.newInstance();
                TclList.append(this.interp, tclObject, TclString.newInstance(this.readyCmd));
                if (this.status) {
                    TclList.append(this.interp, tclObject, TclString.newInstance("OK"));
                } else {
                    TclList.append(this.interp, tclObject, TclString.newInstance("FAIL"));
                }
                TclList.append(this.interp, tclObject, TclString.newInstance(this.cmd));
                TclList.append(this.interp, tclObject, TclString.newInstance(this.errorMsg));
                this.interp.eval(tclObject, 131072);
            }
        }
        catch (TclException tclException) {
            tclException.printStackTrace(System.err);
        }
    }
}

