/*
 * Decompiled with CFR 0.152.
 */
package tcl.pkg.tjc;

import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclString;
import tcl.pkg.java.ReflectObject;

public class TJCThread
implements Runnable {
    public static final int STATUS_OK = 0;
    public static final int STATUS_ERROR = 1;
    private static boolean debug = false;
    private static String debugSetup = "";
    private static String driver = null;
    private static TJCThread tinstance = null;
    private static Thread tmain = null;
    private boolean terminate_request = false;
    private boolean terminated = false;
    private boolean ready = false;
    private static Vector queue = new Vector();
    private Interp interp = null;
    private static StringBuffer eventLog = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void compileJavaSource(String string, String string2, CompiledClassReady compiledClassReady) {
        if (compiledClassReady == null) {
            throw new NullPointerException("callback");
        }
        if (eventLog != null) {
            eventLog.append("compileJavaSource " + string + "\n");
        }
        if (debug) {
            System.out.println("compileJavaSource " + string);
        }
        if (string.equals("__FakeTest1.java")) {
            if (eventLog != null) {
                eventLog.append("Fake Java Test 1 processed\n");
            }
            if (debug) {
                System.out.println("Fake Java Test 1 processed");
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("__FakeTest1");
            byte[] byArray = new byte[]{70, 65, 75, 69};
            ArrayList<byte[]> arrayList2 = new ArrayList<byte[]>();
            arrayList2.add(byArray);
            compiledClassReady.compiled("", string, string2, arrayList, arrayList2, 0, "");
            return;
        }
        Vector<Object> vector = new Vector<Object>();
        vector.addElement("JAVA");
        vector.addElement(string);
        vector.addElement(string2);
        vector.addElement(compiledClassReady);
        queue.addElement(vector);
        TJCThread tJCThread = tinstance;
        synchronized (tJCThread) {
            if (eventLog != null) {
                eventLog.append("notify in compileJavaSource\n");
            }
            if (debug) {
                System.out.println("notify in compileJavaSource");
            }
            tinstance.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void compileTclSource(String string, String string2, CompiledClassReady compiledClassReady) {
        if (eventLog != null) {
            eventLog.append("compileTclSource " + string + "\n");
        }
        if (debug) {
            System.out.println("compileTclSource " + string);
            System.out.println("Tcl proc is:\n" + string2);
        }
        Vector<Object> vector = new Vector<Object>();
        vector.addElement("TCL");
        vector.addElement(string);
        vector.addElement(string2);
        vector.addElement(compiledClassReady);
        queue.addElement(vector);
        TJCThread tJCThread = tinstance;
        synchronized (tJCThread) {
            if (eventLog != null) {
                eventLog.append("notify in compileTclSource\n");
            }
            if (debug) {
                System.out.println("notify in compileTclSource");
            }
            tinstance.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void terminateThread() {
        if (eventLog != null) {
            eventLog.append("terminateThread\n");
        }
        if (debug) {
            System.out.println("terminateThread");
            if (queue.size() != 0) {
                System.out.println("terminateThread with unprocessed events");
            } else {
                System.out.println("terminateThread with no unprocessed events");
            }
        }
        if (TJCThread.tinstance.terminated) {
            if (eventLog != null) {
                eventLog.append("thread already terminated\n");
            }
            if (debug) {
                System.out.println("thread already terminated");
            }
            return;
        }
        TJCThread.tinstance.terminate_request = true;
        TJCThread tJCThread = tinstance;
        synchronized (tJCThread) {
            if (eventLog != null) {
                eventLog.append("notify in terminateThread\n");
            }
            if (debug) {
                System.out.println("notify in terminateThread");
            }
            tinstance.notify();
        }
    }

    public static synchronized void debugSetup(String string) {
        debugSetup = string;
        eventLog = null;
        StringTokenizer stringTokenizer = new StringTokenizer(debugSetup);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("-debug")) {
                debug = true;
                continue;
            }
            if (string2.equals("-event")) {
                eventLog = new StringBuffer(128);
                continue;
            }
            if (string2.equals("-pizza")) {
                driver = "pizza";
                continue;
            }
            if (!string2.equals("-janino")) continue;
            driver = "janino";
        }
    }

    public static synchronized boolean isThreadReady() {
        return TJCThread.tinstance.ready;
    }

    public static synchronized String getEventLog() {
        if (eventLog == null) {
            return null;
        }
        return eventLog.toString();
    }

    public static synchronized void startThread() {
        if (tinstance != null && !TJCThread.tinstance.terminate_request) {
            if (debug) {
                System.out.println("thread currently running");
            }
            return;
        }
        if (debug) {
            System.out.println("creating new Thread()");
        }
        tinstance = new TJCThread();
        tmain = new Thread(tinstance);
        tmain.setDaemon(true);
        int n = tmain.getPriority();
        if (n > 1) {
            tmain.setPriority(--n);
        }
        tmain.setName("TJCThread service");
        if (eventLog != null) {
            eventLog.append("thread create\n");
        }
        if (debug) {
            System.out.println("thread create");
        }
        tmain.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (eventLog != null) {
            eventLog.append("thread start\n");
        }
        if (debug) {
            System.out.println("thread start");
        }
        while (!this.terminate_request) {
            Object object;
            do {
                Vector vector = queue;
                synchronized (vector) {
                    if (queue.size() == 0) {
                        break;
                    }
                    object = (Vector)queue.remove(0);
                    if (debug) {
                        System.out.println("removed event, there are " + queue.size() + " events left");
                    }
                }
                this.processEvent((Vector)object);
            } while (!this.terminate_request);
            if (this.terminate_request) break;
            try {
                object = this;
                synchronized (object) {
                    if (eventLog != null) {
                        eventLog.append("thread wait\n");
                    }
                    if (debug) {
                        System.out.println("thread wait");
                    }
                    this.ready = true;
                    this.wait();
                    this.ready = false;
                }
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            if (this.terminate_request) break;
            if (eventLog != null) {
                eventLog.append("thread wakeup\n");
            }
            if (!debug) continue;
            System.out.println("thread wakeup");
        }
        if (this.terminate_request) {
            if (eventLog != null) {
                eventLog.append("thread terminate request\n");
            }
            if (debug) {
                System.out.println("thread terminate request");
            }
        }
        if (eventLog != null) {
            eventLog.append("thread terminated\n");
        }
        if (debug) {
            System.out.println("thread terminated");
        }
        this.terminated = true;
        if (this.interp != null) {
            if (debug) {
                System.out.println("Invoking interp.dispose()");
            }
            this.interp.dispose();
            this.interp = null;
        }
    }

    private void processEvent(Vector vector) {
        block18: {
            int n = vector.size();
            if (eventLog != null) {
                eventLog.append("process event\n");
            }
            if (debug) {
                System.out.println("PROCESS QUEUE EVENT: " + vector);
            }
            if (n != 4) {
                throw new RuntimeException("unexpected number of event args: " + n);
            }
            String string = (String)vector.elementAt(0);
            String string2 = (String)vector.elementAt(1);
            String string3 = (String)vector.elementAt(2);
            CompiledClassReady compiledClassReady = (CompiledClassReady)vector.elementAt(3);
            if (string2.equals("__FakeTest2.java")) {
                if (eventLog != null) {
                    eventLog.append("Fake Java Test 2 processed\n");
                }
                if (debug) {
                    System.out.println("Fake Java Test 2 processed");
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add("__FakeTest2");
                byte[] byArray = new byte[]{70, 65, 75, 69};
                ArrayList<byte[]> arrayList2 = new ArrayList<byte[]>();
                arrayList2.add(byArray);
                compiledClassReady.compiled("", string2, string3, arrayList, arrayList2, 0, "");
                return;
            }
            try {
                if (this.interp == null) {
                    if (eventLog != null) {
                        eventLog.append("Interp() and init\n");
                    }
                    if (debug) {
                        System.out.println("Interp() and init");
                    }
                    this.interp = new Interp();
                    if (driver != null) {
                        this.interp.setVar("JAVA_DRIVER", null, driver, 0);
                    }
                    this.interp.eval("source resource:/tcl/pkg/tjc/library/tjcthread.tcl");
                }
                if (string.equals("JAVA")) {
                    this.processJavaSource(string2, string3, compiledClassReady);
                    break block18;
                }
                if (string.equals("TCL")) {
                    this.processTclSource(string2, string3, compiledClassReady);
                    break block18;
                }
                throw new TclException(this.interp, "unknown type " + string);
            }
            catch (TclException tclException) {
                StringBuffer stringBuffer = new StringBuffer(128);
                stringBuffer.append("TclException: ");
                try {
                    TclObject tclObject = this.interp.getVar("errorInfo", null, 1);
                    stringBuffer.append(tclObject.toString());
                }
                catch (TclException tclException2) {
                    stringBuffer.append(tclException.getMessage());
                }
                if (eventLog != null) {
                    eventLog.append(stringBuffer.toString());
                    eventLog.append('\n');
                }
                if (debug) {
                    System.out.println(stringBuffer.toString());
                }
                compiledClassReady.compiled("", string2, string3, null, null, 1, stringBuffer.toString());
            }
        }
    }

    private void processJavaSource(String string, String string2, CompiledClassReady compiledClassReady) throws TclException {
        if (eventLog != null) {
            eventLog.append("process java source: " + string + "\n");
        }
        if (debug) {
            System.out.println("processJavaSource " + string);
        }
        TclObject tclObject = TclString.newInstance("processJavaSource");
        TclObject tclObject2 = TclString.newInstance(string);
        TclObject tclObject3 = TclString.newInstance(string2);
        TclObject tclObject4 = TclList.newInstance();
        TclList.append(this.interp, tclObject4, tclObject);
        TclList.append(this.interp, tclObject4, tclObject2);
        TclList.append(this.interp, tclObject4, tclObject3);
        this.interp.eval(tclObject4, 131072);
        TclObject tclObject5 = this.interp.getResult();
        if (debug) {
            System.out.println("processJavaSource interp result was: " + tclObject5.toString());
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<byte[]> arrayList2 = new ArrayList<byte[]>();
        int n = TclList.getLength(this.interp, tclObject5);
        for (int i = 0; i < n; i += 2) {
            TclObject tclObject6 = TclList.index(this.interp, tclObject5, i);
            TclObject tclObject7 = TclList.index(this.interp, tclObject5, i + 1);
            arrayList.add(tclObject6.toString());
            Object object = ReflectObject.get(this.interp, tclObject7);
            if (!(object instanceof byte[])) {
                throw new TclException(this.interp, "obj \"" + object + "\" is not a byte[] instance");
            }
            arrayList2.add((byte[])object);
        }
        this.interp.resetResult();
        compiledClassReady.compiled("", string, string2, arrayList, arrayList2, 0, "");
    }

    private void processTclSource(String string, String string2, CompiledClassReady compiledClassReady) throws TclException {
        if (eventLog != null) {
            eventLog.append("process tcl source: " + string + "\n");
        }
        if (debug) {
            System.out.println("processTclSource " + string);
        }
        TclObject tclObject = TclString.newInstance("processTclSource");
        TclObject tclObject2 = TclString.newInstance(string);
        TclObject tclObject3 = TclString.newInstance(string2);
        TclObject tclObject4 = TclList.newInstance();
        TclList.append(this.interp, tclObject4, tclObject);
        TclList.append(this.interp, tclObject4, tclObject2);
        TclList.append(this.interp, tclObject4, tclObject3);
        this.interp.eval(tclObject4, 131072);
        TclObject tclObject5 = this.interp.getResult();
        String string3 = TclList.index(this.interp, tclObject5, 0).toString();
        String string4 = TclList.index(this.interp, tclObject5, 1).toString();
        if (debug) {
            System.out.println("processTclSource interp result was:\n" + string4);
        }
        tclObject = TclString.newInstance("processJavaSource");
        tclObject2 = TclString.newInstance(string);
        tclObject3 = TclString.newInstance(string4);
        tclObject4 = TclList.newInstance();
        TclList.append(this.interp, tclObject4, tclObject);
        TclList.append(this.interp, tclObject4, tclObject2);
        TclList.append(this.interp, tclObject4, tclObject3);
        this.interp.eval(tclObject4, 131072);
        TclObject tclObject6 = this.interp.getResult();
        if (debug) {
            System.out.println("processTclSource interp result was: " + tclObject6.toString());
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<byte[]> arrayList2 = new ArrayList<byte[]>();
        int n = TclList.getLength(this.interp, tclObject6);
        for (int i = 0; i < n; i += 2) {
            TclObject tclObject7 = TclList.index(this.interp, tclObject6, i);
            TclObject tclObject8 = TclList.index(this.interp, tclObject6, i + 1);
            arrayList.add(tclObject7.toString());
            Object object = ReflectObject.get(this.interp, tclObject8);
            if (!(object instanceof byte[])) {
                throw new TclException(this.interp, "obj \"" + object + "\" is not a byte[] instance");
            }
            arrayList2.add((byte[])object);
        }
        this.interp.resetResult();
        compiledClassReady.compiled(string3, string, string4, arrayList, arrayList2, 0, "");
    }

    protected void finalize() throws Throwable {
        if (debug) {
            System.out.println("TJCThread finalized");
        }
        super.finalize();
    }

    public static interface CompiledClassReady {
        public void compiled(String var1, String var2, String var3, ArrayList var4, ArrayList var5, int var6, String var7);
    }
}

