/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel;

import java.util.EnumSet;
import org.jsoar.kernel.Agent;
import org.jsoar.kernel.Decider;
import org.jsoar.kernel.DecisionCycle;
import org.jsoar.kernel.ImpasseType;
import org.jsoar.kernel.Phase;
import org.jsoar.kernel.SavedFiringType;
import org.jsoar.kernel.memory.Preference;
import org.jsoar.kernel.memory.RecognitionMemory;
import org.jsoar.kernel.memory.Slot;
import org.jsoar.kernel.memory.TemporaryMemory;
import org.jsoar.kernel.memory.WmeImpl;
import org.jsoar.kernel.rete.SoarReteListener;
import org.jsoar.kernel.symbols.IdentifierImpl;
import org.jsoar.kernel.symbols.SymbolImpl;
import org.jsoar.kernel.tracing.Trace;
import org.jsoar.util.ByRef;
import org.jsoar.util.adaptables.Adaptables;

public class Consistency {
    private static final boolean DEBUG_CONSISTENCY_CHECK = false;
    private final Agent context;
    private Decider decider;
    private DecisionCycle decisionCycle;
    private TemporaryMemory tempMemory;
    private RecognitionMemory recMemory;
    private SoarReteListener soarReteListener;

    public Consistency(Agent context) {
        this.context = context;
    }

    public void initialize() {
        this.decider = Adaptables.adapt(this.context, Decider.class);
        this.decisionCycle = Adaptables.adapt(this.context, DecisionCycle.class);
        this.tempMemory = Adaptables.adapt(this.context, TemporaryMemory.class);
        this.recMemory = Adaptables.adapt(this.context, RecognitionMemory.class);
        this.soarReteListener = Adaptables.adapt(this.context, SoarReteListener.class);
    }

    private boolean decision_consistent_with_current_preferences(IdentifierImpl goal, Slot s) {
        ByRef<Object> candidates;
        ImpasseType new_impasse_type;
        SymbolImpl current_impasse_attribute;
        ImpasseType current_impasse_type;
        boolean operator_in_slot;
        WmeImpl current_operator;
        if (goal.goalInfo.operator_slot.getWmes() != null) {
            current_operator = goal.goalInfo.operator_slot.getWmes();
            operator_in_slot = true;
        } else {
            current_operator = null;
            operator_in_slot = false;
        }
        if (goal.goalInfo.lower_goal != null) {
            current_impasse_type = this.decider.type_of_existing_impasse(goal);
            current_impasse_attribute = this.decider.attribute_of_existing_impasse(goal);
            if (operator_in_slot && current_impasse_type == ImpasseType.NO_CHANGE) {
                current_impasse_type = ImpasseType.NONE;
            }
        } else {
            current_impasse_type = ImpasseType.NONE;
            current_impasse_attribute = null;
        }
        if (current_impasse_type != (new_impasse_type = this.decider.run_preference_semantics(s, candidates = ByRef.create(null), true))) {
            return false;
        }
        switch (new_impasse_type) {
            case NONE: {
                if (operator_in_slot) {
                    Preference cand = (Preference)candidates.value;
                    while (cand != null) {
                        if (current_operator.value == cand.value) {
                            return true;
                        }
                        cand = cand.next_candidate;
                    }
                    return false;
                }
                if (goal.goalInfo.lower_goal != null) {
                    this.context.getPrinter().warn("      No Impasse Needed but Impasse exists: remove impasse now\n");
                    this.context.getPrinter().warn("\n\n   *************This should never be executed*******************\n\n");
                    return false;
                }
                this.context.getPrinter().warn("\n\n   *************This should never be executed*******************\n\n");
                return true;
            }
            case CONSTRAINT_FAILURE: {
                return true;
            }
            case CONFLICT: {
                return true;
            }
            case TIE: {
                return true;
            }
            case NO_CHANGE: {
                return true;
            }
        }
        this.context.getPrinter().warn("\n   After switch................");
        this.context.getPrinter().warn("\n\n   *************This should never be executed*******************\n\n");
        return true;
    }

    private void remove_current_decision(Slot s) {
        Trace trace = this.context.getTrace();
        if (s.getWmes() == null) {
            trace.print(Trace.Category.OPERAND2_REMOVALS, "\n       REMOVING CONTEXT SLOT: Slot IdentifierImpl [%s] and attribute [%s]\n", s.id, s.attr);
        }
        if (s.id != null) {
            trace.print(Trace.Category.OPERAND2_REMOVALS, "\n          Decision for goal [%s] is inconsistent.  Replacing it with....\n", s.id);
        }
        this.decider.remove_wmes_for_context_slot(s);
        if (s.id.goalInfo.lower_goal != null) {
            this.decider.remove_existing_context_and_descendents(s.id.goalInfo.lower_goal);
        }
        this.decider.do_buffered_wm_and_ownership_changes();
    }

    private boolean check_context_slot_decisions(int level) {
        IdentifierImpl goal = this.tempMemory.highest_goal_whose_context_changed;
        while (goal != null && goal.level <= level) {
            Slot s = goal.goalInfo.operator_slot;
            if (!(goal.goalInfo.lower_goal == null && s.getWmes() == null || s.changed == null || this.decision_consistent_with_current_preferences(goal, s))) {
                this.context.getTrace().print(EnumSet.of(Trace.Category.VERBOSE, Trace.Category.WM_CHANGES), "Removing state %s because of a failed consistency check.\n", goal);
                this.remove_current_decision(s);
                return false;
            }
            goal = goal.goalInfo.lower_goal;
        }
        return true;
    }

    private boolean i_activity_at_goal(IdentifierImpl goal) {
        if (!goal.goalInfo.ms_i_assertions.isEmpty()) {
            return true;
        }
        return !goal.goalInfo.ms_retractions.isEmpty();
    }

    private boolean minor_quiescence_at_goal(IdentifierImpl goal) {
        return this.recMemory.FIRING_TYPE == SavedFiringType.IE_PRODS && !this.i_activity_at_goal(goal);
    }

    public IdentifierImpl highest_active_goal_propose(IdentifierImpl start_goal, boolean noneOk) {
        IdentifierImpl goal = start_goal;
        while (goal != null) {
            if (!goal.goalInfo.ms_i_assertions.isEmpty() || !goal.goalInfo.ms_retractions.isEmpty()) {
                return goal;
            }
            goal = goal.goalInfo.lower_goal;
        }
        if (!this.soarReteListener.nil_goal_retractions.isEmpty()) {
            return null;
        }
        if (!noneOk) {
            this.context.getTrace().flush();
            throw new IllegalStateException("Unable to find an active goal when not at quiescence.");
        }
        return null;
    }

    public IdentifierImpl highest_active_goal_apply(IdentifierImpl start_goal, boolean noneOk) {
        IdentifierImpl goal = start_goal;
        while (goal != null) {
            if (!(goal.goalInfo.ms_i_assertions.isEmpty() && goal.goalInfo.ms_o_assertions.isEmpty() && goal.goalInfo.ms_retractions.isEmpty())) {
                return goal;
            }
            goal = goal.goalInfo.lower_goal;
        }
        if (!this.soarReteListener.nil_goal_retractions.isEmpty()) {
            return null;
        }
        if (!noneOk) {
            throw new IllegalStateException("Unable to find an active goal when not at quiescence.");
        }
        return null;
    }

    private SavedFiringType active_production_type_at_goal(IdentifierImpl goal) {
        if (this.i_activity_at_goal(goal)) {
            return SavedFiringType.IE_PRODS;
        }
        return SavedFiringType.PE_PRODS;
    }

    private boolean goal_stack_consistent_through_goal(IdentifierImpl goal) {
        boolean test = this.check_context_slot_decisions(goal.level);
        return test;
    }

    public void initialize_consistency_calculations_for_new_decision() {
        this.decider.active_level = 0;
        this.decider.active_goal = null;
        IdentifierImpl goal = this.decider.top_goal;
        while (goal != null) {
            goal.goalInfo.saved_firing_type = SavedFiringType.NO_SAVED_PRODS;
            goal = goal.goalInfo.lower_goal;
        }
    }

    public void determine_highest_active_production_level_in_stack_apply() {
        int diff;
        if (!this.soarReteListener.any_assertions_or_retractions_ready()) {
            if (this.minor_quiescence_at_goal(this.decider.bottom_goal)) {
                this.goal_stack_consistent_through_goal(this.decider.bottom_goal);
            }
            this.decisionCycle.current_phase.set(Phase.OUTPUT);
            return;
        }
        if (this.decisionCycle.checkForMaxElaborations(Phase.OUTPUT)) {
            return;
        }
        this.decider.previous_active_goal = this.decider.active_goal;
        this.decider.previous_active_level = this.decider.active_level;
        this.decider.active_goal = this.highest_active_goal_apply(this.decider.top_goal, false);
        this.decider.active_level = this.decider.active_goal != null ? this.decider.active_goal.level : 0;
        LevelChangeType level_change_type = this.decider.active_goal == null ? LevelChangeType.NIL_GOAL_RETRACTIONS : (this.decider.previous_active_level == 0 ? LevelChangeType.NEW_DECISION : ((diff = this.decider.active_level - this.decider.previous_active_level) == 0 ? LevelChangeType.SAME_LEVEL : (diff > 0 ? LevelChangeType.LOWER_LEVEL : LevelChangeType.HIGHER_LEVEL)));
        switch (level_change_type) {
            case NIL_GOAL_RETRACTIONS: {
                this.recMemory.FIRING_TYPE = SavedFiringType.IE_PRODS;
                break;
            }
            case NEW_DECISION: {
                this.recMemory.FIRING_TYPE = this.active_production_type_at_goal(this.decider.active_goal);
                break;
            }
            case LOWER_LEVEL: {
                if (this.minor_quiescence_at_goal(this.decider.previous_active_goal) && !this.goal_stack_consistent_through_goal(this.decider.previous_active_goal)) {
                    this.decisionCycle.current_phase.set(Phase.OUTPUT);
                    break;
                }
                IdentifierImpl goal = this.decider.active_goal;
                if (goal.goalInfo.saved_firing_type != SavedFiringType.NO_SAVED_PRODS) {
                    this.recMemory.FIRING_TYPE = goal.goalInfo.saved_firing_type;
                    this.determine_highest_active_production_level_in_stack_apply();
                    break;
                }
                this.recMemory.FIRING_TYPE = this.active_production_type_at_goal(this.decider.active_goal);
                break;
            }
            case SAME_LEVEL: {
                if (this.minor_quiescence_at_goal(this.decider.active_goal) && !this.goal_stack_consistent_through_goal(this.decider.active_goal)) {
                    this.decisionCycle.current_phase.set(Phase.OUTPUT);
                    break;
                }
                this.recMemory.FIRING_TYPE = this.active_production_type_at_goal(this.decider.active_goal);
                break;
            }
            case HIGHER_LEVEL: {
                IdentifierImpl goal = this.decider.previous_active_goal;
                goal.goalInfo.saved_firing_type = this.recMemory.FIRING_TYPE;
                if (!this.goal_stack_consistent_through_goal(this.decider.active_goal)) {
                    this.decisionCycle.current_phase.set(Phase.OUTPUT);
                    break;
                }
                this.recMemory.FIRING_TYPE = this.active_production_type_at_goal(this.decider.active_goal);
            }
        }
    }

    public void determine_highest_active_production_level_in_stack_propose() {
        int diff;
        if (this.soarReteListener.ms_retractions == null && this.soarReteListener.ms_i_assertions == null && this.minor_quiescence_at_goal(this.decider.bottom_goal)) {
            this.goal_stack_consistent_through_goal(this.decider.bottom_goal);
            this.decisionCycle.current_phase.set(Phase.DECISION);
            return;
        }
        if (this.decisionCycle.checkForMaxElaborations(Phase.DECISION)) {
            return;
        }
        this.decider.previous_active_goal = this.decider.active_goal;
        this.decider.previous_active_level = this.decider.active_level;
        this.decider.active_goal = this.highest_active_goal_propose(this.decider.top_goal, false);
        this.decider.active_level = this.decider.active_goal != null ? this.decider.active_goal.level : 0;
        LevelChangeType level_change_type = this.decider.active_goal == null ? LevelChangeType.NIL_GOAL_RETRACTIONS : (this.decider.previous_active_level == 0 ? LevelChangeType.NEW_DECISION : ((diff = this.decider.active_level - this.decider.previous_active_level) == 0 ? LevelChangeType.SAME_LEVEL : (diff > 0 ? LevelChangeType.LOWER_LEVEL : LevelChangeType.HIGHER_LEVEL)));
        switch (level_change_type) {
            case NIL_GOAL_RETRACTIONS: {
                this.recMemory.FIRING_TYPE = SavedFiringType.IE_PRODS;
                break;
            }
            case NEW_DECISION: {
                this.recMemory.FIRING_TYPE = SavedFiringType.IE_PRODS;
                break;
            }
            case LOWER_LEVEL: {
                if (!this.goal_stack_consistent_through_goal(this.decider.previous_active_goal)) {
                    this.decisionCycle.current_phase.set(Phase.DECISION);
                    break;
                }
                this.recMemory.FIRING_TYPE = SavedFiringType.IE_PRODS;
                break;
            }
            case SAME_LEVEL: {
                this.recMemory.FIRING_TYPE = SavedFiringType.IE_PRODS;
                break;
            }
            case HIGHER_LEVEL: {
                IdentifierImpl goal = this.decider.previous_active_goal;
                goal.goalInfo.saved_firing_type = this.recMemory.FIRING_TYPE;
                if (!this.goal_stack_consistent_through_goal(this.decider.active_goal)) {
                    this.decisionCycle.current_phase.set(Phase.DECISION);
                    break;
                }
                this.recMemory.FIRING_TYPE = SavedFiringType.IE_PRODS;
            }
        }
    }

    private static enum LevelChangeType {
        NEW_DECISION,
        SAME_LEVEL,
        HIGHER_LEVEL,
        LOWER_LEVEL,
        NIL_GOAL_RETRACTIONS;

    }
}

