/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel;

import org.jsoar.kernel.AbstractDebuggerProvider;
import org.jsoar.kernel.Agent;
import org.jsoar.kernel.DebuggerProvider;
import org.jsoar.kernel.SoarException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDebuggerProvider
extends AbstractDebuggerProvider {
    private static final Logger logger = LoggerFactory.getLogger(DefaultDebuggerProvider.class);
    public static final String PROPERTY = "jsoar.debugger.provider";
    public static final String DEFAULT_CLASS = "org.jsoar.debugger.DefaultDebuggerProvider";

    @Override
    public void openDebugger(Agent agent) throws SoarException {
        this.loadProvider().openDebugger(agent);
    }

    @Override
    public void openDebuggerAndWait(Agent agent) throws SoarException, InterruptedException {
        this.loadProvider().openDebuggerAndWait(agent);
    }

    private synchronized DebuggerProvider loadProvider() throws SoarException {
        String className = System.getProperty(PROPERTY, DEFAULT_CLASS);
        try {
            Class<?> klass = Class.forName(className);
            Object o = klass.newInstance();
            if (o instanceof DebuggerProvider) {
                DebuggerProvider p = (DebuggerProvider)o;
                p.setProperties(this.getProperties());
                return p;
            }
            logger.error("Expected instance of " + DebuggerProvider.class + ", got " + klass);
            throw new SoarException("Expected instance of " + DebuggerProvider.class + ", got " + klass);
        }
        catch (ClassNotFoundException e) {
            logger.error("Could not find default debugger provider class 'org.jsoar.debugger.DefaultDebuggerProvider'");
            throw new SoarException("Could not find default debugger provider class 'org.jsoar.debugger.DefaultDebuggerProvider'");
        }
        catch (InstantiationException e) {
            logger.error("Error instantiated debugger provider class 'org.jsoar.debugger.DefaultDebuggerProvider': " + e.getMessage(), (Throwable)e);
            throw new SoarException("Error instantiated debugger provider class 'org.jsoar.debugger.DefaultDebuggerProvider': " + e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            logger.error("Error instantiated debugger provider class 'org.jsoar.debugger.DefaultDebuggerProvider': " + e.getMessage(), (Throwable)e);
            throw new SoarException("Error instantiated debugger provider class 'org.jsoar.debugger.DefaultDebuggerProvider': " + e.getMessage(), e);
        }
    }
}

