/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jsoar.kernel.Agent;
import org.jsoar.kernel.Production;
import org.jsoar.kernel.ProductionManager;
import org.jsoar.kernel.ProductionType;
import org.jsoar.kernel.events.ProductionAddedEvent;
import org.jsoar.kernel.events.ProductionExcisedEvent;
import org.jsoar.kernel.learning.rl.ReinforcementLearning;
import org.jsoar.kernel.lhs.ConditionReorderer;
import org.jsoar.kernel.parser.Parser;
import org.jsoar.kernel.parser.ParserContext;
import org.jsoar.kernel.parser.ParserException;
import org.jsoar.kernel.parser.original.OriginalParser;
import org.jsoar.kernel.rete.ProductionAddResult;
import org.jsoar.kernel.rete.Rete;
import org.jsoar.kernel.rhs.ActionReorderer;
import org.jsoar.kernel.rhs.ReordererException;
import org.jsoar.kernel.smem.DefaultSemanticMemory;
import org.jsoar.kernel.symbols.SymbolFactoryImpl;
import org.jsoar.kernel.tracing.Trace;
import org.jsoar.util.Arguments;
import org.jsoar.util.DefaultSourceLocation;
import org.jsoar.util.SourceLocation;
import org.jsoar.util.adaptables.Adaptables;

public class DefaultProductionManager
implements ProductionManager {
    private final Agent context;
    private SymbolFactoryImpl syms;
    private Rete rete;
    private ReinforcementLearning rl;
    private SourceLocation currentSourceLocation;
    private final ParserContext parserContext = new ParserContext(){

        @Override
        public Object getAdapter(Class<?> klass) {
            if (klass.equals(SourceLocation.class)) {
                return DefaultProductionManager.this.currentSourceLocation;
            }
            return Adaptables.adapt(DefaultProductionManager.this.context, klass);
        }
    };
    private Parser parser = new OriginalParser();
    private EnumMap<ProductionType, Set<Production>> productionsByType = new EnumMap(ProductionType.class);
    private Map<String, Production> productionsByName;

    DefaultProductionManager(Agent context) {
        for (ProductionType type : ProductionType.values()) {
            this.productionsByType.put(type, new LinkedHashSet());
        }
        this.productionsByName = new HashMap<String, Production>();
        this.context = context;
    }

    void initialize() {
        this.syms = Adaptables.require(this.getClass(), this.context, SymbolFactoryImpl.class);
        this.rete = Adaptables.require(this.getClass(), this.context, Rete.class);
        this.rl = Adaptables.require(this.getClass(), this.context, ReinforcementLearning.class);
    }

    void resetStatistics() {
        for (Production p : this.productionsByName.values()) {
            p.resetFiringCount();
        }
    }

    @Override
    public void addChunk(Production p) throws ReordererException {
        if (p.getType() != ProductionType.CHUNK && p.getType() != ProductionType.JUSTIFICATION) {
            throw new IllegalArgumentException("Production '" + p + "' is not a chunk or justification");
        }
        p.reorder(this.syms.getVariableGenerator(), new ConditionReorderer(this.syms.getVariableGenerator(), this.context.getTrace(), this.context.getMultiAttributes(), p.getName()), new ActionReorderer(this.context.getPrinter(), p.getName()), false);
        this.validateLongTermIdentifiersInProduction(p);
        this.rl.addProduction(p);
        this.productionsByType.get((Object)p.getType()).add(p);
        this.productionsByName.put(p.getName(), p);
    }

    @Override
    public void exciseProduction(Production prod, boolean print_sharp_sign) {
        this.context.getEvents().fireEvent(new ProductionExcisedEvent(this.context, prod));
        this.productionsByType.get((Object)prod.getType()).remove(prod);
        this.productionsByName.remove(prod.getName());
        this.rl.exciseProduction(prod);
        if (print_sharp_sign) {
            this.context.getPrinter().print("#").flush();
        }
        if (prod.getReteNode() != null) {
            this.rete.excise_production_from_rete(prod);
        }
    }

    @Override
    public Production getProduction(String name) {
        return this.productionsByName.get(name);
    }

    @Override
    public List<Production> getProductions(ProductionType type) {
        ArrayList<Production> result;
        if (type != null) {
            Set<Production> ofType = this.productionsByType.get((Object)type);
            result = new ArrayList<Production>(ofType);
        } else {
            result = new ArrayList(this.getProductionCount());
            for (Set<Production> ofType : this.productionsByType.values()) {
                result.addAll(ofType);
            }
        }
        return result;
    }

    @Override
    public Parser getParser() {
        return this.parser;
    }

    @Override
    public void setParser(Parser parser) {
        Arguments.checkNotNull(parser, "parser");
        this.parser = parser;
    }

    @Override
    public Production loadProduction(String productionBody) throws ReordererException, ParserException {
        return this.loadProduction(productionBody, DefaultSourceLocation.UNKNOWN);
    }

    @Override
    public Production loadProduction(String productionBody, SourceLocation location) throws ReordererException, ParserException {
        Arguments.checkNotNull(location, "location");
        this.currentSourceLocation = location;
        StringReader reader = new StringReader(productionBody);
        Production p = this.parser.parseProduction(this.parserContext, reader);
        if (p.getType() == ProductionType.CHUNK || p.getType() == ProductionType.JUSTIFICATION) {
            this.addChunk(p);
        } else {
            this.addProduction(p, true);
        }
        return p;
    }

    @Override
    public ProductionAddResult addProduction(Production p, boolean reorder_nccs) throws ReordererException {
        if (this.productionsByName.values().contains(p)) {
            throw new IllegalArgumentException("Production instance '" + p + " already added.");
        }
        if (p.getType() == ProductionType.CHUNK || p.getType() == ProductionType.JUSTIFICATION) {
            throw new IllegalArgumentException("Chunk or justification passed to addProduction: " + p);
        }
        Production existing = this.getProduction(p.getName());
        if (existing != null) {
            this.exciseProduction(existing, this.context.getTrace().isEnabled(Trace.Category.LOADING));
        }
        p.reorder(this.syms.getVariableGenerator(), new ConditionReorderer(this.syms.getVariableGenerator(), this.context.getTrace(), this.context.getMultiAttributes(), p.getName()), new ActionReorderer(this.context.getPrinter(), p.getName()), reorder_nccs);
        this.validateLongTermIdentifiersInProduction(p);
        this.rl.addProduction(p);
        ProductionAddResult result = this.rete.add_production_to_rete(p);
        if (result == ProductionAddResult.DUPLICATE_PRODUCTION) {
            this.exciseProduction(p, false);
            return result;
        }
        this.productionsByType.get((Object)p.getType()).add(p);
        this.productionsByName.put(p.getName(), p);
        this.context.getEvents().fireEvent(new ProductionAddedEvent(this.context, p));
        return result;
    }

    private void validateLongTermIdentifiersInProduction(Production p) {
        if (p.getType() != ProductionType.JUSTIFICATION && !DefaultSemanticMemory.smem_valid_production(p.getFirstCondition(), p.getFirstAction())) {
            throw new IllegalArgumentException("Ungrounded LTI in production: " + p);
        }
    }

    @Override
    public Map<ProductionType, Integer> getProductionCounts() {
        EnumMap<ProductionType, Integer> counts = new EnumMap<ProductionType, Integer>(ProductionType.class);
        for (ProductionType type : ProductionType.values()) {
            counts.put(type, 0);
        }
        for (Map.Entry entry : this.productionsByType.entrySet()) {
            counts.put((ProductionType)((Object)entry.getKey()), ((Set)entry.getValue()).size());
        }
        return Collections.unmodifiableMap(counts);
    }

    @Override
    public int getProductionCount() {
        return this.productionsByName.size();
    }

    public void addProductionToNameTypeMaps(Production p) {
        this.productionsByType.get((Object)p.getType()).add(p);
        this.productionsByName.put(p.getName(), p);
    }
}

