/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel;

import java.io.StringReader;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jsoar.kernel.Agent;
import org.jsoar.kernel.Production;
import org.jsoar.kernel.lhs.Condition;
import org.jsoar.kernel.lhs.ConjunctiveNegationCondition;
import org.jsoar.kernel.lhs.ConjunctiveTest;
import org.jsoar.kernel.lhs.Test;
import org.jsoar.kernel.lhs.Tests;
import org.jsoar.kernel.lhs.ThreeFieldCondition;
import org.jsoar.kernel.parser.ParserContext;
import org.jsoar.kernel.parser.ParserException;
import org.jsoar.kernel.parser.original.OriginalParser;
import org.jsoar.kernel.rete.ConditionsAndNots;
import org.jsoar.kernel.rete.Rete;
import org.jsoar.kernel.rhs.Action;
import org.jsoar.kernel.rhs.MakeAction;
import org.jsoar.kernel.symbols.Symbol;
import org.jsoar.kernel.symbols.SymbolImpl;
import org.jsoar.util.ByRef;
import org.jsoar.util.ListHead;
import org.jsoar.util.ListItem;
import org.jsoar.util.adaptables.Adaptables;

public class ProductionFinder {
    private final EnumSet<Options> options = EnumSet.allOf(Options.class);
    private final Agent agnt;
    private final ParserContext parserContext = new ParserContext(){

        @Override
        public Object getAdapter(Class<?> klass) {
            return ProductionFinder.this.agnt.getAdapter(klass);
        }
    };

    public ProductionFinder(Agent agent) {
        this.agnt = agent;
    }

    public EnumSet<Options> options() {
        return this.options;
    }

    public List<Production> find(String pattern, Collection<Production> productions) throws ParserException {
        LinkedList<Production> current_pf_list = new LinkedList<Production>();
        if (this.options.contains((Object)Options.LHS)) {
            this.read_pattern_and_get_matching_productions(pattern, productions, current_pf_list);
        }
        if (this.options.contains((Object)Options.RHS)) {
            this.read_rhs_pattern_and_get_matching_productions(pattern, productions, current_pf_list);
        }
        return current_pf_list;
    }

    private Symbol get_binding(Symbol f, ListHead<Binding> bindings) {
        for (Binding b : bindings) {
            if (b.from != f) continue;
            return b.to;
        }
        return null;
    }

    private boolean symbols_are_equal_with_bindings(SymbolImpl s1, SymbolImpl s2, ListHead<Binding> bindings) {
        if (s1 == s2 && s1.asVariable() == null) {
            return true;
        }
        if (s1.asString() != null && s1.asString().getValue().equals("*")) {
            return true;
        }
        if (s2.asString() != null && s2.asString().getValue().equals("*")) {
            return true;
        }
        if (s1.asVariable() == null || s2.asVariable() == null) {
            return false;
        }
        Symbol bvar = this.get_binding(s1, bindings);
        if (bvar == null) {
            bindings.push(new Binding(s1, s2));
            return true;
        }
        return bvar == s2;
    }

    private boolean actions_are_equal_with_bindings(Action a1, Action a2, ListHead<Binding> bindings) {
        if (a2.asFunctionAction() != null) {
            return false;
        }
        MakeAction m1 = a1.asMakeAction();
        MakeAction m2 = a2.asMakeAction();
        if (m1.preference_type != m2.preference_type) {
            return false;
        }
        if (!this.symbols_are_equal_with_bindings(m1.id.asSymbolValue().getSym(), m2.id.asSymbolValue().getSym(), bindings)) {
            return false;
        }
        if (m1.attr.asSymbolValue() != null && m2.attr.asSymbolValue() != null && !this.symbols_are_equal_with_bindings(m1.attr.asSymbolValue().getSym(), m2.attr.asSymbolValue().getSym(), bindings)) {
            return false;
        }
        if (m1.value.asSymbolValue() != null && m2.value.asSymbolValue() != null) {
            return this.symbols_are_equal_with_bindings(m1.value.asSymbolValue().getSym(), m2.value.asSymbolValue().getSym(), bindings);
        }
        if (m1.value.asFunctionCall() != null && m2.value.asFunctionCall() != null) {
            return false;
        }
        return false;
    }

    private void reset_old_binding_point(ListHead<Binding> bindings, ListItem<Binding> current_binding_point) {
        while (bindings.first != current_binding_point) {
            bindings.pop();
        }
    }

    private boolean tests_are_equal_with_bindings(Test t1, Test test2, ListHead<Binding> bindings) {
        if (Tests.isBlank(t1)) {
            return !Tests.isBlank(test2);
        }
        Test t2 = !Tests.test_includes_goal_or_impasse_id_test(t1, true, false) && Tests.test_includes_goal_or_impasse_id_test(test2, true, false) ? Tests.copy_test_removing_goal_impasse_tests(test2, ByRef.create(false), ByRef.create(false)) : Tests.copy(test2);
        if (t1.asEqualityTest() != null) {
            if (Tests.isBlank(t2) || t2.asEqualityTest() == null) {
                return false;
            }
            return this.symbols_are_equal_with_bindings(t1.asEqualityTest().getReferent(), t2.asEqualityTest().getReferent(), bindings);
        }
        if (t1.asGoalIdTest() != null && t2.asGoalIdTest() != null) {
            return true;
        }
        if (t1.asImpasseIdTest() != null && t2.asImpasseIdTest() != null) {
            return true;
        }
        if (t1.asDisjunctionTest() != null && t2.asDisjunctionTest() != null) {
            return t1.asDisjunctionTest().disjunction_list.equals(t2.asDisjunctionTest().disjunction_list);
        }
        if (t1.asConjunctiveTest() != null && t2.asConjunctiveTest() != null) {
            ConjunctiveTest ct1 = t1.asConjunctiveTest();
            ConjunctiveTest ct2 = t2.asConjunctiveTest();
            if (ct1.conjunct_list.size() != ct2.conjunct_list.size()) {
                return false;
            }
            Iterator<Test> it1 = ct1.conjunct_list.iterator();
            Iterator<Test> it2 = ct2.conjunct_list.iterator();
            while (it1.hasNext()) {
                if (this.tests_are_equal_with_bindings(it1.next(), it2.next(), bindings)) continue;
                return false;
            }
            return true;
        }
        return this.symbols_are_equal_with_bindings(t1.asRelationalTest().referent, t2.asRelationalTest().referent, bindings);
    }

    private boolean conditions_are_equal_with_bindings(Condition c1, Condition c2, ListHead<Binding> bindings) {
        ThreeFieldCondition tfc1 = c1.asThreeFieldCondition();
        ThreeFieldCondition tfc2 = c2.asThreeFieldCondition();
        if (tfc1 != null && tfc2 != null) {
            if (!this.tests_are_equal_with_bindings(tfc1.id_test, tfc2.id_test, bindings)) {
                return false;
            }
            if (!this.tests_are_equal_with_bindings(tfc1.attr_test, tfc2.attr_test, bindings)) {
                return false;
            }
            if (!this.tests_are_equal_with_bindings(tfc1.value_test, tfc2.value_test, bindings)) {
                return false;
            }
            return tfc1.test_for_acceptable_preference == tfc2.test_for_acceptable_preference;
        }
        ConjunctiveNegationCondition ncc1 = c1.asConjunctiveNegationCondition();
        ConjunctiveNegationCondition ncc2 = c2.asConjunctiveNegationCondition();
        if (ncc1 != null && ncc2 != null) {
            c1 = ncc1.top;
            c2 = ncc2.top;
            while (c1 != null && c2 != null) {
                if (!this.conditions_are_equal_with_bindings(c1, c2, bindings)) {
                    return false;
                }
                c1 = c1.next;
                c2 = c2.next;
            }
            return c1 == c2;
        }
        return false;
    }

    private void read_pattern_and_get_matching_productions(String pattern, Collection<Production> productions, List<Production> current_pf_list) throws ParserException {
        OriginalParser parser = new OriginalParser();
        Condition clist = parser.parseLeftHandSide(this.parserContext, new StringReader(pattern));
        Rete rete = Adaptables.adapt(this.agnt, Rete.class);
        for (Production prod : productions) {
            boolean match = true;
            ConditionsAndNots cans = rete.p_node_to_conditions_and_nots(prod.getReteNode(), null, null, false);
            ListHead<Binding> bindings = ListHead.newInstance();
            ListItem<Binding> current_binding_point = null;
            Condition c = clist;
            while (c != null) {
                boolean match_this_c = false;
                current_binding_point = bindings.first;
                Condition pc = cans.top;
                while (pc != null) {
                    if (this.conditions_are_equal_with_bindings(c, pc, bindings)) {
                        match_this_c = true;
                        break;
                    }
                    this.reset_old_binding_point(bindings, current_binding_point);
                    bindings.first = current_binding_point;
                    pc = pc.next;
                }
                if (!match_this_c) {
                    match = false;
                    break;
                }
                c = c.next;
            }
            if (!match) continue;
            current_pf_list.add(prod);
        }
    }

    private void read_rhs_pattern_and_get_matching_productions(String pattern, Collection<Production> productions, List<Production> current_pf_list) throws ParserException {
        Action alist = new OriginalParser().parseRightHandSide(this.parserContext, new StringReader(pattern));
        Rete rete = Adaptables.adapt(this.agnt, Rete.class);
        for (Production prod : productions) {
            boolean match = true;
            ListHead<Binding> bindings = ListHead.newInstance();
            ConditionsAndNots cans = rete.p_node_to_conditions_and_nots(prod.getReteNode(), null, null, true);
            Action a = alist;
            while (a != null) {
                boolean match_this_a = false;
                ListItem<Binding> current_binding_point = bindings.first;
                Action pa = cans.actions;
                while (pa != null) {
                    if (this.actions_are_equal_with_bindings(a, pa, bindings)) {
                        match_this_a = true;
                        break;
                    }
                    this.reset_old_binding_point(bindings, current_binding_point);
                    bindings.first = current_binding_point;
                    pa = pa.next;
                }
                if (!match_this_a) {
                    match = false;
                    break;
                }
                a = a.next;
            }
            if (!match) continue;
            current_pf_list.add(prod);
        }
    }

    private static class Binding {
        private final Symbol from;
        private final Symbol to;

        Binding(Symbol from, Symbol to) {
            this.from = from;
            this.to = to;
        }

        public String toString() {
            return String.format("%s -> %s", this.from, this.to);
        }
    }

    public static enum Options {
        LHS,
        RHS;

    }
}

