/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.commands;

import com.google.common.collect.Lists;
import java.util.List;
import org.jsoar.kernel.Agent;
import org.jsoar.kernel.SoarException;
import org.jsoar.util.commands.OptionProcessor;
import org.jsoar.util.commands.SoarCommand;
import org.jsoar.util.commands.SoarCommandContext;

abstract class AbstractToggleCommand
implements SoarCommand {
    private static final String ERROR_MESSAGE = "Option must be one of [--on|--off|-e|-d|--enable|--disable]";
    private final OptionProcessor<Options> options = OptionProcessor.create();
    private final Agent agent;

    AbstractToggleCommand(Agent agent) {
        this.agent = agent;
        for (Options o : Options.values()) {
            this.options.newOption(o).done();
        }
    }

    public Agent getAgent() {
        return this.agent;
    }

    @Override
    public String execute(SoarCommandContext context, String[] args) throws SoarException {
        List<String> nonOpts = this.options.process(Lists.newArrayList((Object[])args));
        if (!nonOpts.isEmpty()) {
            throw new SoarException(ERROR_MESSAGE);
        }
        if (this.options.has(Options.enable) || this.options.has(Options.On)) {
            this.execute(this.agent, true);
        } else if (this.options.has(Options.disable) || this.options.has(Options.off)) {
            this.execute(this.agent, false);
        } else {
            return "The current " + args[0] + " setting is: " + (this.query(this.agent) ? "enabled" : "disabled");
        }
        return "";
    }

    protected abstract boolean query(Agent var1);

    protected abstract void execute(Agent var1, boolean var2) throws SoarException;

    private static enum Options {
        disable,
        enable,
        off,
        On;

    }
}

