/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jsoar.kernel.Agent;
import org.jsoar.kernel.SoarException;
import org.jsoar.kernel.commands.Utils;
import org.jsoar.kernel.symbols.DoubleSymbol;
import org.jsoar.kernel.symbols.Identifier;
import org.jsoar.kernel.symbols.IntegerSymbol;
import org.jsoar.kernel.symbols.JavaSymbol;
import org.jsoar.kernel.symbols.StringSymbol;
import org.jsoar.kernel.symbols.Symbol;
import org.jsoar.kernel.symbols.SymbolFactoryImpl;
import org.jsoar.kernel.symbols.Variable;
import org.jsoar.util.adaptables.Adaptables;
import org.jsoar.util.commands.SoarCommand;
import org.jsoar.util.commands.SoarCommandContext;
import org.jsoar.util.timing.DefaultExecutionTimer;
import org.jsoar.util.timing.ExecutionTimer;
import org.jsoar.util.timing.WallclockExecutionTimeSource;
import picocli.CommandLine;

public class DebugCommand
implements SoarCommand {
    private Agent agent;

    public DebugCommand(Agent agent) {
        this.agent = agent;
    }

    @Override
    public String execute(SoarCommandContext context, String[] args) throws SoarException {
        Utils.parseAndRun(this.agent, new Debug(this.agent), args);
        return "";
    }

    @Override
    public Object getCommand() {
        return new Debug(this.agent);
    }

    @CommandLine.Command(name="time", description={"Executes command and prints time spent"}, subcommands={CommandLine.HelpCommand.class})
    public static class Time
    implements Runnable {
        @CommandLine.ParentCommand
        Debug parent;
        @CommandLine.Parameters(description={"The Soar command"})
        String[] command = null;

        @Override
        public void run() {
            String result;
            if (this.command == null) {
                this.parent.agent.getPrinter().startNewLine().print("You must submit a command that you'd like timed.");
                return;
            }
            WallclockExecutionTimeSource real_source = new WallclockExecutionTimeSource();
            ExecutionTimer real = DefaultExecutionTimer.newInstance(real_source);
            String combined = "";
            for (String s : this.command) {
                combined = combined + s + " ";
            }
            combined = combined.substring(0, combined.length() - 1);
            real.start();
            try {
                result = this.parent.agent.getInterpreter().eval(combined);
            }
            catch (SoarException e) {
                this.parent.agent.getPrinter().startNewLine().print(e.getMessage());
                return;
            }
            real.pause();
            double seconds = real.getTotalSeconds();
            if (result == null) {
                result = new String();
            }
            result = result + "(-1s) proc - Note JSoar does not support measuring CPU time at the moment.\n";
            result = result + "(" + seconds + "s) real\n";
            this.parent.agent.getPrinter().startNewLine().print(result);
        }
    }

    @CommandLine.Command(name="internal-symbols", description={"Prints symbol table"}, subcommands={CommandLine.HelpCommand.class})
    public static class InternalSymbols
    implements Runnable {
        @CommandLine.ParentCommand
        Debug parent;

        @Override
        public void run() {
            List<Symbol> all = this.parent.syms.getAllSymbols();
            StringBuilder result = new StringBuilder();
            this.printSymbolsOfType(result, all, Identifier.class);
            this.printSymbolsOfType(result, all, StringSymbol.class);
            this.printSymbolsOfType(result, all, IntegerSymbol.class);
            this.printSymbolsOfType(result, all, DoubleSymbol.class);
            this.printSymbolsOfType(result, all, Variable.class);
            this.printSymbolsOfType(result, all, JavaSymbol.class);
            this.parent.agent.getPrinter().startNewLine().print(result.toString());
        }

        private <T extends Symbol> void printSymbolsOfType(StringBuilder result, List<Symbol> all, Class<T> klass) {
            List<String> asStrings = this.collectSymbolsOfType(all, klass);
            result.append("--- " + klass + " (" + asStrings.size() + ") ---\n");
            Collections.sort(asStrings);
            for (String s : asStrings) {
                result.append(s);
                result.append('\n');
            }
        }

        private <T extends Symbol> List<String> collectSymbolsOfType(List<Symbol> in, Class<T> klass) {
            ArrayList<String> result = new ArrayList<String>();
            for (Symbol s : in) {
                if (!klass.isInstance(s)) continue;
                result.add(s.toString());
            }
            return result;
        }
    }

    @CommandLine.Command(name="debug", description={"Contains low-level technical debugging commands"}, subcommands={CommandLine.HelpCommand.class, InternalSymbols.class, Time.class})
    public static class Debug
    implements Runnable {
        private Agent agent;
        private SymbolFactoryImpl syms;

        public Debug(Agent agent) {
            this.agent = agent;
            this.syms = Adaptables.adapt(agent, SymbolFactoryImpl.class);
        }

        @Override
        public void run() {
            this.agent.getPrinter().startNewLine().print("The 'debug' command contains low-level technical debugging commands.");
        }
    }
}

