/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.commands;

import org.jsoar.kernel.Agent;
import org.jsoar.kernel.SoarException;
import org.jsoar.kernel.commands.Utils;
import org.jsoar.util.commands.SoarCommand;
import org.jsoar.util.commands.SoarCommandContext;
import picocli.CommandLine;

public class DebuggerCommand
implements SoarCommand {
    private final Agent agent;

    public DebuggerCommand(Agent agent) {
        this.agent = agent;
    }

    @Override
    public String execute(SoarCommandContext context, String[] args) throws SoarException {
        Utils.parseAndRun(this.agent, new Debugger(this.agent), args);
        return "";
    }

    @Override
    public Object getCommand() {
        return new Debugger(this.agent);
    }

    @CommandLine.Command(name="debugger", description={"Opens the agent's debugger"}, subcommands={CommandLine.HelpCommand.class})
    public static class Debugger
    implements Runnable {
        private Agent agent;

        public Debugger(Agent agent) {
            this.agent = agent;
        }

        @Override
        public void run() {
            try {
                this.agent.openDebugger();
            }
            catch (SoarException e) {
                this.agent.getPrinter().startNewLine().print(e.getMessage());
            }
        }
    }
}

