/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.commands;

import org.jsoar.kernel.Agent;
import org.jsoar.kernel.SoarException;
import org.jsoar.kernel.commands.Utils;
import org.jsoar.util.commands.SoarCommand;
import org.jsoar.util.commands.SoarCommandContext;
import picocli.CommandLine;

public class EchoCommand
implements SoarCommand {
    private Agent agent;

    public EchoCommand(Agent agent) {
        this.agent = agent;
    }

    @Override
    public String execute(SoarCommandContext context, String[] args) throws SoarException {
        Utils.parseAndRun(this.agent, new Echo(this.agent), args);
        return "";
    }

    @Override
    public Object getCommand() {
        return new Echo(this.agent);
    }

    @CommandLine.Command(name="echo", description={"Outputs the given string"}, subcommands={CommandLine.HelpCommand.class})
    public static class Echo
    implements Runnable {
        private Agent agent;
        @CommandLine.Option(names={"-n", "--no-newline"}, description={"Suppress printing of the newline character"})
        boolean noNewline = false;
        @CommandLine.Parameters(description={"The string to output"})
        String[] outputString = null;

        public Echo(Agent agent) {
            this.agent = agent;
        }

        @Override
        public void run() {
            if (this.outputString != null) {
                for (int i = 0; i < this.outputString.length; ++i) {
                    if (i != 0) {
                        this.agent.getPrinter().print(" ");
                    }
                    this.agent.getPrinter().print(this.outputString[i]);
                }
            }
            if (!this.noNewline) {
                this.agent.getPrinter().print("\n");
            }
            this.agent.getPrinter().flush();
        }
    }
}

