/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.commands;

import org.jsoar.kernel.Agent;
import org.jsoar.kernel.SoarException;
import org.jsoar.kernel.commands.Utils;
import org.jsoar.kernel.learning.Explain;
import org.jsoar.util.adaptables.Adaptables;
import org.jsoar.util.commands.SoarCommand;
import org.jsoar.util.commands.SoarCommandContext;
import picocli.CommandLine;

public class ExplainBacktracesCommand
implements SoarCommand {
    private final Agent agent;

    public ExplainBacktracesCommand(Agent agent) {
        this.agent = agent;
    }

    @Override
    public String execute(SoarCommandContext context, String[] args) throws SoarException {
        Utils.parseAndRun(this.agent, new ExplainBacktraces(this.agent), args);
        return "";
    }

    @Override
    public Object getCommand() {
        return new ExplainBacktraces(this.agent);
    }

    @CommandLine.Command(name="explain-backtraces", description={"Allows you to explore how rules were learned"}, subcommands={CommandLine.HelpCommand.class})
    public static class ExplainBacktraces
    implements Runnable {
        private Agent agent;
        @CommandLine.Option(names={"-c", "--condition"}, description={"Explain why condition number n is in the chunk or justification"})
        Integer chunkNum = null;
        @CommandLine.Option(names={"-f", "--full"}, description={"Print the full backtrace for the named production"})
        boolean printFull = false;
        @CommandLine.Parameters(arity="0..1", description={"List all conditions and grounds for the chunk or justification"})
        String prodName = null;

        public ExplainBacktraces(Agent agent) {
            this.agent = agent;
        }

        @Override
        public void run() {
            Explain explain;
            int condition = -1;
            if (this.chunkNum != null) {
                try {
                    condition = this.chunkNum;
                }
                catch (NumberFormatException e) {
                    this.agent.getPrinter().startNewLine().print("Expected numeric argument for --condition option, got " + this.chunkNum);
                    return;
                }
            }
            if ((explain = Adaptables.adapt(this.agent, Explain.class)) == null) {
                this.agent.getPrinter().startNewLine().print("Internal error: Could not find Explain object in agent!");
                return;
            }
            if (this.prodName == null) {
                explain.explain_list_chunks();
            } else if (this.printFull) {
                explain.explain_trace_named_chunk(this.prodName);
            } else if (condition == -1) {
                explain.explain_cond_list(this.prodName);
            } else {
                explain.explain_chunk(this.prodName, condition);
            }
        }
    }
}

