/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.commands;

import java.util.concurrent.Callable;
import org.jsoar.kernel.Agent;
import org.jsoar.kernel.SoarException;
import org.jsoar.kernel.commands.Utils;
import org.jsoar.kernel.rhs.functions.RhsFunctionHandler;
import org.jsoar.kernel.rhs.functions.RhsFunctionManager;
import org.jsoar.util.commands.SoarCommand;
import org.jsoar.util.commands.SoarCommandContext;
import picocli.CommandLine;

public class HandlerCommand
implements SoarCommand {
    private final Agent agent;

    public HandlerCommand(Agent agent) {
        this.agent = agent;
    }

    @Override
    public String execute(SoarCommandContext context, String[] args) throws SoarException {
        return Utils.parseAndRun(new Handler(this.agent), args);
    }

    @Override
    public Object getCommand() {
        return new Handler(this.agent);
    }

    @CommandLine.Command(name="handler", description={"Prints, enables, or disables RHS functions"}, subcommands={CommandLine.HelpCommand.class})
    public static class Handler
    implements Callable<String> {
        private Agent agent;
        @CommandLine.Option(names={"on", "-e", "--on", "--enable"}, description={"Enables RHS function"})
        String functionToEnable = null;
        @CommandLine.Option(names={"off", "-d", "--off", "--disable"}, description={"Disables timers"})
        String functionToDisable = null;

        public Handler(Agent agent) {
            this.agent = agent;
        }

        @Override
        public String call() {
            RhsFunctionManager rhsFunctionManager = this.agent.getRhsFunctions();
            if (this.functionToEnable != null) {
                rhsFunctionManager.enableHandler(this.functionToEnable);
                return "RHS function enabled: " + this.functionToEnable;
            }
            if (this.functionToDisable != null) {
                rhsFunctionManager.disableHandler(this.functionToDisable);
                return "RHS function disabled: " + this.functionToDisable;
            }
            String result = "===== Disabled RHS Functions =====\n";
            for (RhsFunctionHandler handler : rhsFunctionManager.getDisabledHandlers()) {
                result = result + handler.getName() + "\n";
            }
            return result;
        }
    }
}

