/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.commands;

import org.jsoar.kernel.Agent;
import org.jsoar.kernel.JSoarVersion;
import org.jsoar.kernel.SoarException;
import org.jsoar.kernel.commands.Utils;
import org.jsoar.util.DefaultSourceLocation;
import org.jsoar.util.commands.DefaultSoarCommandContext;
import org.jsoar.util.commands.ParsedCommand;
import org.jsoar.util.commands.SoarCommand;
import org.jsoar.util.commands.SoarCommandContext;
import picocli.CommandLine;

public class HelpMainCommand
implements SoarCommand {
    private final Agent agent;

    public HelpMainCommand(Agent agent) {
        this.agent = agent;
    }

    @Override
    public String execute(SoarCommandContext context, String[] args) throws SoarException {
        Utils.parseAndRun(this.agent, new Help(this.agent), args);
        return "";
    }

    @Override
    public Object getCommand() {
        return new Help(this.agent);
    }

    @CommandLine.Command(name="help", description={"Displays help information about the specified command"}, subcommands={CommandLine.HelpCommand.class})
    public static class Help
    implements Runnable {
        private final Agent agent;
        @CommandLine.Unmatched
        private String[] remainder;
        @CommandLine.Parameters(description={"The command to display information for"}, arity="0..1")
        private String command = null;

        public Help(Agent agent) {
            this.agent = agent;
        }

        @Override
        public void run() {
            if (this.command == null) {
                this.agent.getPrinter().print("JSoar " + JSoarVersion.getInstance().getVersion() + " Command List:\n\r");
                try {
                    for (String command : this.agent.getInterpreter().getCommandStrings()) {
                        this.agent.getPrinter().startNewLine().print(command);
                    }
                }
                catch (SoarException e) {
                    this.agent.getPrinter().error(e.getMessage());
                }
                this.agent.getPrinter().startNewLine().print("\n\rNote: Many previous Soar commands are now sub-commands. To locate a help entry, try 'help <old command name>'.");
            } else {
                try {
                    ParsedCommand parsedCommand = this.agent.getInterpreter().getParsedCommand(this.command, DefaultSourceLocation.newBuilder().build());
                    SoarCommand soarCommand = this.agent.getInterpreter().getCommand(parsedCommand.getArgs().get(0), parsedCommand.getLocation());
                    String result = soarCommand.execute(new DefaultSoarCommandContext(null), new String[]{parsedCommand.getArgs().get(0), "help"});
                    this.agent.getPrinter().startNewLine().print(result);
                }
                catch (SoarException e) {
                    this.agent.getPrinter().error(e.getMessage());
                }
            }
        }
    }
}

