/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.commands;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;
import org.jsoar.kernel.Agent;
import org.jsoar.kernel.SoarException;
import org.jsoar.kernel.commands.SourceCommand;
import org.jsoar.kernel.commands.Utils;
import org.jsoar.kernel.events.ProductionAddedEvent;
import org.jsoar.kernel.events.ProductionExcisedEvent;
import org.jsoar.kernel.rete.ReteSerializer;
import org.jsoar.util.FileTools;
import org.jsoar.util.StringTools;
import org.jsoar.util.commands.SoarCommand;
import org.jsoar.util.commands.SoarCommandContext;
import org.jsoar.util.events.SoarEvent;
import org.jsoar.util.events.SoarEventListener;
import picocli.CommandLine;

public class LoadCommand
implements SoarCommand {
    private SourceCommand sourceCommand;
    private Agent agent;

    public LoadCommand(SourceCommand sourceCommand, Agent agent) {
        this.sourceCommand = sourceCommand;
        this.agent = agent;
    }

    @Override
    public String execute(SoarCommandContext context, String[] args) throws SoarException {
        Utils.parseAndRun(this.agent, new Load(this.sourceCommand, this.agent), args);
        return "";
    }

    @Override
    public Object getCommand() {
        return new Load(this.sourceCommand, this.agent);
    }

    @CommandLine.Command(name="rete-net", description={"Restores an agent's productions from a binary file. Loading productions from a rete-net file causes all prior productions in memory to be excised."}, subcommands={CommandLine.HelpCommand.class})
    public static class ReteNet
    implements Runnable {
        @CommandLine.ParentCommand
        Load parent;
        @CommandLine.Option(names={"-l", "--load", "-r", "--restore"}, arity="1", description={"File name to load rete-net from"})
        String fileName = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            InputStream is = null;
            try {
                is = this.uncompressIfNeeded(this.fileName, this.findFile(this.fileName));
                ReteSerializer.replaceRete(this.parent.agent, is);
            }
            catch (IOException e) {
                this.parent.agent.getPrinter().startNewLine().print("Load file failed.");
                return;
            }
            catch (SoarException e) {
                this.parent.agent.getPrinter().startNewLine().print(e.getMessage());
                return;
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        this.parent.agent.getPrinter().startNewLine().print("IO error while closing the input source.");
                    }
                }
            }
            this.parent.agent.getPrinter().startNewLine().print("Rete loaded into agent");
        }

        private InputStream findFile(String fileString) throws SoarException, IOException {
            URL url = FileTools.asUrl(fileString);
            File file = new File(fileString);
            if (url != null) {
                return url.openStream();
            }
            if (file.isAbsolute()) {
                if (!file.exists()) {
                    this.parent.agent.getPrinter().startNewLine().print("File not found: " + fileString);
                }
                return new FileInputStream(file);
            }
            if (((Load)this.parent).sourceCommand.getWorkingDirectoryRaw().url != null) {
                URL childUrl = this.parent.sourceCommand.joinUrl(((Load)this.parent).sourceCommand.getWorkingDirectoryRaw().url, fileString);
                return childUrl.openStream();
            }
            if (!(file = new File(((Load)this.parent).sourceCommand.getWorkingDirectoryRaw().file, file.getPath())).exists()) {
                this.parent.agent.getPrinter().startNewLine().print("File not found: " + fileString);
            }
            return new FileInputStream(file);
        }

        private InputStream uncompressIfNeeded(String filename, InputStream is) throws IOException {
            if (filename.endsWith(".Z")) {
                return new GZIPInputStream(is);
            }
            return is;
        }
    }

    @CommandLine.Command(name="file", description={"Loads and evaluates the contents of a file."}, subcommands={CommandLine.HelpCommand.class})
    public static class FileC
    implements Runnable {
        @CommandLine.ParentCommand
        Load parent;
        @CommandLine.Option(names={"-a", "--all"}, description={"Enables a summary for each file sourced"})
        boolean loadSummary = false;
        @CommandLine.Option(names={"-d", "--disable"}, description={"Disables all summaries"})
        boolean disableSummaries = false;
        @CommandLine.Option(names={"-r", "--reload"}, description={"Reloads the last loaded file(s)"})
        boolean reload = false;
        @CommandLine.Option(names={"-v", "--verbose"}, description={"Prints all excised production names"})
        boolean printExcised = false;
        @CommandLine.Parameters(arity="0..*", description={"File names"})
        String[] fileNames = null;
        private final SoarEventListener eventListener = new SoarEventListener(){

            @Override
            public void onEvent(SoarEvent event) {
                if (event instanceof ProductionAddedEvent) {
                    ((Load)parent).sourceCommand.topLevelState.productionAdded(((ProductionAddedEvent)event).getProduction());
                } else if (event instanceof ProductionExcisedEvent) {
                    ((Load)parent).sourceCommand.topLevelState.productionExcised(((ProductionExcisedEvent)event).getProduction());
                }
            }
        };

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean topLevel;
            if (!this.reload && this.fileNames == null) {
                this.parent.agent.getPrinter().startNewLine().print("Error: file name(s) required");
                return;
            }
            boolean bl = topLevel = ((Load)this.parent).sourceCommand.topLevelState == null;
            if (topLevel && this.reload && ((Load)this.parent).sourceCommand.lastTopLevelCommand != null) {
                this.parent.agent.getPrinter().startNewLine().print("Reloaded: ");
                try {
                    this.parent.agent.getInterpreter().eval(StringTools.join(Arrays.asList(((Load)this.parent).sourceCommand.lastTopLevelCommand), " "));
                    return;
                }
                catch (SoarException e) {
                    this.parent.agent.getPrinter().startNewLine().print(e.getMessage());
                    return;
                }
            }
            if (!topLevel && this.reload) {
                this.parent.agent.getPrinter().startNewLine().print("--reload option only valid at top level");
                return;
            }
            if (((Load)this.parent).sourceCommand.lastTopLevelCommand == null && this.reload) {
                this.parent.agent.getPrinter().startNewLine().print("No previous file to reload");
                return;
            }
            if (topLevel) {
                ((Load)this.parent).sourceCommand.topLevelState = new SourceCommand.TopLevelState();
                ((Load)this.parent).sourceCommand.events.addListener(ProductionAddedEvent.class, this.eventListener);
                ((Load)this.parent).sourceCommand.events.addListener(ProductionExcisedEvent.class, this.eventListener);
            }
            try {
                for (String file : this.fileNames) {
                    try {
                        this.parent.sourceCommand.source(file);
                    }
                    catch (SoarException e) {
                        this.parent.agent.getPrinter().startNewLine().print(e.getMessage());
                        if (topLevel) {
                            ((Load)this.parent).sourceCommand.topLevelState = null;
                            ((Load)this.parent).sourceCommand.events.removeListener(null, this.eventListener);
                        }
                        return;
                    }
                }
                if (topLevel) {
                    String[] lastCommand = new String[this.fileNames.length + 2];
                    lastCommand[0] = "load";
                    lastCommand[1] = "file";
                    for (int i = 0; i < this.fileNames.length; ++i) {
                        lastCommand[i + 2] = this.fileNames[i];
                    }
                    ((Load)this.parent).sourceCommand.lastTopLevelCommand = Arrays.copyOf(lastCommand, lastCommand.length);
                }
                StringBuilder result = new StringBuilder();
                if (topLevel) {
                    if (this.loadSummary) {
                        for (SourceCommand.FileInfo file : ((Load)this.parent).sourceCommand.topLevelState.files) {
                            result.append(String.format("%s: %d productions sourced.\n", file.name, file.productionsAdded.size()));
                            if (!this.printExcised || file.productionsExcised.isEmpty()) continue;
                            result.append("Excised productions:\n");
                            for (String p : file.productionsExcised) {
                                result.append("        " + p + "\n");
                            }
                        }
                    }
                    if (!this.disableSummaries) {
                        result.append(String.format("Total: %d productions sourced. %d productions excised.\n", ((Load)this.parent).sourceCommand.topLevelState.totalProductionsAdded, ((Load)this.parent).sourceCommand.topLevelState.totalProductionsExcised));
                    }
                    if (this.printExcised && !this.loadSummary && ((Load)this.parent).sourceCommand.topLevelState.totalProductionsExcised != 0) {
                        result.append("Excised productions:\n");
                        for (SourceCommand.FileInfo file : ((Load)this.parent).sourceCommand.topLevelState.files) {
                            for (String p : file.productionsExcised) {
                                result.append("        " + p + "\n");
                            }
                        }
                    }
                    result.append("Source finished.");
                }
                this.parent.agent.getPrinter().startNewLine().print(result.toString());
            }
            finally {
                if (topLevel) {
                    ((Load)this.parent).sourceCommand.topLevelState = null;
                    ((Load)this.parent).sourceCommand.events.removeListener(null, this.eventListener);
                }
            }
        }
    }

    @CommandLine.Command(name="load", description={"Loads a file or rete-net"}, subcommands={CommandLine.HelpCommand.class, FileC.class, ReteNet.class})
    public static class Load
    implements Runnable {
        private SourceCommand sourceCommand;
        private Agent agent;

        public Load(SourceCommand sourceCommand, Agent agent) {
            this.sourceCommand = sourceCommand;
            this.agent = agent;
        }

        @Override
        public void run() {
            this.agent.getPrinter().startNewLine().print("File type is required.");
        }
    }
}

