/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.commands;

import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.LinkedList;
import org.jsoar.kernel.Agent;
import org.jsoar.kernel.SoarException;
import org.jsoar.kernel.commands.PrintCommand;
import org.jsoar.kernel.commands.Utils;
import org.jsoar.util.TeeWriter;
import org.jsoar.util.commands.SoarCommand;
import org.jsoar.util.commands.SoarCommandContext;
import picocli.CommandLine;

public final class OutputCommand
implements SoarCommand {
    private Agent agent;
    private PrintCommand printCommand;
    private LinkedList<Writer> writerStack = new LinkedList();

    public OutputCommand(Agent agent, PrintCommand printCommand) {
        this.agent = agent;
        this.printCommand = printCommand;
    }

    @Override
    public String execute(SoarCommandContext context, String[] args) throws SoarException {
        Utils.parseAndRun(this.agent, new Output(this.agent, this.printCommand, this.writerStack), args);
        return "";
    }

    @Override
    public Object getCommand() {
        return new Output(this.agent, this.printCommand, this.writerStack);
    }

    @CommandLine.Command(name="warnings", description={"Toggles output warnings"}, subcommands={CommandLine.HelpCommand.class})
    public static class Warnings
    implements Runnable {
        @CommandLine.ParentCommand
        Output parent;
        @CommandLine.Option(names={"on", "-e", "--on", "--enable"}, description={"Enables output warnings"})
        boolean enable = false;
        @CommandLine.Option(names={"off", "-d", "--off", "--disable"}, description={"Disables output warnings"})
        boolean disable = false;

        @Override
        public void run() {
            if (!this.enable && !this.disable) {
                this.parent.agent.getPrinter().print("warnings is " + (this.parent.agent.getPrinter().isPrintWarnings() ? "on" : "off"));
            } else if (this.enable) {
                this.parent.agent.getPrinter().setPrintWarnings(true);
                this.parent.agent.getPrinter().print("warnings is now on");
            } else {
                this.parent.agent.getPrinter().setPrintWarnings(false);
                this.parent.agent.getPrinter().print("warnings is now off");
            }
        }
    }

    @CommandLine.Command(name="print-depth", description={"Adjusts or displays the print-depth"}, subcommands={CommandLine.HelpCommand.class})
    public static class PrintDepth
    implements Runnable {
        @CommandLine.ParentCommand
        Output parent;
        @CommandLine.Spec
        CommandLine.Model.CommandSpec spec;
        @CommandLine.Parameters(index="0", arity="0..1", description={"New print depth"})
        Integer printDepth = null;

        @Override
        public void run() {
            if (this.printDepth == null) {
                this.parent.agent.getPrinter().startNewLine().print("print-depth is " + Integer.toString(this.parent.printCommand.getDefaultDepth()));
            } else {
                int depth = this.printDepth;
                try {
                    this.parent.printCommand.setDefaultDepth(depth);
                }
                catch (SoarException e) {
                    throw new CommandLine.ParameterException(this.spec.commandLine(), e.getMessage(), (Throwable)e);
                }
                this.parent.agent.getPrinter().startNewLine().print("print-depth is now " + depth);
            }
        }
    }

    @CommandLine.Command(name="log", description={"Changes output log settings"}, subcommands={CommandLine.HelpCommand.class})
    public static class Log
    implements Runnable {
        @CommandLine.ParentCommand
        Output parent;
        @CommandLine.Option(names={"-c", "--close"}, arity="0..1", description={"Closes the log file"})
        boolean close = false;
        @CommandLine.Parameters(index="0", arity="0..1", description={"File name"})
        String fileName = null;

        @Override
        public void run() {
            if (this.close) {
                if (this.parent.writerStack.isEmpty()) {
                    this.parent.agent.getPrinter().startNewLine().print("Log is not open.");
                } else {
                    this.parent.writerStack.pop();
                    this.parent.agent.getPrinter().popWriter();
                    this.parent.agent.getPrinter().startNewLine().print("Log file closed.");
                }
            } else if (this.fileName != null) {
                if (this.fileName.equals("stdout")) {
                    OutputStreamWriter w = new OutputStreamWriter(System.out);
                    this.parent.writerStack.push(null);
                    this.parent.agent.getPrinter().pushWriter(new TeeWriter(this.parent.agent.getPrinter().getWriter(), w));
                    this.parent.agent.getPrinter().startNewLine().print("Now writing to System.out");
                } else if (this.fileName.equals("stderr")) {
                    OutputStreamWriter w = new OutputStreamWriter(System.err);
                    this.parent.writerStack.push(null);
                    this.parent.agent.getPrinter().pushWriter(new TeeWriter(this.parent.agent.getPrinter().getWriter(), w));
                    this.parent.agent.getPrinter().startNewLine().print("Now writing to System.err");
                } else {
                    try {
                        FileWriter w = new FileWriter(this.fileName);
                        this.parent.writerStack.push(w);
                        this.parent.agent.getPrinter().pushWriter(new TeeWriter(this.parent.agent.getPrinter().getWriter(), w));
                        this.parent.agent.getPrinter().startNewLine().print("Log file " + this.fileName + " open.");
                    }
                    catch (IOException e) {
                        this.parent.agent.getPrinter().startNewLine().print("Failed to open file '" + this.fileName + "': " + e.getMessage());
                    }
                }
            } else {
                this.parent.agent.getPrinter().startNewLine().print("log is " + (!this.parent.writerStack.isEmpty() ? "on" : "off"));
            }
        }
    }

    @CommandLine.Command(name="output", description={"Commands related to handling output"}, subcommands={CommandLine.HelpCommand.class, Log.class, PrintDepth.class, Warnings.class})
    public static class Output
    implements Runnable {
        private Agent agent;
        private PrintCommand printCommand;
        private LinkedList<Writer> writerStack;

        public Output(Agent agent, PrintCommand printCommand, LinkedList<Writer> writerStack) {
            this.agent = agent;
            this.printCommand = printCommand;
            this.writerStack = writerStack;
        }

        @Override
        public void run() {
            this.agent.getPrinter().startNewLine().print("=======================================================\n-                    Output Status                    -\n=======================================================\n");
        }
    }
}

