/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.commands;

import java.io.IOException;
import org.jsoar.kernel.Agent;
import org.jsoar.kernel.Decider;
import org.jsoar.kernel.PredefinedSymbols;
import org.jsoar.kernel.SoarException;
import org.jsoar.kernel.commands.PrintPreferencesCommand;
import org.jsoar.kernel.commands.Utils;
import org.jsoar.kernel.symbols.Identifier;
import org.jsoar.kernel.symbols.Symbol;
import org.jsoar.kernel.symbols.Symbols;
import org.jsoar.kernel.tracing.Trace;
import org.jsoar.util.adaptables.Adaptables;
import org.jsoar.util.commands.SoarCommand;
import org.jsoar.util.commands.SoarCommandContext;
import picocli.CommandLine;

public class PreferencesCommand
implements SoarCommand {
    private final Agent agent;

    public PreferencesCommand(Agent agent) {
        this.agent = agent;
    }

    @Override
    public String execute(SoarCommandContext context, String[] args) throws SoarException {
        Utils.parseAndRun(this.agent, new PreferencesC(this.agent), args);
        return "";
    }

    @Override
    public Object getCommand() {
        return new PreferencesC(this.agent);
    }

    @CommandLine.Command(name="preferences", description={"Examines details about the preferences that support the specified identifier and attribute"}, subcommands={CommandLine.HelpCommand.class})
    public static class PreferencesC
    implements Runnable {
        private Agent agent;
        @CommandLine.Option(names={"-n", "-0", "--none"}, description={"Prints just the preferences themselves"})
        boolean level0 = false;
        @CommandLine.Option(names={"-N", "-1", "--names"}, description={"Prints the preferences and the names of the productions that generated them"})
        boolean level1 = false;
        @CommandLine.Option(names={"-t", "-2", "--timetags"}, description={"Prints the information for the --names option above plus the timetags of the wmes matched by the LHS of the indicated productions"})
        boolean level2 = false;
        @CommandLine.Option(names={"-w", "-3", "--wmes"}, description={"Prints the information for the --timetags option above plus the entire WME matched on the LHS"})
        boolean level3 = false;
        @CommandLine.Option(names={"-o", "--object"}, description={"Prints the support for all the WMEs that comprise the object (the specified identifier)"})
        boolean object = false;
        @CommandLine.Parameters(index="0", arity="0..1", description={"Must be an existing Soar object identifier"})
        String identifier = null;
        @CommandLine.Parameters(index="1", arity="0..1", description={"Must be an existing attribute of the specified identifier"})
        String attribute = null;

        public PreferencesC(Agent agent) {
            this.agent = agent;
        }

        @Override
        public void run() {
            PrintPreferencesCommand ppc = new PrintPreferencesCommand();
            ppc.setWmeTraceType(Trace.WmeTraceType.NONE);
            ppc.setPrintProduction(false);
            ppc.setObject(false);
            Decider decider = Adaptables.adapt(this.agent, Decider.class);
            ppc.setId(decider.bottom_goal);
            PredefinedSymbols preSyms = Adaptables.adapt(this.agent, PredefinedSymbols.class);
            ppc.setAttr(preSyms.operator_symbol);
            if (this.level0) {
                ppc.setWmeTraceType(Trace.WmeTraceType.NONE);
            } else if (this.level1) {
                ppc.setWmeTraceType(Trace.WmeTraceType.NONE);
                ppc.setPrintProduction(true);
            } else if (this.level2) {
                ppc.setWmeTraceType(Trace.WmeTraceType.TIMETAG);
                ppc.setPrintProduction(true);
            } else if (this.level3) {
                ppc.setWmeTraceType(Trace.WmeTraceType.FULL);
                ppc.setPrintProduction(true);
            } else if (this.object) {
                ppc.setObject(true);
            }
            if (this.identifier != null) {
                Symbol idSym = this.agent.readIdentifierOrContextVariable(this.identifier);
                if (idSym == null) {
                    this.agent.getPrinter().startNewLine().print("Could not find identifier '" + this.identifier + "'");
                    return;
                }
                Identifier id = idSym.asIdentifier();
                if (id == null) {
                    this.agent.getPrinter().startNewLine().print("'" + this.identifier + "' is not an identifier");
                    return;
                }
                ppc.setId(id);
                if (this.attribute != null) {
                    Symbol attr = Symbols.readAttributeFromString(this.agent, this.attribute);
                    if (attr == null) {
                        this.agent.getPrinter().startNewLine().print("'" + this.attribute + "' is not a known attribute");
                        return;
                    }
                    ppc.setAttr(attr);
                } else if (!id.isGoal()) {
                    ppc.setAttr(null);
                }
            }
            try {
                ppc.print(this.agent, this.agent.getPrinter());
            }
            catch (IOException e) {
                this.agent.getPrinter().startNewLine().print(e.getMessage());
            }
            this.agent.getPrinter().flush();
        }
    }
}

