/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.commands;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jsoar.kernel.Agent;
import org.jsoar.kernel.Goal;
import org.jsoar.kernel.GoalDependencySet;
import org.jsoar.kernel.Production;
import org.jsoar.kernel.ProductionManager;
import org.jsoar.kernel.ProductionType;
import org.jsoar.kernel.SoarException;
import org.jsoar.kernel.commands.Utils;
import org.jsoar.kernel.learning.rl.ReinforcementLearningParams;
import org.jsoar.kernel.memory.Wme;
import org.jsoar.kernel.memory.WorkingMemoryPrinter;
import org.jsoar.kernel.symbols.Symbol;
import org.jsoar.kernel.tracing.Printer;
import org.jsoar.util.adaptables.Adaptables;
import org.jsoar.util.commands.SoarCommand;
import org.jsoar.util.commands.SoarCommandContext;
import picocli.CommandLine;

public class PrintCommand
implements SoarCommand {
    private Agent agent;
    protected int defaultDepth = 1;
    protected int depth = 1;
    protected WorkingMemoryPrinter wmp = new WorkingMemoryPrinter();

    public PrintCommand(Agent agent) {
        this.agent = agent;
    }

    @Override
    public String execute(SoarCommandContext context, String[] args) throws SoarException {
        Utils.parseAndRun(this.agent, new Print(this.agent, this), args);
        return "";
    }

    @Override
    public Object getCommand() {
        return new Print(this.agent, this);
    }

    protected boolean checkDepth(int depth) {
        if (depth <= 0) {
            this.agent.getPrinter().startNewLine().print("depth must be greater than 0");
            return false;
        }
        return true;
    }

    public void setDefaultDepth(int depth) throws SoarException {
        if (!this.checkDepth(depth)) {
            throw new SoarException("depth must be greater than 0");
        }
        this.defaultDepth = depth;
    }

    public int getDefaultDepth() {
        return this.defaultDepth;
    }

    @CommandLine.Command(name="print", description={"Prints data in the console window"}, subcommands={CommandLine.HelpCommand.class})
    public static class Print
    implements Runnable {
        private Agent agent;
        private PrintCommand pc;
        @CommandLine.Spec
        private CommandLine.Model.CommandSpec spec;
        @CommandLine.Option(names={"-a", "--all"}, description={"Print the names of all productions currently loaded"})
        boolean printAll = false;
        @CommandLine.Option(names={"-c", "--chunks"}, description={"Print the names of all chunks currently loaded"})
        boolean printChunks = false;
        @CommandLine.Option(names={"-D", "--defaults"}, description={"Print the names of all default productions currently loaded"})
        boolean printDefaults = false;
        @CommandLine.Option(names={"-d", "--depth"}, description={"This option overrides the default printing depth"})
        Integer overrideDepth = null;
        @CommandLine.Option(names={"-e", "--exact"}, description={"Print only the wmes that match the pattern"})
        boolean printExactMatch = false;
        @CommandLine.Option(names={"-F", "--filename"}, description={"Also prints the name of the file that contains the production"})
        boolean printFilename = false;
        @CommandLine.Option(names={"-f", "--full"}, description={"When printing productions, print the whole production (default behavior for individual productions)"})
        boolean printFullProd = false;
        @CommandLine.Option(names={"-g", "--gds"}, description={"Print the Goal Dependency Set"})
        boolean printGDS = false;
        @CommandLine.Option(names={"-i", "--internal"}, description={"Items will be printed in their internal form"})
        boolean printInternalForm = false;
        @CommandLine.Option(names={"-j", "--justifications"}, description={"Print the names of all justifications currently loaded"})
        boolean printJustify = false;
        @CommandLine.Option(names={"-n", "--name"}, description={"When printing productions, print only the name and not the whole production (default behavior for multiple productions"})
        boolean printOnlyName = false;
        @CommandLine.Option(names={"-o", "--operators"}, description={"When printing the stack, print only operators"})
        boolean printOnlyOperators = false;
        @CommandLine.Option(names={"-r", "--rl"}, description={"Print Soar-RL rules"})
        boolean printRLRules = false;
        @CommandLine.Option(names={"-s", "--stack"}, description={"Specifies that the Soar goal stack should be printed"})
        boolean printStack = false;
        @CommandLine.Option(names={"-S", "--states"}, description={"When printing the stack, print only states"})
        boolean printOnlyStates = false;
        @CommandLine.Option(names={"-T", "--template"}, description={"Print Soar-RL templates"})
        boolean printTemplates = false;
        @CommandLine.Option(names={"-t", "--tree"}, description={"wmes will be printed in a tree form (one wme per line)"})
        boolean printInTreeForm = false;
        @CommandLine.Option(names={"-u", "--user"}, description={"Print the names of all user productions currently loaded"})
        boolean printUserProds = false;
        @CommandLine.Option(names={"-v", "--varprint"}, description={"Print identifiers enclosed in angle brackets (not yet supported)"})
        boolean printVars = false;
        @CommandLine.Parameters(description={"A symbol, pattern, timetag, or production name"})
        private String[] params = null;

        public Print(Agent agent, PrintCommand pc) {
            this.agent = agent;
            this.pc = pc;
        }

        @Override
        public void run() {
            int newDepth;
            if (this.printGDS) {
                Wme w;
                Iterator<Wme> itr;
                GoalDependencySet gds;
                String result = "********************* Current GDS **************************\nstepping thru all wmes in rete, looking for any that are in a gds...\n";
                List<Goal> goalsTopToBottom = this.agent.getGoalStack();
                ArrayList<Goal> goalsBottomtoTop = new ArrayList<Goal>(goalsTopToBottom);
                Collections.reverse(goalsBottomtoTop);
                for (Goal goal : goalsBottomtoTop) {
                    gds = Adaptables.adapt(goal, GoalDependencySet.class);
                    if (gds == null) continue;
                    itr = gds.getWmes();
                    while (itr.hasNext()) {
                        w = itr.next();
                        result = result + "  For Goal  " + goal.toString() + "  " + w.toString() + "\n";
                    }
                }
                result = result + "************************************************************\n";
                for (Goal goal : goalsTopToBottom) {
                    result = result + "  For Goal  " + goal.toString();
                    gds = Adaptables.adapt(goal, GoalDependencySet.class);
                    if (gds == null) {
                        result = result + "  : No GDS for this goal.\n";
                        continue;
                    }
                    result = result + "\n";
                    itr = gds.getWmes();
                    while (itr.hasNext()) {
                        w = itr.next();
                        result = result + "                " + w.toString() + "\n";
                    }
                }
                result = result + "************************************************************\n";
                this.agent.getPrinter().startNewLine().print(result);
            }
            this.agent.getPrinter().startNewLine();
            this.pc.depth = this.pc.defaultDepth;
            if (this.overrideDepth != null && this.pc.checkDepth(newDepth = this.overrideDepth.intValue())) {
                this.pc.depth = newDepth;
            }
            if (this.printVars) {
                throw new CommandLine.ParameterException(this.spec.commandLine(), "--varprint not implemented yet");
            }
            if (!(this.printChunks || this.printDefaults || this.printJustify || this.printRLRules || this.printTemplates || this.printUserProds)) {
                this.printAll = true;
            }
            if (this.printStack) {
                this.agent.printStackTrace(this.printOnlyStates, this.printOnlyOperators);
                this.agent.getPrinter().print("\n").flush();
                return;
            }
            if (this.printOnlyStates || this.printOnlyOperators) {
                this.agent.getPrinter().print("Options --operators (-o) and --states (-S) are only valid when printing the stack.");
                return;
            }
            if (this.params != null) {
                String argString = Joiner.on((char)' ').join((Object[])this.params);
                Symbol arg = this.agent.readIdentifierOrContextVariable(argString);
                if (arg != null || argString.charAt(0) == '(') {
                    this.agent.getPrinter().startNewLine();
                    this.pc.wmp.setInternal(this.printInternalForm);
                    this.pc.wmp.setExact(this.printExactMatch);
                    this.pc.wmp.setDepth(this.pc.depth);
                    this.pc.wmp.setTree(this.printInTreeForm);
                    try {
                        this.pc.wmp.print(this.agent, this.agent.getPrinter(), arg, argString);
                    }
                    catch (Exception e) {
                        this.agent.getPrinter().print(e.toString());
                    }
                    this.agent.getPrinter().flush();
                    return;
                }
                try {
                    int tt = Integer.parseInt(argString);
                    for (Wme wme : this.agent.getAllWmesInRete()) {
                        if (wme.getTimetag() != tt) continue;
                        this.agent.getPrinter().startNewLine();
                        this.agent.getPrinter().print(wme.toString());
                        this.agent.getPrinter().flush();
                        return;
                    }
                    this.agent.getPrinter().startNewLine().print("No wme " + tt + " in working memory.");
                    return;
                }
                catch (NumberFormatException tt) {
                    if (!this.printOnlyName) {
                        this.printFullProd = true;
                    }
                    this.agent.getPrinter().startNewLine();
                    Production p = this.agent.getProductions().getProduction(argString);
                    if (p != null) {
                        this.do_print_for_production(p);
                    } else {
                        this.agent.getPrinter().print("No production named " + argString);
                    }
                    this.agent.getPrinter().flush();
                    return;
                }
            }
            if (this.printAll) {
                this.printChunks = true;
                this.printDefaults = true;
                this.printJustify = true;
                this.printUserProds = true;
                this.printTemplates = true;
            }
            this.agent.getPrinter().startNewLine();
            for (Production p : this.collectProductions()) {
                this.do_print_for_production(p);
            }
            if (this.printRLRules) {
                for (Production p : this.agent.getProductions().getProductions(null)) {
                    if (p.rlRuleInfo == null) continue;
                    this.do_print_for_production(p);
                }
            }
            this.agent.getPrinter().flush();
        }

        private void do_print_for_production(Production prod) {
            Printer p = this.agent.getPrinter();
            if (this.printFilename) {
                if (this.printFullProd) {
                    p.print("# source file: ", prod.getLocation());
                }
                p.print("%s", prod.getLocation());
                if (this.printFullProd) {
                    p.print("\n");
                } else {
                    p.print(": ");
                }
            }
            if (this.printFullProd) {
                prod.print(p, this.printInternalForm);
            } else {
                p.print("%s ", prod.getName());
                if (prod.rlRuleInfo != null) {
                    if (this.agent.getProperties().get(ReinforcementLearningParams.DECAY_MODE) == ReinforcementLearningParams.DecayMode.delta_bar_delta_decay) {
                        p.print(" %y", this.agent.getSymbols().createDouble(prod.rlRuleInfo.rl_delta_bar_delta_beta));
                        p.print(" %y", this.agent.getSymbols().createDouble(prod.rlRuleInfo.rl_delta_bar_delta_h));
                    }
                    p.print("%f  ", prod.rlRuleInfo.rl_update_count);
                    p.print("%s", prod.getFirstAction().asMakeAction().referent);
                }
            }
            p.print("\n");
        }

        private List<Production> collectProductions() {
            ProductionManager pm = this.agent.getProductions();
            ArrayList<Production> result = new ArrayList<Production>();
            if (this.printChunks) {
                result.addAll(pm.getProductions(ProductionType.CHUNK));
            }
            if (this.printUserProds) {
                result.addAll(pm.getProductions(ProductionType.USER));
            }
            if (this.printDefaults) {
                result.addAll(pm.getProductions(ProductionType.DEFAULT));
            }
            if (this.printTemplates) {
                result.addAll(pm.getProductions(ProductionType.TEMPLATE));
            }
            if (this.printJustify) {
                result.addAll(pm.getProductions(ProductionType.JUSTIFICATION));
            }
            return result;
        }
    }
}

