/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.commands;

import java.io.IOException;
import java.util.Iterator;
import org.jsoar.kernel.Agent;
import org.jsoar.kernel.Decider;
import org.jsoar.kernel.ImpasseType;
import org.jsoar.kernel.PredefinedSymbols;
import org.jsoar.kernel.exploration.Exploration;
import org.jsoar.kernel.memory.Preference;
import org.jsoar.kernel.memory.PreferenceType;
import org.jsoar.kernel.memory.Slot;
import org.jsoar.kernel.memory.Wme;
import org.jsoar.kernel.memory.WmeImpl;
import org.jsoar.kernel.symbols.Identifier;
import org.jsoar.kernel.symbols.IdentifierImpl;
import org.jsoar.kernel.symbols.Symbol;
import org.jsoar.kernel.tracing.Printer;
import org.jsoar.kernel.tracing.Trace;
import org.jsoar.kernel.tracing.TraceFormats;
import org.jsoar.util.ByRef;
import org.jsoar.util.adaptables.Adaptables;

public class PrintPreferencesCommand {
    private IdentifierImpl id;
    private Symbol attr;
    private boolean object = false;
    private boolean print_prod = false;
    private Trace.WmeTraceType wtt = Trace.WmeTraceType.NONE;

    public Identifier getId() {
        return this.id;
    }

    public void setId(Identifier id) {
        this.id = (IdentifierImpl)id;
    }

    public Symbol getAttr() {
        return this.attr;
    }

    public void setAttr(Symbol attr) {
        this.attr = attr;
    }

    public boolean isObject() {
        return this.object;
    }

    public void setObject(boolean object) {
        this.object = object;
    }

    public boolean getPrintProduction() {
        return this.print_prod;
    }

    public void setPrintProduction(boolean print_prod) {
        this.print_prod = print_prod;
    }

    public Trace.WmeTraceType getWmeTraceType() {
        return this.wtt;
    }

    public void setWmeTraceType(Trace.WmeTraceType wtt) {
        this.wtt = wtt;
    }

    public void print(Agent agent, Printer printer) throws IOException {
        PredefinedSymbols predefinedSyms = Adaptables.adapt(agent, PredefinedSymbols.class);
        if (this.object) {
            WmeImpl w;
            Slot s = this.id.slots;
            while (s != null) {
                if (s.attr == predefinedSyms.operator_symbol) {
                    printer.print("Preferences for %s ^%s:", s.id, s.attr);
                } else {
                    printer.print("Support for %s ^%s:\n", s.id, s.attr);
                }
                for (PreferenceType pt : PreferenceType.values()) {
                    if (s.getPreferencesByType(pt) == null) continue;
                    if (s.isa_context_slot) {
                        printer.print("\n%ss:\n", pt.getDisplayName());
                    }
                    Preference p = s.getPreferencesByType(pt);
                    while (p != null) {
                        this.print_preference_and_source(agent, printer, p);
                        p = p.next;
                    }
                }
                s = s.next;
            }
            if (this.id.goalInfo != null && this.id.goalInfo.getImpasseWmes() != null) {
                printer.print("Arch-created wmes for %s :\n", this.id);
            }
            WmeImpl wmeImpl = w = this.id.goalInfo != null ? this.id.goalInfo.getImpasseWmes() : null;
            while (w != null) {
                printer.print("%s", w);
                w = w.next;
            }
            if (this.id.getInputWmes() != null) {
                printer.print("Input (IO) wmes for %s :\n", this.id);
            }
            w = this.id.getInputWmes();
            while (w != null) {
                printer.print("%s", w);
                w = w.next;
            }
            return;
        }
        if (!this.id.isGoal() && this.attr == null) {
            for (Wme w : agent.getAllWmesInRete()) {
                if (w.getValue() != this.id) continue;
                if (w.getValue() == predefinedSyms.operator_symbol) {
                    printer.print("Preferences for ");
                } else {
                    printer.print("Support for ");
                }
                printer.print("(%d: %s ^%s %s)\n", w.getTimetag(), w.getIdentifier(), w.getAttribute(), w.getValue());
                Iterator<Preference> it = w.getPreferences();
                if (!it.hasNext()) {
                    printer.print("    This is an architecture or input wme and has no prefs.\n");
                    continue;
                }
                while (it.hasNext()) {
                    this.print_preference_and_source(agent, printer, it.next());
                }
            }
            return;
        }
        Slot s = Slot.find_slot(this.id, this.attr);
        if (s == null) {
            printer.print("Could not find prefs for id,attribute pair: %s %s\n", this.id, this.attr);
            return;
        }
        printer.print("\nPreferences for %s ^%s:\n", this.id, this.attr);
        for (PreferenceType pt : PreferenceType.values()) {
            if (s.getPreferencesByType(pt) == null) continue;
            printer.print("\n%ss:\n", pt.getDisplayName());
            Preference p = s.getPreferencesByType(pt);
            while (p != null) {
                this.print_preference_and_source(agent, printer, p);
                p = p.next;
            }
        }
        if (this.id.isGoal() && this.attr.toString().equals("operator")) {
            ByRef<Object> cand = ByRef.create(null);
            Decider decider = Adaptables.adapt(agent, Decider.class);
            ImpasseType impasse_type = decider.run_preference_semantics(s, cand, true);
            if (impasse_type == ImpasseType.NONE && cand.value != null) {
                printer.print("\nselection probabilities:\n");
                int count = 0;
                double total_probability = 0.0;
                Exploration exploration = Adaptables.adapt(agent, Exploration.class);
                Preference p = (Preference)cand.value;
                while (p != null) {
                    exploration.exploration_compute_value_of_candidate(p, s, 0.0);
                    ++count;
                    if (p.numeric_value > 0.0) {
                        total_probability += p.numeric_value;
                    }
                    p = p.next_candidate;
                }
                assert (count != 0);
                p = (Preference)cand.value;
                while (p != null) {
                    double prob = total_probability > 0.0 ? p.numeric_value / total_probability : 1.0 / (double)count;
                    this.print_preference_and_source(agent, printer, p, prob);
                    p = p.next_candidate;
                }
            }
        }
    }

    private void print_preference_and_source(Agent agnt, Printer printer, Preference pref) throws IOException {
        this.print_preference_and_source(agnt, printer, pref, null);
    }

    private void print_preference_and_source(Agent agnt, Printer printer, Preference pref, Double selection_probability) throws IOException {
        TraceFormats traceFormats = Adaptables.adapt(agnt, TraceFormats.class);
        PredefinedSymbols predefinedSyms = Adaptables.adapt(agnt, PredefinedSymbols.class);
        printer.print("  ");
        if (pref.attr == predefinedSyms.operator_symbol) {
            traceFormats.print_object_trace(printer.getWriter(), pref.value);
        } else {
            printer.print("(%s ^%s %s) ", pref.id, pref.attr, pref.value);
        }
        if (pref.attr == predefinedSyms.operator_symbol) {
            printer.print(" %c", Character.valueOf(pref.type.getIndicator()));
        }
        if (pref.type.isBinary()) {
            traceFormats.print_object_trace(printer.getWriter(), pref.referent);
        }
        if (pref.o_supported) {
            printer.print(" :O ");
        } else {
            printer.print(" :I ");
        }
        if (selection_probability != null) {
            printer.print("(%.1f%%)", selection_probability * 100.0);
        }
        printer.print("\n");
        if (this.print_prod) {
            printer.print("    From ");
            pref.inst.trace(printer.asFormatter(), this.wtt);
            printer.print("\n");
        }
    }
}

