/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.commands;

import org.jsoar.kernel.Agent;
import org.jsoar.kernel.SoarException;
import org.jsoar.kernel.commands.SourceCommand;
import org.jsoar.kernel.commands.Utils;
import org.jsoar.util.commands.SoarCommand;
import org.jsoar.util.commands.SoarCommandContext;
import picocli.CommandLine;

public class PushdCommand
implements SoarCommand {
    private final SourceCommand sourceCommand;
    private Agent agent;

    public PushdCommand(SourceCommand sourceCommand, Agent agent) {
        this.sourceCommand = sourceCommand;
        this.agent = agent;
    }

    @Override
    public String execute(SoarCommandContext context, String[] args) throws SoarException {
        Utils.parseAndRun(this.agent, new Pushd(this.sourceCommand, this.agent), args);
        return "";
    }

    @Override
    public Object getCommand() {
        return new Pushd(this.sourceCommand, this.agent);
    }

    @CommandLine.Command(name="pushd", description={"Saves the current working directory on a stack"}, subcommands={CommandLine.HelpCommand.class})
    public static class Pushd
    implements Runnable {
        private final SourceCommand sourceCommand;
        private Agent agent;
        @CommandLine.Parameters(index="0", description={"The directory to push"})
        private String dir;

        public Pushd(SourceCommand sourceCommand, Agent agent) {
            this.sourceCommand = sourceCommand;
            this.agent = agent;
        }

        @Override
        public void run() {
            try {
                this.sourceCommand.pushd(this.dir);
            }
            catch (SoarException e) {
                this.agent.getPrinter().print(e.getMessage());
            }
        }
    }
}

