/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.commands;

import java.util.concurrent.Callable;
import org.jsoar.kernel.SoarException;
import org.jsoar.kernel.commands.SourceCommand;
import org.jsoar.kernel.commands.Utils;
import org.jsoar.util.commands.SoarCommand;
import org.jsoar.util.commands.SoarCommandContext;
import picocli.CommandLine;

public class PwdCommand
implements SoarCommand {
    private final SourceCommand sourceCommand;

    public PwdCommand(SourceCommand sourceCommand) {
        this.sourceCommand = sourceCommand;
    }

    @Override
    public String execute(SoarCommandContext context, String[] args) throws SoarException {
        String result = Utils.parseAndRun(new Pwd(this.sourceCommand), args);
        return result;
    }

    @Override
    public Object getCommand() {
        return new Pwd(this.sourceCommand);
    }

    @CommandLine.Command(name="pwd", description={"Prints the working directory to the screen"}, subcommands={CommandLine.HelpCommand.class})
    public static class Pwd
    implements Callable<String> {
        private final SourceCommand sourceCommand;

        public Pwd(SourceCommand sourceCommand) {
            this.sourceCommand = sourceCommand;
        }

        @Override
        public String call() {
            return this.sourceCommand.getWorkingDirectory().replace('\\', '/');
        }
    }
}

