/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.commands;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jsoar.kernel.Agent;
import org.jsoar.kernel.SoarException;
import org.jsoar.kernel.commands.Utils;
import org.jsoar.kernel.rhs.functions.RhsFunctionHandler;
import org.jsoar.kernel.tracing.Printer;
import org.jsoar.util.commands.SoarCommand;
import org.jsoar.util.commands.SoarCommandContext;
import picocli.CommandLine;

public class RhsFunctionsCommand
implements SoarCommand {
    private final Agent agent;

    public RhsFunctionsCommand(Agent agent) {
        this.agent = agent;
    }

    @Override
    public String execute(SoarCommandContext context, String[] args) throws SoarException {
        Utils.parseAndRun(this.agent, new RhsFunctionsC(this.agent), args);
        return "";
    }

    @Override
    public Object getCommand() {
        return new RhsFunctionsC(this.agent);
    }

    @CommandLine.Command(name="rhs-functions", description={"Prints a list of all RHS functions"}, subcommands={CommandLine.HelpCommand.class})
    public static class RhsFunctionsC
    implements Runnable {
        private Agent agent;

        public RhsFunctionsC(Agent agent) {
            this.agent = agent;
        }

        @Override
        public void run() {
            Printer p = this.agent.getPrinter();
            p.startNewLine();
            List<RhsFunctionHandler> handlers = this.agent.getRhsFunctions().getHandlers();
            Collections.sort(handlers, new Comparator<RhsFunctionHandler>(){

                @Override
                public int compare(RhsFunctionHandler a, RhsFunctionHandler b) {
                    return a.getName().compareTo(b.getName());
                }
            });
            for (RhsFunctionHandler f : handlers) {
                int max = f.getMaxArguments();
                p.print("%20s (%d, %s)%n", f.getName(), f.getMinArguments(), max == Integer.MAX_VALUE ? "*" : Integer.toString(max));
            }
        }
    }
}

