/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.commands;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import org.jsoar.kernel.Agent;
import org.jsoar.kernel.SoarException;
import org.jsoar.kernel.commands.SourceCommand;
import org.jsoar.kernel.commands.Utils;
import org.jsoar.kernel.rete.ReteSerializer;
import org.jsoar.util.commands.SoarCommand;
import org.jsoar.util.commands.SoarCommandContext;
import picocli.CommandLine;

public class SaveCommand
implements SoarCommand {
    private SourceCommand sourceCommand;
    private Agent agent;

    public SaveCommand(SourceCommand sourceCommand, Agent agent) {
        this.sourceCommand = sourceCommand;
        this.agent = agent;
    }

    @Override
    public String execute(SoarCommandContext context, String[] args) throws SoarException {
        Utils.parseAndRun(this.agent, new Save(this.sourceCommand, this.agent), args);
        return "";
    }

    @Override
    public Object getCommand() {
        return new Save(this.sourceCommand, this.agent);
    }

    @CommandLine.Command(name="rete-net", description={"Serializes an agent's productions to a binary file"}, subcommands={CommandLine.HelpCommand.class})
    public static class ReteNet
    implements Runnable {
        @CommandLine.ParentCommand
        Save parent;
        @CommandLine.Option(names={"-s", "--save"}, arity="1", description={"File name to save rete-net to"})
        String fileName = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            OutputStream os = null;
            if (!new File(this.fileName).isAbsolute()) {
                this.fileName = this.parent.sourceCommand.getWorkingDirectory() + "/" + this.fileName;
            }
            try {
                os = this.compressIfNeeded(this.fileName, new FileOutputStream(this.fileName));
                ReteSerializer.saveRete(this.parent.agent, os);
                os.close();
            }
            catch (IOException e) {
                this.parent.agent.getPrinter().startNewLine().print("Save file failed.");
                return;
            }
            catch (SoarException e) {
                this.parent.agent.getPrinter().startNewLine().print(e.getMessage());
                return;
            }
            finally {
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (IOException e) {
                        this.parent.agent.getPrinter().startNewLine().print("IO error while closing the file.");
                    }
                }
            }
            this.parent.agent.getPrinter().startNewLine().print("Rete saved");
        }

        private OutputStream compressIfNeeded(String filename, OutputStream os) throws IOException {
            if (filename.endsWith(".Z")) {
                return new GZIPOutputStream(os);
            }
            return os;
        }
    }

    @CommandLine.Command(name="save", description={"Saves a rete-net"}, subcommands={CommandLine.HelpCommand.class, ReteNet.class})
    public static class Save
    implements Runnable {
        private SourceCommand sourceCommand;
        private Agent agent;

        public Save(SourceCommand sourceCommand, Agent agent) {
            this.sourceCommand = sourceCommand;
            this.agent = agent;
        }

        @Override
        public void run() {
            this.agent.getPrinter().startNewLine().print("File type is required.");
        }
    }
}

