/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.commands;

import org.jsoar.kernel.Agent;
import org.jsoar.kernel.JSoarVersion;
import org.jsoar.kernel.Phase;
import org.jsoar.kernel.SoarException;
import org.jsoar.kernel.SoarProperties;
import org.jsoar.kernel.commands.Utils;
import org.jsoar.runtime.ThreadedAgent;
import org.jsoar.util.commands.SoarCommand;
import org.jsoar.util.commands.SoarCommandContext;
import org.jsoar.util.timing.ExecutionTimers;
import picocli.CommandLine;

public class SoarSettingsCommand
implements SoarCommand {
    private Agent agent;
    private ThreadedAgent tAgent;

    public SoarSettingsCommand(Agent agent) {
        this.agent = agent;
    }

    public SoarSettingsCommand(ThreadedAgent tAgent) {
        this.tAgent = tAgent;
    }

    @Override
    public String execute(SoarCommandContext context, String[] args) throws SoarException {
        if (this.tAgent != null) {
            this.agent = this.tAgent.getAgent();
        }
        Utils.parseAndRun(this.agent, new Soar(this.agent, this.tAgent), args);
        return "";
    }

    @Override
    public Object getCommand() {
        return new Soar(this.agent, this.tAgent);
    }

    @CommandLine.Command(name="version", description={"Prints the version of Soar to the screen"}, subcommands={CommandLine.HelpCommand.class})
    public static class Version
    implements Runnable {
        @CommandLine.ParentCommand
        Soar parent;

        @Override
        public void run() {
            JSoarVersion v = JSoarVersion.getInstance();
            this.parent.agent.getPrinter().startNewLine().print(String.format("%s%nBuilt on: %s%nBuilt by: %s", v.getVersion(), v.getBuildDate(), v.getBuiltBy()));
        }
    }

    @CommandLine.Command(name="wait-snc", description={"Wait instead of impasse after state-no-change"}, subcommands={CommandLine.HelpCommand.class})
    public static class WaitSNC
    implements Runnable {
        @CommandLine.ParentCommand
        Soar parent;
        @CommandLine.Option(names={"on", "-e", "--on", "--enable"}, description={"Enables wait-snc"})
        boolean enable = false;
        @CommandLine.Option(names={"off", "-d", "--off", "--disable"}, description={"Disables wait-snc"})
        boolean disable = false;

        @Override
        public void run() {
            if (!this.enable && !this.disable) {
                this.parent.agent.getPrinter().print("waitsnc is " + (this.parent.agent.getProperties().get(SoarProperties.WAITSNC) != false ? "on" : "off"));
            } else if (this.enable) {
                this.parent.agent.getProperties().set(SoarProperties.WAITSNC, true);
                this.parent.agent.getPrinter().print("Soar will now wait instead of impassing when a state doesn't change.");
            } else {
                this.parent.agent.getProperties().set(SoarProperties.WAITSNC, false);
                this.parent.agent.getPrinter().print("Soar will now impasse when a state doesn't change.");
            }
        }
    }

    @CommandLine.Command(name="timers", description={"Profile where Soar spends its time"}, subcommands={CommandLine.HelpCommand.class})
    public static class Timers
    implements Runnable {
        @CommandLine.ParentCommand
        Soar parent;
        @CommandLine.Option(names={"on", "-e", "--on", "--enable"}, description={"Enables timers"})
        boolean enable = false;
        @CommandLine.Option(names={"off", "-d", "--off", "--disable"}, description={"Disables timers"})
        boolean disable = false;

        @Override
        public void run() {
            if (!this.enable && !this.disable) {
                this.parent.agent.getPrinter().print("timers is " + (ExecutionTimers.isEnabled() ? "on" : "off"));
            } else if (this.enable) {
                ExecutionTimers.setEnabled(true);
                this.parent.agent.getPrinter().print("Timers are now enabled.");
            } else {
                ExecutionTimers.setEnabled(false);
                this.parent.agent.getPrinter().print("Timers are now disabled.");
            }
        }
    }

    @CommandLine.Command(name="stop-phase", description={"Phase before which Soar will stop"}, subcommands={CommandLine.HelpCommand.class})
    public static class StopPhase
    implements Runnable {
        @CommandLine.ParentCommand
        Soar parent;
        @CommandLine.Parameters(index="0", arity="0..1", description={"Valid phases are: ${COMPLETION-CANDIDATES}"})
        private CommandPhase phase = null;

        @Override
        public void run() {
            if (this.phase == null) {
                CommandPhase currentPhase = CommandPhase.values()[this.parent.agent.getProperties().get(SoarProperties.STOP_PHASE).ordinal()];
                this.parent.agent.getPrinter().print("stop-phase is " + (Object)((Object)currentPhase));
            } else {
                this.parent.agent.getProperties().set(SoarProperties.STOP_PHASE, Phase.values()[this.phase.ordinal()]);
                this.parent.agent.getPrinter().print("Soar will now stop before the " + (Object)((Object)this.phase) + " phase.");
            }
        }

        static enum CommandPhase {
            input,
            proposal,
            decide,
            apply,
            output;

        }
    }

    @CommandLine.Command(name="stop", description={"Stop Soar execution"}, subcommands={CommandLine.HelpCommand.class})
    public static class Stop
    implements Runnable {
        @CommandLine.ParentCommand
        Soar parent;

        @Override
        public void run() {
            if (this.parent.tAgent != null) {
                this.parent.tAgent.stop();
            } else {
                this.parent.agent.stop();
            }
        }
    }

    @CommandLine.Command(name="max-elaborations", description={"Maximum elaboration in a decision cycle"}, subcommands={CommandLine.HelpCommand.class})
    public static class MaxElaborations
    implements Runnable {
        @CommandLine.ParentCommand
        Soar parent;
        @CommandLine.Parameters(index="0", arity="0..1", description={"The new number of maximum elaborations"})
        private Integer numElaborations = null;

        @Override
        public void run() {
            if (this.numElaborations == null) {
                this.parent.agent.getPrinter().print("max-elaborations is " + this.parent.agent.getProperties().get(SoarProperties.MAX_ELABORATIONS));
            } else {
                this.parent.agent.getProperties().set(SoarProperties.MAX_ELABORATIONS, this.numElaborations);
                this.parent.agent.getPrinter().print("The maximum number of elaborations in a phase is now " + this.numElaborations + ".");
            }
        }
    }

    @CommandLine.Command(name="init", description={"Re-initializes Soar"}, subcommands={CommandLine.HelpCommand.class})
    public static class Init
    implements Runnable {
        @CommandLine.ParentCommand
        Soar parent;

        @Override
        public void run() {
            this.parent.agent.initialize();
            this.parent.agent.getPrinter().startNewLine().print("Agent reinitialized\n").flush();
        }
    }

    @CommandLine.Command(name="soar", description={"Commands and settings related to running Soar"}, subcommands={CommandLine.HelpCommand.class, Init.class, MaxElaborations.class, Stop.class, StopPhase.class, Timers.class, WaitSNC.class, Version.class})
    public static class Soar
    implements Runnable {
        private Agent agent;
        private ThreadedAgent tAgent;

        public Soar(Agent agent, ThreadedAgent tAgent) {
            this.agent = agent;
            this.tAgent = tAgent;
        }

        @Override
        public void run() {
            this.agent.getPrinter().startNewLine().print("=======================================================\n-                   Soar 9.6.0 Summary                -\n=======================================================\n");
        }
    }
}

