/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.commands;

import org.jsoar.kernel.Agent;
import org.jsoar.kernel.commands.ChunkCommand;
import org.jsoar.kernel.commands.DebugCommand;
import org.jsoar.kernel.commands.DebuggerCommand;
import org.jsoar.kernel.commands.DecideCommand;
import org.jsoar.kernel.commands.EchoCommand;
import org.jsoar.kernel.commands.EditProductionCommand;
import org.jsoar.kernel.commands.ExplainBacktracesCommand;
import org.jsoar.kernel.commands.HandlerCommand;
import org.jsoar.kernel.commands.HelpMainCommand;
import org.jsoar.kernel.commands.LogCommand;
import org.jsoar.kernel.commands.OutputCommand;
import org.jsoar.kernel.commands.PreferencesCommand;
import org.jsoar.kernel.commands.PrintCommand;
import org.jsoar.kernel.commands.ProductionCommand;
import org.jsoar.kernel.commands.PropertiesCommand;
import org.jsoar.kernel.commands.QMemoryCommand;
import org.jsoar.kernel.commands.RhsFunctionsCommand;
import org.jsoar.kernel.commands.RunCommand;
import org.jsoar.kernel.commands.SaveBacktracesCommand;
import org.jsoar.kernel.commands.SetParserCommand;
import org.jsoar.kernel.commands.SoarSettingsCommand;
import org.jsoar.kernel.commands.SpCommand;
import org.jsoar.kernel.commands.StatsCommand;
import org.jsoar.kernel.commands.TraceCommand;
import org.jsoar.kernel.wma.WMActivationCommand;
import org.jsoar.util.commands.SoarCommandInterpreter;
import org.jsoar.util.commands.SoarCommands;

public class StandardCommands {
    public static void addToInterpreter(Agent agent, SoarCommandInterpreter interp) {
        interp.addCommand("sp", new SpCommand(agent));
        interp.addCommand("stats", new StatsCommand(agent));
        interp.addCommand("save-backtraces", new SaveBacktracesCommand(agent));
        interp.addCommand("explain-backtraces", new ExplainBacktracesCommand(agent));
        interp.addCommand("echo", new EchoCommand(agent));
        interp.addCommand("rhs-functions", new RhsFunctionsCommand(agent));
        PrintCommand printCommand = new PrintCommand(agent);
        interp.addCommand("print", printCommand);
        interp.addCommand("preferences", new PreferencesCommand(agent));
        interp.addCommand("edit-production", new EditProductionCommand(agent));
        interp.addCommand("set-parser", new SetParserCommand(agent));
        interp.addCommand("properties", new PropertiesCommand(agent));
        interp.addCommand("decide", new DecideCommand(agent));
        interp.addCommand("help", new HelpMainCommand(agent));
        interp.addCommand("qmemory", new QMemoryCommand(agent));
        interp.addCommand("debugger", new DebuggerCommand(agent));
        interp.addCommand("log", new LogCommand(agent, interp));
        interp.addCommand("handler", new HandlerCommand(agent));
        interp.addCommand("soar", new SoarSettingsCommand(agent));
        interp.addCommand("output", new OutputCommand(agent, printCommand));
        interp.addCommand("production", new ProductionCommand(agent));
        interp.addCommand("chunk", new ChunkCommand(agent));
        interp.addCommand("wm", new WMActivationCommand(agent));
        interp.addCommand("debug", new DebugCommand(agent));
        interp.addCommand("run", new RunCommand(agent));
        interp.addCommand("trace", new TraceCommand(agent));
        SoarCommands.registerCustomCommands(interp, agent);
    }
}

