/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.commands;

import java.util.Calendar;
import org.jsoar.kernel.Agent;
import org.jsoar.kernel.JSoarVersion;
import org.jsoar.kernel.ProductionType;
import org.jsoar.kernel.SoarException;
import org.jsoar.kernel.SoarProperties;
import org.jsoar.kernel.commands.Utils;
import org.jsoar.kernel.tracing.Printer;
import org.jsoar.util.commands.SoarCommand;
import org.jsoar.util.commands.SoarCommandContext;
import org.jsoar.util.properties.PropertyManager;
import picocli.CommandLine;

public class StatsCommand
implements SoarCommand {
    private final Agent agent;

    public StatsCommand(Agent agent) {
        this.agent = agent;
    }

    @Override
    public String execute(SoarCommandContext context, String[] args) throws SoarException {
        Utils.parseAndRun(this.agent, new Stats(this.agent), args);
        return "";
    }

    @Override
    public Object getCommand() {
        return new Stats(this.agent);
    }

    @CommandLine.Command(name="stats", description={"Prints information on Soar's runtime statistics"}, subcommands={CommandLine.HelpCommand.class})
    public static class Stats
    implements Runnable {
        private Agent agent;
        @CommandLine.Option(names={"-s", "--system"}, description={"Prints system statistics"})
        boolean printSystemStats = false;

        public Stats(Agent agent) {
            this.agent = agent;
        }

        @Override
        public void run() {
            Printer p = this.agent.getPrinter();
            p.startNewLine();
            JSoarVersion version = JSoarVersion.getInstance();
            p.print("JSoar %s on %s at %s%n", version.getVersion(), System.getenv("HOSTNAME"), Calendar.getInstance().getTime());
            p.print("Built on %s by %s%n%n", version.getBuildDate(), version.getBuiltBy());
            p.print("%d productions (%d default, %d user, %d chunks)%n   + %d justifications%n", this.agent.getProductions().getProductions(null).size(), this.agent.getProductions().getProductions(ProductionType.DEFAULT).size(), this.agent.getProductions().getProductions(ProductionType.USER).size(), this.agent.getProductions().getProductions(ProductionType.CHUNK).size(), this.agent.getProductions().getProductions(ProductionType.JUSTIFICATION).size());
            p.print("\n");
            p.print("Values from single timers:%n Kernel CPU Time: %f sec. %n Total  CPU Time: %f sec. %n%n", this.agent.getTotalKernelTimer().getTotalSeconds(), this.agent.getTotalCpuTimer().getTotalSeconds());
            PropertyManager props = this.agent.getProperties();
            long decision_phases_count = props.get(SoarProperties.DECISION_PHASES_COUNT);
            long e_cycle_count = props.get(SoarProperties.E_CYCLE_COUNT);
            long pe_cycle_count = props.get(SoarProperties.PE_CYCLE_COUNT);
            long inner_e_cycle_count = props.get(SoarProperties.INNER_E_CYCLE_COUNT);
            p.print("%d decisions%n%d elaboration cycles%n%d inner elaboration cycles%n", decision_phases_count, e_cycle_count, inner_e_cycle_count);
            double total_kernel_msec = this.agent.getTotalKernelTimer().getTotalSeconds() * 1000.0;
            p.print("%d p-elaboration cycles (%f pe's per dc, %f msec/pe)%n", pe_cycle_count, decision_phases_count != 0L ? (double)pe_cycle_count / (double)decision_phases_count : 0.0, pe_cycle_count != 0L ? total_kernel_msec / (double)pe_cycle_count : 0.0);
            long production_firing_count = props.get(SoarProperties.PRODUCTION_FIRING_COUNT);
            p.print("%d production firings (%f pf's per ec, %f msec/pf)%n", production_firing_count, e_cycle_count != 0L ? (double)production_firing_count / (double)e_cycle_count : 0.0, production_firing_count != 0L ? total_kernel_msec / (double)production_firing_count : 0.0);
            long wme_additions = props.get(SoarProperties.WME_ADDITION_COUNT);
            long wme_removes = props.get(SoarProperties.WME_REMOVAL_COUNT);
            long wme_changes = wme_additions + wme_removes;
            p.print("%d wme changes (%d additions, %d removals)%n", wme_changes, wme_additions, wme_removes);
            long num_wm_sizes_accumulated = props.get(SoarProperties.NUM_WM_SIZES_ACCUMULATED);
            p.print("WM size: %d current, %f mean, %d maximum%n", this.agent.getNumWmesInRete(), num_wm_sizes_accumulated != 0L ? (double)props.get(SoarProperties.CUMULATIVE_WM_SIZE).intValue() / (double)num_wm_sizes_accumulated : 0.0, props.get(SoarProperties.MAX_WM_SIZE));
        }
    }
}

