/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.commands;

import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jsoar.kernel.Agent;
import org.jsoar.kernel.PredefinedSymbols;
import org.jsoar.kernel.commands.PrintPreferencesCommand;
import org.jsoar.kernel.memory.Preference;
import org.jsoar.kernel.memory.PreferenceType;
import org.jsoar.kernel.memory.Slot;
import org.jsoar.kernel.memory.Wme;
import org.jsoar.kernel.memory.WmeImpl;
import org.jsoar.kernel.symbols.Identifier;
import org.jsoar.kernel.symbols.IdentifierImpl;
import org.jsoar.kernel.symbols.Symbol;
import org.jsoar.kernel.tracing.Printer;
import org.jsoar.kernel.tracing.Trace;
import org.jsoar.kernel.tracing.TraceFormats;
import org.jsoar.util.adaptables.Adaptables;

public class StructuredPreferencesCommand {
    public Result getPreferences(Agent agent, Identifier queryId, Symbol queryAttr) {
        if (queryId == null) {
            throw new IllegalArgumentException("queryId");
        }
        if (queryAttr == null) {
            return this.getPreferencesForObject(agent, queryId);
        }
        IdentifierImpl id = (IdentifierImpl)queryId;
        ArrayList<ResultEntry> entries = new ArrayList<ResultEntry>();
        Slot s = Slot.find_slot(id, queryAttr);
        if (s == null) {
            return new Result(String.format("No slot found for (%s ^%s *)", queryId, queryAttr));
        }
        Preference p = s.getAllPreferences();
        while (p != null) {
            entries.add(this.createEntry(agent, p));
            p = p.nextOfSlot;
        }
        Result r = new Result(queryId, queryAttr, null, entries, new ArrayList(), new ArrayList());
        PrintPreferencesCommand ppc = new PrintPreferencesCommand();
        ppc.setAttr(queryAttr);
        ppc.setId(queryId);
        this.addPrintResult(agent, r, ppc);
        return r;
    }

    public Result getPreferencesForValue(Agent agent, Identifier valueId) {
        if (agent == null) {
            throw new IllegalArgumentException("agent");
        }
        if (valueId == null) {
            throw new IllegalArgumentException("valueId");
        }
        ArrayList<ResultEntry> entries = new ArrayList<ResultEntry>();
        for (Wme w : agent.getAllWmesInRete()) {
            if (w.getValue() != valueId) continue;
            Iterator<Preference> it = w.getPreferences();
            while (it.hasNext()) {
                entries.add(this.createEntry(agent, it.next()));
            }
        }
        Result r = new Result(null, null, valueId, entries, new ArrayList(), new ArrayList());
        PrintPreferencesCommand ppc = new PrintPreferencesCommand();
        ppc.setObject(false);
        ppc.setId(valueId);
        this.addPrintResult(agent, r, ppc);
        return r;
    }

    private Result getPreferencesForObject(Agent agent, Identifier idIn) {
        WmeImpl w;
        IdentifierImpl id = (IdentifierImpl)idIn;
        ArrayList<ResultEntry> entries = new ArrayList<ResultEntry>();
        Slot s = id.slots;
        while (s != null) {
            Preference p = s.getAllPreferences();
            while (p != null) {
                entries.add(this.createEntry(agent, p));
                p = p.nextOfSlot;
            }
            s = s.next;
        }
        ArrayList<WmeImpl> impasseWmes = new ArrayList<WmeImpl>();
        WmeImpl wmeImpl = w = id.goalInfo != null ? id.goalInfo.getImpasseWmes() : null;
        while (w != null) {
            impasseWmes.add(w);
            w = w.next;
        }
        ArrayList<WmeImpl> ioWmes = new ArrayList<WmeImpl>();
        WmeImpl w2 = id.getInputWmes();
        while (w2 != null) {
            ioWmes.add(w2);
            w2 = w2.next;
        }
        Result r = new Result(idIn, null, null, entries, impasseWmes, ioWmes);
        PrintPreferencesCommand ppc = new PrintPreferencesCommand();
        ppc.setObject(true);
        ppc.setId(id);
        this.addPrintResult(agent, r, ppc);
        return r;
    }

    private ResultEntry createEntry(Agent agent, Preference pref) {
        String valueTrace;
        TraceFormats traceFormats = Adaptables.adapt(agent, TraceFormats.class);
        PredefinedSymbols predefinedSyms = Adaptables.adapt(agent, PredefinedSymbols.class);
        String source = pref.inst.prod != null ? pref.inst.prod.getName().toString() : "[dummy production]";
        List<Wme> sourceWmes = pref.inst.getBacktraceWmes();
        if (pref.attr == predefinedSyms.operator_symbol) {
            StringWriter w = new StringWriter();
            try {
                traceFormats.print_object_trace(w, pref.value);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            valueTrace = w.toString();
        } else {
            valueTrace = String.format("%s", pref.value);
        }
        return new ResultEntry(pref, valueTrace, pref.o_supported, source, sourceWmes);
    }

    private void addPrintResult(Agent agent, Result r, PrintPreferencesCommand ppc) {
        ppc.setPrintProduction(true);
        ppc.setWmeTraceType(Trace.WmeTraceType.FULL);
        try {
            StringWriter s = new StringWriter();
            ppc.print(agent, new Printer(s));
            r.setPrintResult(s.toString());
        }
        catch (IOException e) {
            r.setPrintResult(e.getMessage());
        }
    }

    public static class ResultEntry {
        private final Preference pref;
        private final boolean osupported;
        private final String valueTrace;
        private final String source;
        private final List<Wme> sourceWmes;

        private ResultEntry(Preference pref, String valueTrace, boolean osupported, String source, List<Wme> sourceWmes) {
            this.pref = pref;
            this.valueTrace = valueTrace;
            this.osupported = osupported;
            this.source = source;
            this.sourceWmes = Collections.unmodifiableList(sourceWmes);
        }

        public PreferenceType getType() {
            return this.pref.type;
        }

        public Identifier getIdentifier() {
            return this.pref.id;
        }

        public Symbol getAttribute() {
            return this.pref.attr;
        }

        public Symbol getValue() {
            return this.pref.value;
        }

        public String getValueTrace() {
            return this.valueTrace;
        }

        public Symbol getReferent() {
            return this.pref.referent;
        }

        public boolean isOSupported() {
            return this.osupported;
        }

        public String getSource() {
            return this.source;
        }

        public List<Wme> getSourceWmes() {
            return this.sourceWmes;
        }
    }

    public static class Result {
        private final String error;
        private final Identifier queryId;
        private final Symbol queryAttr;
        private final Symbol queryValue;
        private final List<ResultEntry> entries;
        private final List<Wme> impasseWmes;
        private final List<Wme> ioWmes;
        private String printResult = "";

        private Result(Identifier queryId, Symbol queryAttr, Symbol queryValue, List<ResultEntry> entries, List<Wme> impasseWmes, List<Wme> ioWmes) {
            this.error = null;
            this.queryId = queryId;
            this.queryAttr = queryAttr;
            this.queryValue = queryValue;
            this.entries = entries;
            this.impasseWmes = impasseWmes;
            this.ioWmes = ioWmes;
        }

        private Result(String error) {
            this.error = error;
            this.queryId = null;
            this.queryAttr = null;
            this.queryValue = null;
            this.entries = null;
            this.impasseWmes = null;
            this.ioWmes = null;
        }

        public String getError() {
            return this.error;
        }

        public Identifier getQueryId() {
            return this.queryId;
        }

        public Symbol getQueryAttribute() {
            return this.queryAttr;
        }

        public Symbol getQueryValue() {
            return this.queryValue;
        }

        public List<ResultEntry> getEntries() {
            return this.entries;
        }

        public List<Wme> getImpasseWmes() {
            return this.impasseWmes;
        }

        public List<Wme> getIoWmes() {
            return this.ioWmes;
        }

        public String getPrintResult() {
            return this.printResult;
        }

        private void setPrintResult(String result) {
            this.printResult = result;
        }
    }
}

