/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.commands;

import org.jsoar.kernel.Agent;
import org.jsoar.kernel.SoarException;
import org.jsoar.kernel.commands.Utils;
import org.jsoar.kernel.tracing.Trace;
import org.jsoar.util.commands.SoarCommand;
import org.jsoar.util.commands.SoarCommandContext;
import picocli.CommandLine;

public class TraceCommand
implements SoarCommand {
    private final Agent agent;
    private final Trace trace;

    public TraceCommand(Agent agent) {
        this.agent = agent;
        this.trace = agent.getTrace();
    }

    @Override
    public String execute(SoarCommandContext context, String[] args) throws SoarException {
        Utils.parseAndRun(this.agent, new TraceC(this.agent, this.trace), args);
        return "";
    }

    @Override
    public Object getCommand() {
        return new TraceC(this.agent, this.trace);
    }

    @CommandLine.Command(name="trace", description={"Control the run-time tracing of Soar"}, subcommands={CommandLine.HelpCommand.class})
    public static class TraceC
    implements Runnable {
        private final Agent agent;
        private final Trace trace;
        @CommandLine.Option(names={"-N", "--none"}, description={"Turns off all printing about Soar's internals"})
        boolean stopPrintingInternals = false;
        @CommandLine.Option(names={"-l", "--level"}, description={"Sets a trace level from 0 to 5"})
        Integer traceLevel = null;
        @CommandLine.Option(names={"-L", "--learning"}, description={"Controls the printing of chunks/justifications as they are created"})
        String learningPrintLevel = null;
        @CommandLine.Option(names={"-b", "--backtracing"}, description={"Print backtracing information when a chunk or justification is created"})
        boolean printBacktracing = false;
        @CommandLine.Option(names={"-d", "--decisions"}, description={"Controls whether state and operator decisions are printed as they are made"})
        boolean printDecisions = false;
        @CommandLine.Option(names={"-e", "--epmem"}, description={"Print episodic retrieval traces and IDs of newly encoded episodes"})
        boolean printEpmem = false;
        @CommandLine.Option(names={"-g", "--gds"}, description={"Controls printing of warnings when a state is removed due to the GDS"})
        boolean printGds = false;
        @CommandLine.Option(names={"-G", "--gds-wmes"}, description={"Controls printing of warnings about wme changes to the GDS"})
        boolean printGdsWmes = false;
        @CommandLine.Option(names={"-i", "--indifferent-selection"}, description={"Print scores for tied operators in random indifferent selection mode"})
        boolean printIndifferentSelection = false;
        @CommandLine.Option(names={"-p", "--phases"}, description={"Controls whether decision cycle phase names are printed as Soar executes"})
        boolean printPhases = false;
        @CommandLine.Option(names={"-r", "--preferences"}, description={"Controls whether the preferences generated by the traced productions are printed when those productions fire or retract"})
        boolean printPreferences = false;
        @CommandLine.Option(names={"-P", "--productions"}, description={"Controls whether the names of productions are printed as they fire and retract"})
        boolean printProductions = false;
        @CommandLine.Option(names={"-R", "--rl"}, description={"Print RL debugging output"})
        boolean printRl = false;
        @CommandLine.Option(names={"-s", "--smem"}, description={"Print log of semantic memory storage events"})
        boolean printSmem = false;
        @CommandLine.Option(names={"-w", "--wmes"}, description={"Controls the printing of working memory elements that are added and deleted as productions are fired and retracted"})
        boolean printWmes = false;
        @CommandLine.Option(names={"-W", "--waterfall"}, description={"Controls printing of firings inhibited by higher-level firings"})
        boolean printWaterfall = false;
        @CommandLine.Option(names={"-a", "--wma"}, description={"Print log of working memory activation events"})
        boolean printWma = false;
        @CommandLine.Option(names={"-A", "--assertions"}, description={"Print assertions of rule instantiations and the preferences they generate"})
        boolean printAssertions = false;
        @CommandLine.Option(names={"-D", "--default"}, description={"Control only default-productions as they fire and retract"})
        boolean printDefaultProds = false;
        @CommandLine.Option(names={"-u", "--user"}, description={"Control only user-productions as they fire and retract"})
        boolean printUserProds = false;
        @CommandLine.Option(names={"-c", "--chunks"}, description={"Control only chunks as they fire and retract"})
        boolean printChunks = false;
        @CommandLine.Option(names={"-j", "--justifications"}, description={"Control only justifications as they fire and retract"})
        boolean printJustify = false;
        @CommandLine.Option(names={"-T", "--template"}, description={"Soar-RL template firing trace"})
        boolean printTemplates = false;
        @CommandLine.Parameters(arity="0..1", description={"Turns the specified setting off"})
        String remove = null;

        public TraceC(Agent agent, Trace trace) {
            this.agent = agent;
            this.trace = trace;
        }

        @Override
        public void run() {
            if (!(this.stopPrintingInternals || this.traceLevel != null || this.learningPrintLevel != null || this.printBacktracing || this.printDecisions || this.printEpmem || this.printGds || this.printIndifferentSelection || this.printPhases || this.printPreferences || this.printProductions || this.printRl || this.printSmem || this.printWmes || this.printWaterfall || this.printWma || this.printDefaultProds || this.printUserProds || this.printChunks || this.printJustify || this.printTemplates || this.printAssertions)) {
                block32: {
                    if (this.remove != null) {
                        try {
                            this.traceLevel = Integer.valueOf(this.remove);
                            if (this.traceLevel >= 0 && this.traceLevel <= 5) {
                                this.trace.setWatchLevel(this.traceLevel);
                                this.printTraceLevelDetails(this.traceLevel);
                                break block32;
                            }
                            this.agent.getPrinter().startNewLine().print("Error: trace level must be between 0 and 5 (inclusive)");
                        }
                        catch (NumberFormatException e) {
                            this.agent.getPrinter().startNewLine().print("Invalid command. Type 'trace help' for a list of trace commands.");
                        }
                    } else {
                        this.printWatchSettings();
                    }
                }
                return;
            }
            if (this.remove != null && !this.remove.equals("remove") && !this.remove.equals("0")) {
                this.agent.getPrinter().startNewLine().print("Invalid argument; expected 'remove' or '0'");
                return;
            }
            if (this.stopPrintingInternals) {
                this.trace.setWatchLevel(0);
                this.agent.getPrinter().startNewLine().print("Will not print working memory element details.");
            }
            if (this.traceLevel != null) {
                if (this.traceLevel >= 0 && this.traceLevel <= 5) {
                    this.trace.setWatchLevel(this.traceLevel);
                    this.printTraceLevelDetails(this.traceLevel);
                } else {
                    this.agent.getPrinter().startNewLine().print("Error: trace level must be between 0 and 5 (inclusive)");
                }
            }
            if (this.learningPrintLevel != null) {
                this.processLearning(this.learningPrintLevel);
            }
            if (this.printBacktracing) {
                this.toggleAndPrint(Trace.Category.BACKTRACING, this.remove == null, "assertions of rule instantiations and the preferences they generate.");
            }
            if (this.printDecisions) {
                this.toggleAndPrint(Trace.Category.CONTEXT_DECISIONS, this.remove == null, "states created and operators selected.");
            }
            if (this.printEpmem) {
                this.toggleAndPrint(Trace.Category.EPMEM, this.remove == null, "when episodic memory records a new episode or considers an episode in a query.");
            }
            if (this.printGds) {
                this.toggleAndPrint(Trace.Category.GDS, this.remove == null, "when a state is removed because of a GDS violation.");
            }
            if (this.printGdsWmes) {
                this.agent.getPrinter().startNewLine().print("This option has not been implemented in JSoar");
            }
            if (this.printIndifferentSelection) {
                this.toggleAndPrint(Trace.Category.INDIFFERENT, this.remove == null, "how Soar calculates and resolves numeric preferences.");
            }
            if (this.printPhases) {
                this.toggleAndPrint(Trace.Category.PHASES, this.remove == null, "each individual phase.");
            }
            if (this.printPreferences) {
                this.toggleAndPrint(Trace.Category.FIRINGS_PREFERENCES, this.remove == null, "preferences as they are created.");
            }
            if (this.printProductions) {
                this.toggleAndPrint(Trace.Category.FIRINGS_OF_DEFAULT_PRODS, this.remove == null, "when rules marked as :default fire.");
                this.toggleAndPrint(Trace.Category.FIRINGS_OF_USER_PRODS, this.remove == null, "when user rules fire.");
                this.toggleAndPrint(Trace.Category.FIRINGS_OF_CHUNKS, this.remove == null, "when chunks fire.");
                this.toggleAndPrint(Trace.Category.FIRINGS_OF_JUSTIFICATIONS, this.remove == null, "when justifications fire.");
            }
            if (this.printRl) {
                this.toggleAndPrint(Trace.Category.RL, this.remove == null, "reinforcement learning value updates and gap intervals.");
            }
            if (this.printSmem) {
                this.toggleAndPrint(Trace.Category.SMEM, this.remove == null, "additions to semantic memory.");
            }
            if (this.printWmes) {
                this.toggleAndPrint(Trace.Category.WM_CHANGES, this.remove == null, "when working memory elements are added to or removed from memory.");
            }
            if (this.printWaterfall) {
                this.toggleAndPrint(Trace.Category.WATERFALL, this.remove == null, "when rules do not fire because a higher level rule matches and needs to fire first.");
            }
            if (this.printWma) {
                this.toggleAndPrint(Trace.Category.WMA, this.remove == null, "working memory activations, changed values, and removals caused by forgetting (if enabled).");
            }
            if (this.printDefaultProds) {
                this.toggleAndPrint(Trace.Category.FIRINGS_OF_DEFAULT_PRODS, this.remove == null, "when rules marked as :default fire.");
            }
            if (this.printUserProds) {
                this.toggleAndPrint(Trace.Category.FIRINGS_OF_USER_PRODS, this.remove == null, "when user rules fire.");
            }
            if (this.printChunks) {
                this.toggleAndPrint(Trace.Category.FIRINGS_OF_CHUNKS, this.remove == null, "when chunks fire.");
            }
            if (this.printJustify) {
                this.toggleAndPrint(Trace.Category.FIRINGS_OF_JUSTIFICATIONS, this.remove == null, "when justifications fire.");
            }
            if (this.printTemplates) {
                this.toggleAndPrint(Trace.Category.FIRINGS_OF_TEMPLATES, this.remove == null, "when templates match.");
            }
            if (this.printAssertions) {
                this.toggleAndPrint(Trace.Category.VERBOSE, this.remove == null, "assertions of rule instantiations and the preferences they generate.");
            }
        }

        private String setting(String title, Trace.Category c) {
            return "  " + title + ": " + (this.trace.isEnabled(c) ? "on" : "off") + "\n";
        }

        private void printTraceLevelDetails(Integer level) {
            if (level == 0) {
                this.agent.getPrinter().startNewLine().print("Trace level 0 enabled: All messages disabled.");
            }
            for (int i = level.intValue(); i > 0; --i) {
                this.agent.getPrinter().startNewLine().print("Trace level " + i + " enabled: ");
                if (i == 1) {
                    this.agent.getPrinter().print("Decision cycles, state creation and operator selection");
                    continue;
                }
                if (i == 2) {
                    this.agent.getPrinter().print("All phases, state removals caused by operator selection or a GDS violation, and any learning issues detected");
                    continue;
                }
                if (i == 3) {
                    this.agent.getPrinter().print("All rule firings");
                    continue;
                }
                if (i == 4) {
                    this.agent.getPrinter().print("Working memory element additions and removals");
                    continue;
                }
                if (i != 5) continue;
                this.agent.getPrinter().print("Preferences");
            }
        }

        private void processLearning(String printLevel) {
            if (printLevel.equals("noprint") || printLevel.equals("0")) {
                this.trace.setEnabled(Trace.Category.CHUNK_NAMES, false);
                this.trace.setEnabled(Trace.Category.CHUNKS, false);
                this.trace.setEnabled(Trace.Category.JUSTIFICATION_NAMES, false);
                this.trace.setEnabled(Trace.Category.JUSTIFICATIONS, false);
                this.agent.getPrinter().startNewLine().print("Will not print any information about chunks or justifications learned.");
            } else if (printLevel.equals("print") || printLevel.equals("1")) {
                this.trace.setEnabled(Trace.Category.CHUNK_NAMES, true);
                this.trace.setEnabled(Trace.Category.CHUNKS, false);
                this.trace.setEnabled(Trace.Category.JUSTIFICATION_NAMES, true);
                this.trace.setEnabled(Trace.Category.JUSTIFICATIONS, false);
                this.agent.getPrinter().startNewLine().print("Now printing the names of chunks and justifications that are learned and any chunking issues detected.");
            } else if (printLevel.equals("fullprint") || printLevel.equals("2")) {
                this.trace.setEnabled(Trace.Category.CHUNK_NAMES, true);
                this.trace.setEnabled(Trace.Category.CHUNKS, true);
                this.trace.setEnabled(Trace.Category.JUSTIFICATION_NAMES, true);
                this.trace.setEnabled(Trace.Category.JUSTIFICATIONS, true);
                this.agent.getPrinter().startNewLine().print("Now printing the full chunks and justifications that are learned and any chunking issues detected.");
            } else {
                this.agent.getPrinter().startNewLine().print("Invalid learn setting, expected noprint, print, fullprint, or 0-2. Got: " + printLevel);
            }
        }

        private void toggleAndPrint(Trace.Category c, boolean enable, String tailOfMessage) {
            if (enable) {
                this.trace.setEnabled(c, true);
                this.agent.getPrinter().startNewLine().print("Now printing " + tailOfMessage);
            } else {
                this.trace.setEnabled(c, false);
                this.agent.getPrinter().startNewLine().print("Will not print " + tailOfMessage);
            }
        }

        private void printWatchSettings() {
            StringBuilder b = new StringBuilder("Current watch settings:\n");
            b.append(this.setting("Decisions", Trace.Category.CONTEXT_DECISIONS));
            b.append(this.setting("Phases", Trace.Category.PHASES));
            b.append(this.setting("Default productions", Trace.Category.FIRINGS_OF_DEFAULT_PRODS));
            b.append(this.setting("User productions", Trace.Category.FIRINGS_OF_USER_PRODS));
            b.append(this.setting("Chunks", Trace.Category.FIRINGS_OF_CHUNKS));
            b.append(this.setting("Justifications", Trace.Category.FIRINGS_OF_JUSTIFICATIONS));
            b.append(this.setting("Templates", Trace.Category.FIRINGS_OF_TEMPLATES));
            b.append("    WME detail level: " + (Object)((Object)this.trace.getWmeTraceType()) + "\n");
            b.append(this.setting("Working memory changes", Trace.Category.WM_CHANGES));
            b.append(this.setting("Preferences generated by firings/retractions", Trace.Category.FIRINGS_PREFERENCES));
            b.append("  Learning: ??\n");
            b.append(this.setting("Backtracing", Trace.Category.BACKTRACING));
            b.append(this.setting("Indifferent selection", Trace.Category.INDIFFERENT));
            b.append(this.setting("Epmem", Trace.Category.EPMEM));
            b.append(this.setting("Soar-RL", Trace.Category.RL));
            b.append(this.setting("Waterfall", Trace.Category.WATERFALL));
            this.agent.getPrinter().startNewLine().print(b.toString());
        }
    }
}

