/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.commands;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.output.WriterOutputStream;
import org.jsoar.kernel.Agent;
import org.jsoar.kernel.SoarException;
import org.jsoar.kernel.commands.DebugCommand;
import picocli.CommandLine;

public class Utils {
    public static void parseAndRun(Agent agent, Object command, String[] args) throws SoarException {
        WriterOutputStream os = new WriterOutputStream(agent.getPrinter().getWriter(), Charset.defaultCharset(), 1024, true);
        PrintStream ps = new PrintStream((OutputStream)os);
        Utils.parseAndRun(command, args, ps);
    }

    public static List<Object> parseAndRun(Object command, String[] args, PrintStream ps) throws SoarException {
        CommandLine commandLine = new CommandLine(command);
        if (command.getClass() == DebugCommand.Debug.class) {
            commandLine.setUnmatchedOptionsArePositionalParams(true);
        }
        try {
            return (List)commandLine.parseWithHandlers((CommandLine.IParseResultHandler2)new CommandLine.RunLast().useOut(ps), (CommandLine.IExceptionHandler2)new ExceptionHandler(), Arrays.copyOfRange(args, 1, args.length));
        }
        catch (Exception e) {
            throw new SoarException(e.getMessage(), e);
        }
    }

    public static String parseAndRun(Object command, String[] args) throws SoarException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (PrintStream ps = new PrintStream((OutputStream)baos, true, "UTF-8");){
            List<Object> results = Utils.parseAndRun(command, args, ps);
            if (results != null) {
                for (Object o : results) {
                    if (o == null) continue;
                    ps.print(o.toString());
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new SoarException(e);
        }
        String result = new String(baos.toByteArray(), StandardCharsets.UTF_8);
        return result;
    }

    protected static class ExceptionHandler
    implements CommandLine.IExceptionHandler2<List<Object>> {
        protected ExceptionHandler() {
        }

        public List<Object> handleParseException(CommandLine.ParameterException ex, String[] args) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                PrintStream ps = new PrintStream((OutputStream)baos, true, "UTF-8");
                Throwable throwable = null;
                try {
                    try {
                        ps.println(ex.getMessage());
                        if (!CommandLine.UnmatchedArgumentException.printSuggestions((CommandLine.ParameterException)ex, (PrintStream)ps)) {
                            ex.getCommandLine().usage(ps, CommandLine.Help.Ansi.AUTO);
                        }
                        String result = new String(baos.toByteArray(), StandardCharsets.UTF_8);
                        throw new RuntimeException(result, (Throwable)ex);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                catch (Throwable throwable3) {
                    if (ps != null) {
                        if (throwable != null) {
                            try {
                                ps.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            ps.close();
                        }
                    }
                    throw throwable3;
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }

        public List<Object> handleExecutionException(CommandLine.ExecutionException ex, CommandLine.ParseResult parseResult) {
            throw ex;
        }
    }
}

