/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.epmem;

import java.util.HashSet;
import java.util.Set;
import org.jsoar.kernel.symbols.SymbolFactory;
import org.jsoar.kernel.symbols.SymbolImpl;
import org.jsoar.util.properties.DefaultPropertyProvider;
import org.jsoar.util.properties.DoublePropertyProvider;
import org.jsoar.util.properties.EnumPropertyProvider;
import org.jsoar.util.properties.LongPropertyProvider;
import org.jsoar.util.properties.PropertyKey;
import org.jsoar.util.properties.PropertyManager;

class DefaultEpisodicMemoryParams {
    Set<SymbolImpl> exclusions = new HashSet<SymbolImpl>();
    Set<SymbolImpl> inclusions = new HashSet<SymbolImpl>();
    private static final String PREFIX = "epmem.params.";
    static final PropertyKey<String> DRIVER = DefaultEpisodicMemoryParams.key("driver", String.class).defaultValue("org.sqlite.JDBC").build();
    final DefaultPropertyProvider<String> driver = new DefaultPropertyProvider<String>(DRIVER);
    static final PropertyKey<String> PROTOCOL = DefaultEpisodicMemoryParams.key("protocol", String.class).defaultValue("jdbc:sqlite").build();
    final DefaultPropertyProvider<String> protocol = new DefaultPropertyProvider<String>(PROTOCOL);
    static final PropertyKey<LazyCommitChoices> LAZY_COMMIT = DefaultEpisodicMemoryParams.key("lazy-commit", LazyCommitChoices.class).defaultValue(LazyCommitChoices.on).build();
    final EnumPropertyProvider<LazyCommitChoices> lazy_commit = new EnumPropertyProvider<LazyCommitChoices>(LAZY_COMMIT);
    static final PropertyKey<Double> BALANCE = DefaultEpisodicMemoryParams.key("balance", Double.class).defaultValue(1.0).build();
    final DoublePropertyProvider balance = new DoublePropertyProvider(BALANCE);
    static final PropertyKey<String> PATH = DefaultEpisodicMemoryParams.key("path", String.class).defaultValue(":memory:").build();
    final DefaultPropertyProvider<String> path = new DefaultPropertyProvider<String>(PATH);
    static final PropertyKey<PageChoices> PAGE_SIZE = DefaultEpisodicMemoryParams.key("page-size", PageChoices.class).defaultValue(PageChoices.page_8k).build();
    final EnumPropertyProvider<PageChoices> page_size = new EnumPropertyProvider<PageChoices>(PAGE_SIZE);
    static final PropertyKey<Long> CACHE_SIZE = DefaultEpisodicMemoryParams.key("cache-size", Long.class).defaultValue(10000L).build();
    final LongPropertyProvider cache_size = new LongPropertyProvider(CACHE_SIZE);
    static final PropertyKey<Optimization> OPTIMIZATION = DefaultEpisodicMemoryParams.key("optimization", Optimization.class).defaultValue(Optimization.performance).build();
    final EnumPropertyProvider<Optimization> optimization = new EnumPropertyProvider<Optimization>(OPTIMIZATION);
    static final PropertyKey<AppendDatabaseChoices> APPEND_DB = DefaultEpisodicMemoryParams.key("append-database", AppendDatabaseChoices.class).defaultValue(AppendDatabaseChoices.off).build();
    final EnumPropertyProvider<AppendDatabaseChoices> append_database = new EnumPropertyProvider<AppendDatabaseChoices>(APPEND_DB);
    static final PropertyKey<Phase> PHASE = DefaultEpisodicMemoryParams.key("phase", Phase.class).defaultValue(Phase.output).build();
    final EnumPropertyProvider<Phase> phase = new EnumPropertyProvider<Phase>(PHASE);
    static final PropertyKey<Learning> LEARNING = DefaultEpisodicMemoryParams.key("learning", Learning.class).defaultValue(Learning.off).build();
    final EnumPropertyProvider<Learning> learning = new EnumPropertyProvider<Learning>(LEARNING);
    static final PropertyKey<Force> FORCE = DefaultEpisodicMemoryParams.key("force", Force.class).defaultValue(Force.off).build();
    final EnumPropertyProvider<Force> force = new EnumPropertyProvider<Force>(FORCE);
    static final PropertyKey<Trigger> TRIGGER = DefaultEpisodicMemoryParams.key("trigger", Trigger.class).defaultValue(Trigger.dc).build();
    final EnumPropertyProvider<Trigger> trigger = new EnumPropertyProvider<Trigger>(TRIGGER);
    static final PropertyKey<MergeChoices> MERGE = DefaultEpisodicMemoryParams.key("merge", MergeChoices.class).defaultValue(MergeChoices.none).build();
    final EnumPropertyProvider<MergeChoices> merge = new EnumPropertyProvider<MergeChoices>(MERGE);
    static final PropertyKey<GraphMatchChoices> GRAPH_MATCH = DefaultEpisodicMemoryParams.key("graph-match", GraphMatchChoices.class).defaultValue(GraphMatchChoices.on).build();
    final EnumPropertyProvider<GraphMatchChoices> graph_match = new EnumPropertyProvider<GraphMatchChoices>(GRAPH_MATCH);
    static final PropertyKey<GmOrderingChoices> GM_ORDERING = DefaultEpisodicMemoryParams.key("graph-match-ordering", GmOrderingChoices.class).defaultValue(GmOrderingChoices.undefined).build();
    final EnumPropertyProvider<GmOrderingChoices> gm_ordering = new EnumPropertyProvider<GmOrderingChoices>(GM_ORDERING);
    private final PropertyManager properties;

    private static <T> PropertyKey.Builder<T> key(String name, Class<T> type) {
        return PropertyKey.builder(PREFIX + name, type);
    }

    public DefaultEpisodicMemoryParams(PropertyManager properties, SymbolFactory sf) {
        this.properties = properties;
        properties.setProvider(DRIVER, this.driver);
        properties.setProvider(PROTOCOL, this.protocol);
        properties.setProvider(PATH, this.path);
        properties.setProvider(LAZY_COMMIT, this.lazy_commit);
        properties.setProvider(PAGE_SIZE, this.page_size);
        properties.setProvider(CACHE_SIZE, this.cache_size);
        properties.setProvider(OPTIMIZATION, this.optimization);
        properties.setProvider(PHASE, this.phase);
        properties.setProvider(LEARNING, this.learning);
        properties.setProvider(FORCE, this.force);
        properties.setProvider(TRIGGER, this.trigger);
        properties.setProvider(MERGE, this.merge);
        properties.setProvider(GRAPH_MATCH, this.graph_match);
        properties.setProvider(GM_ORDERING, this.gm_ordering);
        properties.setProvider(BALANCE, this.balance);
        properties.setProvider(APPEND_DB, this.append_database);
        this.exclusions.add((SymbolImpl)((Object)sf.createString("epmem")));
        this.exclusions.add((SymbolImpl)((Object)sf.createString("smem")));
    }

    public PropertyManager getProperties() {
        return this.properties;
    }

    public static PropertyKey<?> getProperty(PropertyManager props, String name) {
        return props.getKey(PREFIX + name);
    }

    static enum LazyCommitChoices {
        on,
        off;

    }

    static enum AppendDatabaseChoices {
        on,
        off;

    }

    static enum GmOrderingChoices {
        undefined,
        dfs,
        mcv;

    }

    static enum GraphMatchChoices {
        on,
        off;

    }

    static enum MergeChoices {
        none,
        add;

    }

    static enum Trigger {
        none,
        output,
        dc;

    }

    static enum Force {
        remember,
        ignore,
        off;

    }

    static enum Learning {
        on,
        off;

    }

    static enum Phase {
        output,
        selection;

    }

    static enum PageChoices {
        page_1k,
        page_2k,
        page_4k,
        page_8k,
        page_16k,
        page_32k,
        page_64k;


        public String toString() {
            switch (this) {
                case page_1k: {
                    return "1k";
                }
                case page_2k: {
                    return "2k";
                }
                case page_4k: {
                    return "4k";
                }
                case page_8k: {
                    return "8k";
                }
                case page_16k: {
                    return "16k";
                }
                case page_32k: {
                    return "32k";
                }
                case page_64k: {
                    return "64k";
                }
            }
            throw new IllegalArgumentException();
        }
    }

    static enum Optimization {
        safety,
        performance;

    }
}

