/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.epmem;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.Set;
import org.jsoar.kernel.Agent;
import org.jsoar.kernel.SoarException;
import org.jsoar.kernel.commands.Utils;
import org.jsoar.kernel.epmem.DefaultEpisodicMemory;
import org.jsoar.kernel.epmem.DefaultEpisodicMemoryParams;
import org.jsoar.kernel.epmem.DefaultEpisodicMemoryStats;
import org.jsoar.kernel.epmem.EpisodicMemoryDatabase;
import org.jsoar.kernel.symbols.StringSymbolImpl;
import org.jsoar.kernel.symbols.SymbolFactoryImpl;
import org.jsoar.kernel.symbols.SymbolImpl;
import org.jsoar.util.ByRef;
import org.jsoar.util.PrintHelper;
import org.jsoar.util.adaptables.Adaptable;
import org.jsoar.util.adaptables.Adaptables;
import org.jsoar.util.commands.SoarCommand;
import org.jsoar.util.commands.SoarCommandContext;
import org.jsoar.util.commands.SoarCommandInterpreter;
import org.jsoar.util.commands.SoarCommandProvider;
import org.jsoar.util.properties.PropertyKey;
import org.jsoar.util.properties.PropertyManager;
import picocli.CommandLine;

public class EpmemCommand
implements SoarCommand {
    private final Agent agent;

    public EpmemCommand(Adaptable context) {
        this.agent = (Agent)context;
    }

    @Override
    public Object getCommand() {
        return new EpmemC(this.agent);
    }

    @Override
    public String execute(SoarCommandContext context, String[] args) throws SoarException {
        Utils.parseAndRun(this.agent, new EpmemC(this.agent), args);
        return "";
    }

    @CommandLine.Command(name="epmem", description={"Controls the behavior of episodic memory"}, subcommands={CommandLine.HelpCommand.class})
    public static class EpmemC
    implements Runnable {
        private final Agent agent;
        private final DefaultEpisodicMemory epmem;
        private final SymbolFactoryImpl symbols;
        @CommandLine.Spec
        private CommandLine.Model.CommandSpec spec;
        @CommandLine.Option(names={"-s", "--set"}, description={"Sets the given parameter value"})
        String setParam = null;
        @CommandLine.Option(names={"-g", "--get"}, description={"Prints the current setting of the given parameter"})
        String getParam = null;
        @CommandLine.Option(names={"-S", "--stats"}, description={"Prints statistic summary or specific statistic"})
        boolean printStats = false;
        @CommandLine.Option(names={"-p", "--print"}, description={"Prints episode in a user-readable format"})
        String printEpisode = null;
        @CommandLine.Option(names={"-r", "--reinit"}, description={"Re-initializes episodic memory"})
        boolean reinit = false;
        @CommandLine.Option(names={"-b", "--backup"}, arity="1..*", description={"Creates a backup of the episodic database on disk"})
        String[] backupFileName = null;
        @CommandLine.Option(names={"-a", "--add"}, description={"Adds knowledge to episodic memory"})
        String knowledgeToAdd = null;
        @CommandLine.Parameters(arity="0..1", description={"The new value of the parameter; or specific statistic to print"})
        String param = null;

        public EpmemC(Agent agent) {
            this.agent = agent;
            this.epmem = Adaptables.require(this.getClass(), agent, DefaultEpisodicMemory.class);
            this.symbols = Adaptables.require(this.getClass(), agent, SymbolFactoryImpl.class);
        }

        @Override
        public void run() {
            if (this.setParam != null) {
                if (this.param == null) {
                    throw new CommandLine.ParameterException(this.spec.commandLine(), "No parameter value provided");
                }
                this.agent.getPrinter().print(this.doSet(this.setParam, this.param));
            } else if (this.getParam != null) {
                this.agent.getPrinter().print(this.doGet(this.getParam));
            } else if (this.printStats) {
                this.agent.getPrinter().print(this.doStats(this.param));
            } else if (this.printEpisode != null) {
                this.agent.getPrinter().print(this.doPrintEpisode(this.printEpisode));
            } else if (this.reinit) {
                this.agent.getPrinter().print(this.doReinit());
            } else if (this.backupFileName != null) {
                this.agent.getPrinter().print(this.doBackup(this.backupFileName));
            } else if (this.knowledgeToAdd != null) {
                this.agent.getPrinter().print(this.doAdd(this.knowledgeToAdd));
            } else {
                this.agent.getPrinter().print(this.doEpmem());
            }
        }

        private String doSet(String paramToSet, String value) {
            PropertyManager props = this.epmem.getParams().getProperties();
            try {
                if (paramToSet.equals("learning")) {
                    props.set(DefaultEpisodicMemoryParams.LEARNING, DefaultEpisodicMemoryParams.Learning.valueOf(value));
                    return "Set learning to " + DefaultEpisodicMemoryParams.Learning.valueOf(value).toString();
                }
                if (paramToSet.equals("trigger")) {
                    props.set(DefaultEpisodicMemoryParams.TRIGGER, DefaultEpisodicMemoryParams.Trigger.valueOf(value));
                    return "Set trigger to " + DefaultEpisodicMemoryParams.Trigger.valueOf(value).toString();
                }
                if (paramToSet.equals("phase")) {
                    props.set(DefaultEpisodicMemoryParams.PHASE, DefaultEpisodicMemoryParams.Phase.valueOf(value));
                    return "Set phase to " + DefaultEpisodicMemoryParams.Phase.valueOf(value).toString();
                }
                if (paramToSet.equals("graph-match")) {
                    props.set(DefaultEpisodicMemoryParams.GRAPH_MATCH, DefaultEpisodicMemoryParams.GraphMatchChoices.valueOf(value));
                    return "Set graph-match to " + (Object)((Object)DefaultEpisodicMemoryParams.GraphMatchChoices.valueOf(value));
                }
                if (paramToSet.equals("graph-match-ordering")) {
                    props.set(DefaultEpisodicMemoryParams.GM_ORDERING, DefaultEpisodicMemoryParams.GmOrderingChoices.valueOf(value));
                    return "Set graph-match-ordering to " + DefaultEpisodicMemoryParams.GmOrderingChoices.valueOf(value).toString();
                }
                if (paramToSet.equals("balance")) {
                    props.set(DefaultEpisodicMemoryParams.BALANCE, Double.parseDouble(value));
                    return "Set balance to " + Double.parseDouble(value);
                }
                if (paramToSet.equals("optimization")) {
                    props.set(DefaultEpisodicMemoryParams.OPTIMIZATION, DefaultEpisodicMemoryParams.Optimization.valueOf(value));
                    return "Set optimization to " + (Object)((Object)DefaultEpisodicMemoryParams.Optimization.valueOf(value));
                }
                if (paramToSet.equals("path")) {
                    props.set(DefaultEpisodicMemoryParams.PATH, value);
                    return "Set path to " + value;
                }
                if (paramToSet.equals("append-database")) {
                    props.set(DefaultEpisodicMemoryParams.APPEND_DB, DefaultEpisodicMemoryParams.AppendDatabaseChoices.valueOf(value));
                    return "Set append to " + (Object)((Object)DefaultEpisodicMemoryParams.AppendDatabaseChoices.valueOf(value));
                }
                if (paramToSet.equals("page-size")) {
                    props.set(DefaultEpisodicMemoryParams.PAGE_SIZE, DefaultEpisodicMemoryParams.PageChoices.valueOf(value));
                    return "Set page size to " + (Object)((Object)DefaultEpisodicMemoryParams.PageChoices.valueOf(value));
                }
                if (paramToSet.equals("cache-size")) {
                    props.set(DefaultEpisodicMemoryParams.CACHE_SIZE, Long.valueOf(value));
                    return "Set cache size to " + Long.valueOf(value);
                }
                if (paramToSet.equals("lazy-commit")) {
                    if (this.epmem.db != null) {
                        return "Lazy commit is protected while the database is open.";
                    }
                    props.set(DefaultEpisodicMemoryParams.LAZY_COMMIT, DefaultEpisodicMemoryParams.LazyCommitChoices.valueOf(value));
                    return "Set lazy-commit to " + (Object)((Object)DefaultEpisodicMemoryParams.LazyCommitChoices.valueOf(value));
                }
                if (paramToSet.equals("exclusions")) {
                    DefaultEpisodicMemoryParams params = this.epmem.getParams();
                    StringSymbolImpl sym = this.symbols.createString(value);
                    if (params.exclusions.contains(sym)) {
                        params.exclusions.remove(sym);
                    } else {
                        params.exclusions.add(sym);
                    }
                } else if (paramToSet.equals("inclusions")) {
                    DefaultEpisodicMemoryParams params = this.epmem.getParams();
                    StringSymbolImpl sym = this.symbols.createString(value);
                    if (params.inclusions.contains(sym)) {
                        params.inclusions.remove(sym);
                    } else {
                        params.inclusions.add(sym);
                    }
                } else {
                    if (paramToSet.equals("force")) {
                        props.set(DefaultEpisodicMemoryParams.FORCE, DefaultEpisodicMemoryParams.Force.valueOf(value));
                        return "EpMem| force = " + value;
                    }
                    if (paramToSet.equals("database")) {
                        if (value.equals("memory")) {
                            props.set(DefaultEpisodicMemoryParams.PATH, ":memory:");
                            return "EpMem| database = memory";
                        }
                        if (value.equals("file")) {
                            props.set(DefaultEpisodicMemoryParams.PATH, "");
                            return "EpMem| database = file";
                        }
                        throw new CommandLine.ParameterException(this.spec.commandLine(), "Invalid value for EpMem database parameter");
                    }
                    this.agent.getPrinter().startNewLine().print("Unknown epmem parameter '" + paramToSet + "'");
                }
            }
            catch (IllegalArgumentException e) {
                throw new CommandLine.ParameterException(this.spec.commandLine(), "Invalid value.", (Throwable)e);
            }
            return "";
        }

        private String doGet(String paramToGet) {
            PropertyKey<?> key = DefaultEpisodicMemoryParams.getProperty(this.epmem.getParams().getProperties(), paramToGet);
            if (key == null) {
                if (paramToGet.equals("database")) {
                    PropertyKey<?> pathProperty = DefaultEpisodicMemoryParams.getProperty(this.epmem.getParams().getProperties(), "path");
                    if (pathProperty == null) {
                        this.agent.getPrinter().startNewLine().print("Path is null.");
                        return "";
                    }
                    String path = this.epmem.getParams().getProperties().get(pathProperty).toString();
                    if (path.equals(":memory:")) {
                        return "memory";
                    }
                    return "file";
                }
                if (paramToGet.equals("exclusions")) {
                    String exclusionStringList = "";
                    Set<SymbolImpl> exclusions = this.epmem.getParams().exclusions;
                    Iterator<SymbolImpl> it = exclusions.iterator();
                    while (it.hasNext()) {
                        exclusionStringList = exclusionStringList + it.next().toString();
                        if (!it.hasNext()) continue;
                        exclusionStringList = exclusionStringList + ", ";
                    }
                    return exclusionStringList;
                }
                if (paramToGet.equals("inclusions")) {
                    String inclusionStringList = "";
                    Set<SymbolImpl> inclusions = this.epmem.getParams().inclusions;
                    Iterator<SymbolImpl> it = inclusions.iterator();
                    while (it.hasNext()) {
                        inclusionStringList = inclusionStringList + it.next().toString();
                        if (!it.hasNext()) continue;
                        inclusionStringList = inclusionStringList + ", ";
                    }
                    return inclusionStringList;
                }
                throw new CommandLine.ParameterException(this.spec.commandLine(), "Unknown parameter '" + paramToGet + "'");
            }
            return this.epmem.getParams().getProperties().get(key).toString();
        }

        private String doEpmem() {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            DefaultEpisodicMemoryParams p = this.epmem.getParams();
            pw.printf(PrintHelper.generateHeader("Episodic Memory Settings", 40), new Object[0]);
            pw.printf(PrintHelper.generateItem("learning:", p.learning.get(), 40), new Object[0]);
            pw.printf(PrintHelper.generateSection("Encoding", 40), new Object[0]);
            pw.printf(PrintHelper.generateItem("phase:", p.phase.get(), 40), new Object[0]);
            pw.printf(PrintHelper.generateItem("trigger:", p.trigger.get(), 40), new Object[0]);
            pw.printf(PrintHelper.generateItem("force:", p.force.get(), 40), new Object[0]);
            pw.printf(PrintHelper.generateItem("exclusions:", p.exclusions, 40), new Object[0]);
            pw.printf(PrintHelper.generateItem("inclusions:", p.inclusions, 40), new Object[0]);
            pw.printf(PrintHelper.generateSection("Storage", 40), new Object[0]);
            pw.printf(PrintHelper.generateItem("driver:", p.driver, 40), new Object[0]);
            String nativeOrPure = null;
            try {
                EpisodicMemoryDatabase db = this.epmem.getDatabase();
                nativeOrPure = db != null ? db.getConnection().getMetaData().getDriverVersion() : "Not connected to database";
            }
            catch (SQLException e) {
                this.agent.getPrinter().startNewLine().print(e.getMessage());
                return "";
            }
            pw.printf(PrintHelper.generateItem("driver-type:", nativeOrPure, 40), new Object[0]);
            pw.printf(PrintHelper.generateItem("protocol:", p.protocol.get(), 40), new Object[0]);
            pw.printf(PrintHelper.generateItem("append-database:", p.append_database.get(), 40), new Object[0]);
            String database = "memory";
            String path = "";
            if (!p.path.get().equals(":memory:")) {
                database = "file";
                path = p.path.get();
            }
            pw.printf(PrintHelper.generateItem("database:", database, 40), new Object[0]);
            pw.printf(PrintHelper.generateItem("path:", path, 40), new Object[0]);
            pw.printf(PrintHelper.generateItem("lazy-commit:", p.lazy_commit.get(), 40), new Object[0]);
            pw.printf(PrintHelper.generateSection("Retrieval", 40), new Object[0]);
            pw.printf(PrintHelper.generateItem("balance:", p.balance.get(), 40), new Object[0]);
            pw.printf(PrintHelper.generateItem("graph-match:", p.graph_match.get(), 40), new Object[0]);
            pw.printf(PrintHelper.generateItem("graph-match-ordering:", p.gm_ordering.get(), 40), new Object[0]);
            pw.printf(PrintHelper.generateSection("Performance", 40), new Object[0]);
            pw.printf(PrintHelper.generateItem("page-size:", p.page_size.get(), 40), new Object[0]);
            pw.printf(PrintHelper.generateItem("cache-size:", p.cache_size.get(), 40), new Object[0]);
            pw.printf(PrintHelper.generateItem("optimization:", p.optimization.get(), 40), new Object[0]);
            pw.printf(PrintHelper.generateItem("timers:", "off", 40), new Object[0]);
            pw.printf(PrintHelper.generateSection("Experimental", 40), new Object[0]);
            pw.printf(PrintHelper.generateItem("merge:", p.merge.get(), 40), new Object[0]);
            pw.flush();
            return sw.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String doStats(String statToPrint) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            if (this.epmem.getDatabase() == null) {
                try {
                    this.epmem.epmem_init_db();
                }
                catch (SoarException e) {
                    this.agent.getPrinter().startNewLine().print(e.getMessage());
                    return "";
                }
            }
            DefaultEpisodicMemoryStats stats = this.epmem.stats;
            if (statToPrint == null) {
                pw.printf(PrintHelper.generateHeader("Episodic Memory Statistics", 40), new Object[0]);
                pw.printf(PrintHelper.generateItem("Time:", stats.time.get(), 40), new Object[0]);
                try {
                    String database = this.epmem.getDatabase().getConnection().getMetaData().getDatabaseProductName();
                    String version = this.epmem.getDatabase().getConnection().getMetaData().getDatabaseProductVersion();
                    pw.printf(PrintHelper.generateItem(database + " Version:", version, 40), new Object[0]);
                }
                catch (SQLException e) {
                    this.agent.getPrinter().startNewLine().print(e.getMessage());
                    return "";
                }
                Statement s = null;
                long pageCount = 0L;
                long pageSize = 0L;
                try {
                    s = this.epmem.getDatabase().getConnection().createStatement();
                    try (ResultSet rs = null;){
                        rs = s.executeQuery("PRAGMA page_count");
                        pageCount = rs.getLong(1);
                    }
                    try {
                        rs = s.executeQuery("PRAGMA page_size");
                        pageSize = rs.getLong(1);
                    }
                    finally {
                        rs.close();
                    }
                }
                catch (SQLException e) {
                    this.agent.getPrinter().startNewLine().print(e.getMessage());
                    String string = "";
                    return string;
                }
                finally {
                    try {
                        s.close();
                    }
                    catch (SQLException e) {
                        this.agent.getPrinter().startNewLine().print(e.getMessage());
                        return "";
                    }
                }
                stats.mem_usage.set(pageCount * pageSize);
                pw.printf(PrintHelper.generateItem("Memory Usage:", new Double(stats.mem_usage.get().longValue()) / 1024.0 + " KB", 40), new Object[0]);
                pw.printf(PrintHelper.generateItem("Memory Highwater:", stats.mem_high.get(), 40), new Object[0]);
                pw.printf(PrintHelper.generateItem("Retrievals:", stats.ncbr.get(), 40), new Object[0]);
                pw.printf(PrintHelper.generateItem("Queries:", stats.cbr.get(), 40), new Object[0]);
                pw.printf(PrintHelper.generateItem("Nexts:", stats.nexts.get(), 40), new Object[0]);
                pw.printf(PrintHelper.generateItem("Prevs:", stats.prevs.get(), 40), new Object[0]);
                pw.printf(PrintHelper.generateItem("Last Retrieval WMEs:", stats.ncb_wmes.get(), 40), new Object[0]);
                pw.printf(PrintHelper.generateItem("Last Query Positive:", stats.qry_pos.get(), 40), new Object[0]);
                pw.printf(PrintHelper.generateItem("Last Query Negative:", stats.qry_neg.get(), 40), new Object[0]);
                pw.printf(PrintHelper.generateItem("Last Query Retrieved:", stats.qry_ret.get(), 40), new Object[0]);
                pw.printf(PrintHelper.generateItem("Last Query Cardinality:", stats.qry_card.get(), 40), new Object[0]);
                pw.printf(PrintHelper.generateItem("Last Query Literals:", stats.qry_lits.get(), 40), new Object[0]);
                pw.printf(PrintHelper.generateItem("Graph Match Attempts:", stats.graph_matches.get(), 40), new Object[0]);
                pw.printf(PrintHelper.generateItem("Last Graph Match Attempts:", stats.last_graph_matches.get(), 40), new Object[0]);
                pw.printf(PrintHelper.generateItem("Episodes Considered:", stats.considered.get(), 40), new Object[0]);
                pw.printf(PrintHelper.generateItem("Last Episodes Considered:", stats.last_considered.get(), 40), new Object[0]);
            } else {
                PropertyKey<?> key = DefaultEpisodicMemoryStats.getProperty(this.epmem.getParams().getProperties(), statToPrint);
                if (key == null) {
                    this.agent.getPrinter().startNewLine().print("Unknown stat '" + statToPrint + "'");
                    return "";
                }
                pw.printf("%s%n", this.epmem.getParams().getProperties().get(key).toString());
            }
            pw.flush();
            return sw.toString();
        }

        private String doPrintEpisode(String episodeNum) {
            long episodeID;
            try {
                episodeID = Integer.parseInt(episodeNum);
            }
            catch (NumberFormatException e) {
                throw new CommandLine.ParameterException(this.spec.commandLine(), "Parameter provided is not an integer", (Throwable)e);
            }
            return this.epmem.epmem_print_episode(episodeID);
        }

        private String doReinit() {
            this.epmem.epmem_reinit();
            return "EpMem| Episodic memory system re-initialized.";
        }

        private String doBackup(String[] fileName) {
            ByRef<String> err = new ByRef<String>("");
            boolean success = false;
            String dbFile = "";
            for (int i = 0; i < fileName.length; ++i) {
                dbFile = dbFile + fileName[i] + " ";
            }
            dbFile = dbFile.trim();
            try {
                success = this.epmem.epmem_backup_db(dbFile, err);
            }
            catch (SQLException e) {
                throw new CommandLine.ExecutionException(this.spec.commandLine(), e.getMessage(), (Throwable)e);
            }
            if (!success) {
                throw new CommandLine.ExecutionException(this.spec.commandLine(), (String)err.value);
            }
            return "EpMem| Database backed up to " + dbFile;
        }

        private String doAdd(String knowledge) {
            try {
                this.epmem.epmem_parse_and_add(knowledge);
            }
            catch (SoarException e) {
                this.agent.getPrinter().startNewLine().print(e.getMessage());
                return "";
            }
            return "EpMem| Knowledge added to episodic memory.";
        }
    }

    public static class Provider
    implements SoarCommandProvider {
        @Override
        public void registerCommands(SoarCommandInterpreter interp, Adaptable context) {
            interp.addCommand("epmem", new EpmemCommand(context));
        }
    }
}

