/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.events;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jsoar.kernel.memory.Wme;
import org.jsoar.kernel.memory.WmeImpl;
import org.jsoar.util.ListHead;
import org.jsoar.util.ListItem;
import org.jsoar.util.events.SoarEvent;

public class WorkingMemoryChangedEvent
implements SoarEvent {
    private final ListHead<WmeImpl> added;
    private final ListHead<WmeImpl> removed;

    public WorkingMemoryChangedEvent(ListHead<WmeImpl> added, ListHead<WmeImpl> removed) {
        this.added = ListHead.newInstance(added);
        this.removed = ListHead.newInstance(removed);
    }

    public Iterator<Wme> getAddedWmes() {
        return new WmeIterator(this.added.first);
    }

    public Iterator<Wme> getRemovedWmes() {
        return new WmeIterator(this.removed.first);
    }

    private static class WmeIterator
    implements Iterator<Wme> {
        private ListItem<WmeImpl> next;

        WmeIterator(ListItem<WmeImpl> next) {
            this.next = next;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Wme next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            Wme temp = (Wme)this.next.item;
            this.next = this.next.next;
            return temp;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

