/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.io.beans;

import com.google.common.collect.Iterators;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.jsoar.kernel.io.beans.SoarBeanException;
import org.jsoar.kernel.memory.Wme;
import org.jsoar.kernel.symbols.DoubleSymbol;
import org.jsoar.kernel.symbols.Identifier;
import org.jsoar.kernel.symbols.IntegerSymbol;
import org.jsoar.kernel.symbols.JavaSymbol;
import org.jsoar.kernel.symbols.StringSymbol;
import org.jsoar.kernel.symbols.Symbol;
import org.jsoar.kernel.symbols.Symbols;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoarBeanReader {
    private static final Logger logger = LoggerFactory.getLogger(SoarBeanReader.class);
    private final BeanUtilsBean util = new BeanUtilsBean();
    private final Map<Identifier, Object> beanMap = new HashMap<Identifier, Object>();
    private Identifier debugId = null;
    private Class<?> debugSoarBeanClass = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T read(Identifier id, Class<T> klass) throws SoarBeanException {
        this.debugSoarBeanClass = klass;
        this.debugId = id;
        try {
            T t = this.readInternal(id, klass);
            return t;
        }
        finally {
            this.beanMap.clear();
        }
    }

    private <T> T readInternal(Identifier id, Class<T> klass) throws SoarBeanException {
        Object cached = this.beanMap.get(id);
        if (cached != null) {
            return klass.cast(cached);
        }
        try {
            T bean = klass.newInstance();
            this.beanMap.put(id, bean);
            Iterator<Wme> it = id.getWmes();
            while (it.hasNext()) {
                Wme wme = it.next();
                String name = this.getPropertyName(wme);
                this.setProperty(bean, name, wme.getValue());
            }
            return bean;
        }
        catch (InstantiationException e) {
            throw this.makeException(e, this.debugSoarBeanClass, this.debugId);
        }
        catch (IllegalAccessException e) {
            throw this.makeException(e, this.debugSoarBeanClass, this.debugId);
        }
        catch (InvocationTargetException e) {
            throw this.makeException(e, this.debugSoarBeanClass, this.debugId);
        }
        catch (NoSuchMethodException e) {
            throw this.makeException(e, this.debugSoarBeanClass, this.debugId);
        }
        catch (SecurityException e) {
            throw this.makeException(e, this.debugSoarBeanClass, this.debugId);
        }
        catch (IllegalArgumentException e) {
            throw this.makeException(e, this.debugSoarBeanClass, this.debugId);
        }
    }

    private <T> SoarBeanException makeException(Exception cause, Class<?> klass, Identifier id) {
        return new SoarBeanException(cause.getMessage(), (Throwable)cause, klass, id);
    }

    private String getPropertyName(Wme wme) {
        String name = wme.getAttribute().toString();
        int hyphen = name.indexOf(45);
        int star = name.indexOf(42);
        if (hyphen == -1 && star == -1) {
            return name;
        }
        StringBuilder result = new StringBuilder();
        boolean skipped = false;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == '-' || c == '*') {
                skipped = true;
                continue;
            }
            if (skipped) {
                result.append(result.length() != 0 ? Character.toUpperCase(c) : c);
                skipped = false;
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    private <T> void setProperty(T bean, String name, Symbol value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, SoarBeanException, SecurityException, IllegalArgumentException {
        PropertyDescriptor desc = this.util.getPropertyUtils().getPropertyDescriptor(bean, name);
        if (desc == null) {
            this.setField(bean, name, value);
            return;
        }
        Method writer = desc.getWriteMethod();
        if (writer == null) {
            this.setField(bean, name, value);
            return;
        }
        Class<?> type = this.getTargetType(desc.getPropertyType());
        Object convertedValue = this.convert(value, type);
        writer.invoke(bean, convertedValue);
    }

    private <T> void setField(T bean, String name, Symbol value) throws SecurityException, SoarBeanException, IllegalArgumentException, IllegalAccessException {
        Class<?> beanClass = bean.getClass();
        try {
            Field field = beanClass.getField(name);
            int modifiers = field.getModifiers();
            if (Modifier.isStatic(modifiers)) {
                logger.warn("SoarBean field " + beanClass.getCanonicalName() + "." + name + " is static. Ignoring.");
                return;
            }
            if (Modifier.isPrivate(modifiers)) {
                logger.warn("SoarBean field " + beanClass.getCanonicalName() + "." + name + " is private. Ignoring.");
                return;
            }
            Class<?> type = this.getTargetType(field.getType());
            Object convertedValue = this.convert(value, type);
            field.set(bean, convertedValue);
        }
        catch (NoSuchFieldException e) {
            logger.warn("Unknown property " + beanClass.getCanonicalName() + "." + name + ". Ignoring.");
            return;
        }
    }

    private Class<?> getTargetType(Class<?> tempType) {
        return tempType;
    }

    private <T> T trySymbolConversion(Symbol initialValue, T convertedValue, Class<T> symbolType) throws SoarBeanException {
        if (convertedValue == null) {
            throw new SoarBeanException("Can't convert '" + initialValue + "' to " + symbolType.getCanonicalName(), this.debugSoarBeanClass, this.debugId);
        }
        return convertedValue;
    }

    private Object convert(Symbol value, Class<?> targetType) throws SoarBeanException {
        if (targetType.isAssignableFrom(Symbol.class)) {
            return value;
        }
        if (targetType.isAssignableFrom(Identifier.class)) {
            return this.trySymbolConversion(value, value.asIdentifier(), Identifier.class);
        }
        if (targetType.isAssignableFrom(StringSymbol.class)) {
            return this.trySymbolConversion(value, value.asString(), StringSymbol.class);
        }
        if (targetType.isAssignableFrom(DoubleSymbol.class)) {
            return this.trySymbolConversion(value, value.asDouble(), DoubleSymbol.class);
        }
        if (targetType.isAssignableFrom(IntegerSymbol.class)) {
            return this.trySymbolConversion(value, value.asInteger(), IntegerSymbol.class);
        }
        if (targetType.isAssignableFrom(JavaSymbol.class)) {
            JavaSymbol s = value.asJava();
            if (s == null) {
                throw new SoarBeanException("Can't convert '" + value + "' to JavaSymbol", this.debugSoarBeanClass, this.debugId);
            }
            return this.util.getConvertUtils().convert(s.getValue(), targetType);
        }
        if (value instanceof Identifier) {
            Identifier id = (Identifier)value;
            if (!targetType.isArray()) {
                return this.readInternal(id, targetType);
            }
            return this.convertArray(id, targetType);
        }
        return this.util.getConvertUtils().convert(Symbols.valueOf(value), targetType);
    }

    private Object convertArray(Identifier id, Class<?> arrayType) throws SoarBeanException {
        Class<?> targetType = arrayType.getComponentType();
        int count = Iterators.size(id.getWmes());
        Object array = Array.newInstance(targetType, count);
        int i = 0;
        Iterator<Wme> it = id.getWmes();
        while (it.hasNext()) {
            Wme kid = it.next();
            Object value = this.convert(kid.getValue(), targetType);
            Array.set(array, i, value);
            ++i;
        }
        return array;
    }
}

