/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.io.json;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jsoar.kernel.io.InputOutput;
import org.jsoar.kernel.io.InputWme;
import org.jsoar.kernel.io.InputWmes;
import org.jsoar.kernel.memory.Wme;
import org.jsoar.kernel.symbols.Identifier;
import org.jsoar.kernel.symbols.StringSymbol;
import org.jsoar.kernel.symbols.Symbol;
import org.jsoar.kernel.symbols.Symbols;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonWmeUtils {
    private static Logger logger = LoggerFactory.getLogger(JsonWmeUtils.class);
    private static final String JSON_ARRAY = "json-array-attributes";

    private JsonWmeUtils() {
    }

    public static void addWmes(InputOutput io, Object attr, Object obj) {
        if (obj instanceof JSONObject) {
            JsonWmeUtils.addObjectWmes(io, attr, (JSONObject)obj);
        } else if (obj instanceof JSONArray) {
            JsonWmeUtils.addArrayWmes(io, attr, (JSONArray)obj);
        } else if (obj instanceof Boolean) {
            InputWmes.add(io, attr, (Object)Boolean.toString((Boolean)obj));
        } else {
            InputWmes.add(io, attr, obj);
        }
    }

    public static void addWmes(InputOutput io, Identifier id, Object attr, Object obj) {
        if (obj instanceof JSONObject) {
            JsonWmeUtils.addObjectWmes(io, id, attr, (JSONObject)obj);
        } else if (obj instanceof JSONArray) {
            JsonWmeUtils.addArrayWmes(io, id, attr, (JSONArray)obj);
        } else if (obj instanceof Boolean) {
            InputWmes.add(io, id, attr, Boolean.toString((Boolean)obj));
        } else {
            InputWmes.add(io, id, attr, obj);
        }
    }

    public static void addWmes(InputWme root, Object attr, Object obj) {
        if (obj instanceof JSONObject) {
            JsonWmeUtils.addObjectWmes(root, attr, (JSONObject)obj);
        } else if (obj instanceof JSONArray) {
            JsonWmeUtils.addArrayWmes(root, attr, (JSONArray)obj);
        } else if (obj instanceof Boolean) {
            InputWmes.add(root, attr, (Object)Boolean.toString((Boolean)obj));
        } else {
            InputWmes.add(root, attr, obj);
        }
    }

    public static void addObjectWmes(InputOutput io, Object attr, JSONObject jsonObj) {
        InputWme wme = InputWmes.add(io, attr, Symbols.NEW_ID);
        for (Map.Entry entry : jsonObj.entrySet()) {
            JsonWmeUtils.addWmes(wme, (Object)entry.getKey().toString(), entry.getValue());
        }
    }

    public static void addObjectWmes(InputOutput io, Identifier id, Object attr, JSONObject jsonObj) {
        InputWme wme = InputWmes.add(io, id, attr, Symbols.NEW_ID);
        for (Map.Entry entry : jsonObj.entrySet()) {
            JsonWmeUtils.addWmes(wme, (Object)entry.getKey().toString(), entry.getValue());
        }
    }

    public static void addObjectWmes(InputWme root, Object attr, JSONObject jsonObj) {
        InputWme wme = InputWmes.add(root, attr, Symbols.NEW_ID);
        JsonWmeUtils.addObjectWmes(wme, jsonObj);
    }

    public static void addObjectWmes(InputWme root, JSONObject jsonObj) {
        for (Map.Entry entry : jsonObj.entrySet()) {
            JsonWmeUtils.addWmes(root, (Object)entry.getKey().toString(), entry.getValue());
        }
    }

    public static void addArrayWmes(InputOutput io, Object attr, JSONArray jsonArray) {
        for (Object obj : jsonArray) {
            JsonWmeUtils.addWmes(io, attr, obj);
        }
    }

    public static void addArrayWmes(InputOutput io, Identifier id, Object attr, JSONArray jsonArray) {
        for (Object obj : jsonArray) {
            JsonWmeUtils.addWmes(io, id, attr, obj);
        }
    }

    public static void addArrayWmes(InputWme root, Object attr, JSONArray jsonArray) {
        for (Object obj : jsonArray) {
            JsonWmeUtils.addWmes(root, attr, obj);
        }
    }

    public static Object parse(Symbol symbol) {
        return JsonWmeUtils.parse(symbol, (Boolean)false);
    }

    public static Object parse(Symbol symbol, Boolean autoCreateJsonArray) {
        if (symbol.asIdentifier() != null) {
            return JsonWmeUtils.parse(symbol.asIdentifier(), autoCreateJsonArray);
        }
        if (symbol.asDouble() != null) {
            return symbol.asDouble().getValue();
        }
        if (symbol.asInteger() != null) {
            return symbol.asInteger().getValue();
        }
        return symbol.toString();
    }

    public static JSONObject parse(Identifier root) {
        return JsonWmeUtils.parse(root, (Boolean)false);
    }

    public static JSONObject parse(Identifier root, Boolean autoCreateJSONArray) {
        JSONObject jsonObj = new JSONObject();
        HashMap arrayAttrs = Maps.newHashMap();
        for (String attr : JsonWmeUtils.getJsonArrayAttributes(root)) {
            JSONArray array = new JSONArray();
            jsonObj.put((Object)attr, (Object)array);
            arrayAttrs.put(attr, array);
        }
        Iterator<Wme> wmes = root.getWmes();
        while (wmes.hasNext()) {
            Wme wme = wmes.next();
            String attr = wme.getAttribute().toString();
            if (attr.equals(JSON_ARRAY)) continue;
            Object jsonValue = JsonWmeUtils.parse(wme.getValue(), autoCreateJSONArray);
            JSONArray array = (JSONArray)arrayAttrs.get(attr);
            if (array != null) {
                array.add(jsonValue);
                continue;
            }
            if (jsonObj.containsKey((Object)attr)) {
                if (autoCreateJSONArray.booleanValue()) {
                    if (!(jsonObj.get((Object)attr) instanceof JSONArray)) {
                        Object oldObject = jsonObj.get((Object)attr);
                        JSONArray newJsonArray = new JSONArray();
                        newJsonArray.add(oldObject);
                        newJsonArray.add(jsonValue);
                        jsonObj.put((Object)attr, (Object)newJsonArray);
                        continue;
                    }
                    ((JSONArray)jsonObj.get((Object)attr)).add(jsonValue);
                    continue;
                }
                logger.error("Parsing identifier {} - Replacing value for key {} ({} -> {}). To make an array instead add a ^{} {} WME to the identifier.", new Object[]{root, attr, jsonObj.get((Object)attr), jsonValue, JSON_ARRAY, attr});
                jsonObj.put((Object)attr, jsonValue);
                continue;
            }
            jsonObj.put((Object)attr, jsonValue);
        }
        return jsonObj;
    }

    private static Set<String> getJsonArrayAttributes(Identifier id) {
        HashSet<String> attrs = new HashSet<String>();
        Iterator<Wme> wmes = id.getWmes();
        while (wmes.hasNext()) {
            Wme wme = wmes.next();
            StringSymbol attr = wme.getAttribute().asString();
            StringSymbol value = wme.getValue().asString();
            if (attr == null || !attr.getValue().equals(JSON_ARRAY) || value == null) continue;
            attrs.add(value.getValue());
        }
        return attrs;
    }
}

