/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.io.quick;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jsoar.kernel.io.quick.MemoryNode;
import org.jsoar.kernel.io.quick.QMemory;
import org.jsoar.kernel.io.quick.QMemoryListener;
import org.jsoar.kernel.io.quick.SubQMemory;
import org.jsoar.kernel.memory.Wme;
import org.jsoar.kernel.symbols.Identifier;
import org.jsoar.util.Arguments;

public class DefaultQMemory
implements QMemory {
    static final int MAX_DEPTH = 20;
    private Map<String, MemoryNode> memory = new HashMap<String, MemoryNode>();
    private List<QMemoryListener> listeners = new CopyOnWriteArrayList<QMemoryListener>();

    public static QMemory create() {
        return new DefaultQMemory();
    }

    public static QMemory create(Identifier id) {
        return DefaultQMemory.create(id, "", new DefaultQMemory(), 0);
    }

    private static QMemory create(Identifier id, String path, DefaultQMemory struct, int depth) {
        Arguments.checkNotNull(id, "id");
        if (depth > 20) {
            return struct;
        }
        Iterator<Wme> it = id.getWmes();
        while (it.hasNext()) {
            Wme e = it.next();
            String childPath = e.getAttribute().toString();
            if (path != null && path.length() > 0) {
                childPath = path + "." + childPath;
            }
            if (struct.hasPath(childPath)) {
                int ix = 0;
                while (struct.hasPath(childPath + "[" + ix + "]")) {
                    ++ix;
                }
                childPath = childPath + "[" + ix + "]";
            }
            MemoryNode childNode = MemoryNode.create(e.getValue());
            struct.setNode(childPath, childNode);
            if (childNode.isLeaf()) continue;
            Identifier childId = e.getValue().asIdentifier();
            assert (childId != null);
            DefaultQMemory.create(childId, childPath, struct, depth + 1);
        }
        return struct;
    }

    private DefaultQMemory() {
    }

    @Override
    public synchronized boolean hasPath(String path) {
        return this.memory.containsKey(path);
    }

    @Override
    public synchronized double getDouble(String path) {
        MemoryNode node = this.memory.get(path);
        return node != null ? node.getDoubleValue() : 0.0;
    }

    @Override
    public synchronized long getInteger(String path) {
        MemoryNode node = this.memory.get(path);
        return node != null ? node.getIntValue() : 0L;
    }

    @Override
    public synchronized String getString(String path) {
        MemoryNode node = this.memory.get(path);
        return node != null ? node.getStringValue() : "";
    }

    @Override
    public synchronized Set<String> getPaths() {
        return new HashSet<String>(this.memory.keySet());
    }

    synchronized Set<String> getPaths(String prefix, boolean strip) {
        HashSet<String> paths = new HashSet<String>();
        for (String path : this.memory.keySet()) {
            if (!path.startsWith(prefix)) continue;
            if (strip) {
                paths.add(path.substring(prefix.length()));
                continue;
            }
            paths.add(path);
        }
        return paths;
    }

    @Override
    public QMemory subMemory(String prefix) {
        return new SubQMemory(this, prefix);
    }

    @Override
    public synchronized void setDouble(String path, double doubleVal) {
        if (this.getNode(path).setDoubleValue(doubleVal)) {
            this.fireChangeEvent();
        }
    }

    @Override
    public synchronized void setInteger(String path, int intVal) {
        this.setInteger(path, (long)intVal);
    }

    @Override
    public synchronized void setInteger(String path, long longVal) {
        if (this.getNode(path).setIntValue(longVal)) {
            this.fireChangeEvent();
        }
    }

    @Override
    public synchronized void setString(String path, String strVal) {
        if (this.getNode(path).setStringValue(strVal)) {
            this.fireChangeEvent();
        }
    }

    @Override
    public synchronized void clear(String path) {
        this.getNode(path).clearValue();
        this.fireChangeEvent();
    }

    @Override
    public synchronized void remove(String path) {
        this.removeNode(path);
        this.fireChangeEvent();
    }

    @Override
    public void addListener(QMemoryListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(QMemoryListener listener) {
        this.listeners.remove(listener);
    }

    private void fireChangeEvent() {
        for (QMemoryListener listener : this.listeners) {
            listener.onQMemoryChanged();
        }
    }

    private void setNode(String path, MemoryNode node) {
        this.memory.put(path, node);
    }

    MemoryNode getNode(String path) {
        MemoryNode node = this.memory.get(path);
        if (node == null) {
            node = new MemoryNode();
            this.memory.put(path, node);
        }
        return node;
    }

    private void removeNode(String path) {
        this.memory.remove(path);
        Iterator<String> it = this.memory.keySet().iterator();
        while (it.hasNext()) {
            String fullPath = it.next();
            if (!fullPath.startsWith(path) || fullPath.length() != path.length() && (fullPath.length() <= path.length() || fullPath.charAt(path.length()) != '.')) continue;
            it.remove();
        }
    }
}

