/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.io.quick;

import org.jsoar.kernel.symbols.DoubleSymbol;
import org.jsoar.kernel.symbols.IntegerSymbol;
import org.jsoar.kernel.symbols.StringSymbol;
import org.jsoar.kernel.symbols.Symbol;

class MemoryNode {
    private Object value;

    MemoryNode() {
    }

    static MemoryNode create(Symbol value) {
        if (value == null) {
            return null;
        }
        MemoryNode node = new MemoryNode();
        IntegerSymbol ie = value.asInteger();
        if (ie != null) {
            node.setIntValue(ie.getValue());
            return node;
        }
        DoubleSymbol fe = value.asDouble();
        if (fe != null) {
            node.setDoubleValue(fe.getValue());
            return node;
        }
        StringSymbol se = value.asString();
        if (se != null) {
            node.setStringValue(se.getValue());
            return node;
        }
        node.clearValue();
        return node;
    }

    public boolean isString() {
        return this.value instanceof String;
    }

    public boolean isInt() {
        return this.value instanceof Long;
    }

    public boolean isDouble() {
        return this.value instanceof Double;
    }

    public boolean isNumeric() {
        return this.isInt() || this.isDouble();
    }

    public boolean isLeaf() {
        return this.value != null;
    }

    public boolean setStringValue(String strVal) {
        assert (strVal != null);
        boolean changed = !strVal.equals(this.value);
        this.value = strVal;
        return changed;
    }

    public boolean setIntValue(long intVal) {
        boolean changed = !this.isInt() || intVal != this.getIntValue();
        this.value = intVal;
        return changed;
    }

    public boolean setDoubleValue(double doubleVal) {
        boolean changed = !this.isDouble() || doubleVal != this.getDoubleValue();
        this.value = doubleVal;
        return changed;
    }

    public String getStringValue() {
        return this.value != null ? this.value.toString() : "";
    }

    public Object getValue() {
        return this.value;
    }

    public boolean setValue(MemoryNode other) {
        boolean changed = other != this.value;
        this.value = other.value;
        return changed;
    }

    public long getIntValue() {
        if (this.value instanceof Number) {
            return ((Number)this.value).longValue();
        }
        if (this.value != null) {
            return Long.parseLong(this.value.toString());
        }
        return 0L;
    }

    public double getDoubleValue() {
        if (this.value instanceof Number) {
            return ((Number)this.value).doubleValue();
        }
        if (this.value != null) {
            return Double.parseDouble(this.value.toString());
        }
        return 0.0;
    }

    public void clearValue() {
        this.value = null;
    }

    public boolean hasSameType(MemoryNode node) {
        if (this.value == null && node.value != null || this.value != null && node.value == null) {
            return false;
        }
        return this.value == null && node.value == null || this.value.getClass().equals(node.value.getClass());
    }

    public boolean valueIsEqual(MemoryNode other) {
        if (this.value != null) {
            return this.value.equals(other.value);
        }
        return this.value == other.value;
    }

    public String valueToString() {
        if (this.value == null) {
            return "[NODE]";
        }
        return this.value.toString();
    }

    public String toString() {
        return super.toString() + this.valueToString();
    }
}

