/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.io.quick;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Pattern;
import org.jsoar.kernel.Agent;
import org.jsoar.kernel.events.AfterInitSoarEvent;
import org.jsoar.kernel.events.InputEvent;
import org.jsoar.kernel.io.InputOutput;
import org.jsoar.kernel.io.quick.DefaultQMemory;
import org.jsoar.kernel.io.quick.MemoryNode;
import org.jsoar.kernel.io.quick.QMemory;
import org.jsoar.kernel.io.quick.QMemoryListener;
import org.jsoar.kernel.io.quick.SoarMemoryNode;
import org.jsoar.kernel.symbols.Identifier;
import org.jsoar.kernel.symbols.Symbol;
import org.jsoar.util.Arguments;
import org.jsoar.util.events.SoarEvent;
import org.jsoar.util.events.SoarEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoarQMemoryAdapter
implements SoarEventListener,
QMemoryListener {
    private static final Logger logger = LoggerFactory.getLogger(SoarQMemoryAdapter.class);
    private static final Pattern INDEX_PATTERN = Pattern.compile("\\[[^]]+\\]$");
    private static final Comparator<String> increasingLengthComparator = new Comparator<String>(){

        @Override
        public int compare(String s1, String s2) {
            return s1.length() - s2.length();
        }
    };
    private static final Comparator<String> decreasingLengthComparator = new Comparator<String>(){

        @Override
        public int compare(String s1, String s2) {
            return s2.length() - s1.length();
        }
    };
    private final String lock = new String(this.getClass().getName() + " lock");
    private QMemory source;
    private boolean sourceChanged = false;
    private InputOutput io;
    private Identifier rootId;
    private SoarMemoryNode rootNode;
    private Map<String, SoarMemoryNode> memory = new HashMap<String, SoarMemoryNode>();

    static String getNameFromPath(String path) {
        String[] pathElements = path.split("\\.");
        return INDEX_PATTERN.matcher(pathElements[pathElements.length - 1]).replaceFirst("");
    }

    private static String getParentPath(String path) {
        int ix = path.lastIndexOf(46);
        return ix < 0 ? "" : path.substring(0, ix);
    }

    public static SoarQMemoryAdapter attach(Agent agent, QMemory source) {
        Arguments.checkNotNull(agent, "agent");
        return SoarQMemoryAdapter.attach(agent.getInputOutput(), null, source);
    }

    public static SoarQMemoryAdapter attach(InputOutput io, Identifier rootId, QMemory source) {
        SoarQMemoryAdapter adapter = new SoarQMemoryAdapter();
        adapter.setSource(source);
        adapter.initialize(io, rootId);
        return adapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(InputOutput io, Identifier rootId) {
        String string = this.lock;
        synchronized (string) {
            Arguments.checkNotNull(io, "io");
            if (this.io != null) {
                throw new IllegalStateException("already initialized");
            }
            this.io = io;
            this.io.getEvents().addListener(InputEvent.class, this);
            this.io.getEvents().addListener(AfterInitSoarEvent.class, this);
            if (rootId != null) {
                this.rootId = rootId;
                this.rootNode = new SoarMemoryNode(rootId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detach() {
        String string = this.lock;
        synchronized (string) {
            if (this.io != null) {
                this.io.getEvents().removeListener(null, this);
                SoarQMemoryAdapter.removeAllWmes(this.io, this.memory);
            }
            this.io = null;
            this.memory = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QMemory getSource() {
        String string = this.lock;
        synchronized (string) {
            return this.source;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSource(QMemory source) {
        String string = this.lock;
        synchronized (string) {
            if (this.source != null) {
                this.source.removeListener(this);
            }
            this.sourceChanged |= this.source != source;
            this.source = source;
            if (this.source != null) {
                this.source.addListener(this);
            }
            if (this.sourceChanged && this.io != null) {
                this.io.asynchronousInputReady();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Symbol getValue(String path) {
        String string = this.lock;
        synchronized (string) {
            SoarMemoryNode node = this.memory.get(path);
            return node != null ? node.getValue() : null;
        }
    }

    private void synchronize() {
        if (this.sourceChanged) {
            SoarQMemoryAdapter.removeAllWmes(this.io, this.memory);
            this.sourceChanged = false;
        }
        if (this.source == null) {
            return;
        }
        if (this.rootNode == null) {
            this.rootNode = new SoarMemoryNode(this.io.getInputLink());
        }
        HashSet<String> oldPaths = new HashSet<String>(this.memory.keySet());
        HashSet<String> newPaths = new HashSet<String>();
        HashSet<String> newInternalPaths = new HashSet<String>();
        for (String string : this.source.getPaths()) {
            String[] pathElements = string.split("\\.");
            String tmp = "";
            for (int ix = 0; ix < pathElements.length; ++ix) {
                if (ix > 0) {
                    tmp = tmp + ".";
                }
                tmp = tmp + pathElements[ix];
                newPaths.add(tmp);
                oldPaths.remove(tmp);
                if (ix >= pathElements.length - 1) continue;
                newInternalPaths.add(tmp);
            }
        }
        ArrayList<String> oldPathsByLength = new ArrayList<String>(oldPaths);
        Collections.sort(oldPathsByLength, decreasingLengthComparator);
        for (String path : oldPathsByLength) {
            SoarMemoryNode oldNode = this.memory.remove(path);
            oldNode.remove(this.io);
        }
        ArrayList arrayList = new ArrayList(newPaths);
        Collections.sort(arrayList, increasingLengthComparator);
        for (String path : arrayList) {
            MemoryNode newNode;
            SoarMemoryNode oldNode = this.memory.get(path);
            SoarMemoryNode parentNode = this.memory.get(SoarQMemoryAdapter.getParentPath(path));
            if (parentNode == null) {
                parentNode = this.rootNode;
            }
            String name = SoarQMemoryAdapter.getNameFromPath(path);
            if (!newInternalPaths.contains(path)) {
                newNode = ((DefaultQMemory)this.source).getNode(path);
            } else {
                newNode = new MemoryNode();
                newNode.clearValue();
            }
            if (oldNode == null) {
                oldNode = new SoarMemoryNode(name);
                this.memory.put(path, oldNode);
            }
            oldNode.setParentNode(parentNode);
            oldNode.synchronizeToMemoryNode(this.io, newNode);
        }
    }

    private static void removeAllWmes(InputOutput io, Map<String, SoarMemoryNode> memory) {
        for (SoarMemoryNode node : memory.values()) {
            node.getWME().remove();
        }
        memory.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onEvent(SoarEvent event) {
        String string = this.lock;
        synchronized (string) {
            if (event instanceof InputEvent) {
                QMemory qMemory = this.source;
                synchronized (qMemory) {
                    this.synchronize();
                }
            } else if (event instanceof AfterInitSoarEvent) {
                this.resetAfterInitSoar();
            }
        }
    }

    @Override
    public void onQMemoryChanged() {
        this.io.asynchronousInputReady();
    }

    private void resetAfterInitSoar() {
        logger.info("Repopulating after init-soar");
        this.memory.clear();
        this.sourceChanged = true;
        if (this.rootId != null) {
            Identifier oldRootId = this.rootId;
            this.rootId = this.io.getSymbols().findOrCreateIdentifier(oldRootId.getNameLetter(), oldRootId.getNameNumber());
            if (this.rootId == null) {
                this.rootId = this.io.getSymbols().findOrCreateIdentifier(oldRootId.getNameLetter(), oldRootId.getNameNumber());
                logger.warn("After init-soar, could not find custom root identifier " + oldRootId + ". Using " + this.rootId + ".");
            }
            this.rootNode = new SoarMemoryNode(this.rootId);
        } else {
            this.rootNode = null;
        }
    }
}

