/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.io.xml;

import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jsoar.kernel.io.InputOutput;
import org.jsoar.kernel.io.xml.XmlFileToWme;
import org.jsoar.kernel.io.xml.XmlToWme;
import org.jsoar.kernel.memory.WmeBuilder;
import org.jsoar.kernel.memory.WmeFactory;
import org.jsoar.kernel.symbols.Identifier;
import org.jsoar.kernel.symbols.SymbolFactory;
import org.jsoar.kernel.symbols.Symbols;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

abstract class AbstractXmlFileToWme
implements XmlFileToWme,
XmlToWme {
    private WmeBuilder<?> builder = null;
    private WmeFactory<?> factory = null;

    public AbstractXmlFileToWme(InputOutput io) {
        this.factory = io.asWmeFactory();
    }

    public AbstractXmlFileToWme(WmeFactory<?> wmeFactory) {
        this.factory = wmeFactory;
    }

    @Override
    public void xmlToWme(File file, InputOutput io) {
        Element root = AbstractXmlFileToWme.getRootElement(file);
        Identifier ret = this.fromXml(root);
        SymbolFactory sf = io.getSymbols();
        io.addInputWme(io.getInputLink(), Symbols.create(sf, root.getNodeName()), ret);
    }

    @Override
    public Identifier fromXml(Element element) {
        this.builder = WmeBuilder.create(this.factory, element.getNodeName());
        this.addAttributes(element.getAttributes(), this.builder);
        this.getXmlTree(element.getChildNodes(), this.builder);
        return this.builder.topId();
    }

    abstract void getXmlTree(NodeList var1, WmeBuilder<?> var2);

    abstract void addAttributes(NamedNodeMap var1, WmeBuilder<?> var2);

    protected static Element getRootElement(File f) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document dom = db.parse(f);
            return dom.getDocumentElement();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

