/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.io.xml;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import org.jsoar.kernel.io.xml.DefaultXmlToWme;
import org.jsoar.kernel.memory.Wme;
import org.jsoar.kernel.symbols.Identifier;
import org.jsoar.util.XmlTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class DefaultWmeToXml {
    public static final String ATTRS = "/attrs";
    public static final String TEXT = "/text";
    public static final String NEXT = "/next";
    private static final Logger logger = LoggerFactory.getLogger(DefaultXmlToWme.class);
    private static final DocumentBuilder builder = XmlTools.createDocumentBuilder();
    private final Map<Identifier, Element> idMap = new HashMap<Identifier, Element>();

    public Document toXml(Identifier root, String rootName) {
        Document doc = builder.getDOMImplementation().createDocument(null, rootName, null);
        this.toXml(root, doc.getDocumentElement());
        return doc;
    }

    private void processAttrs(Wme attrWme, Element element) {
        Identifier idValue = attrWme.getValue().asIdentifier();
        if (idValue != null) {
            Iterator<Wme> it = idValue.getWmes();
            while (it.hasNext()) {
                Wme child = it.next();
                String attr = child.getAttribute().toString();
                if (ATTRS.equals(attr)) {
                    this.processAttrs(child, element);
                    continue;
                }
                element.setAttribute(attr, child.getValue().toString());
            }
        } else {
            logger.warn("Don't know what to do with /attrs element with non-id value: " + attrWme);
        }
    }

    private void processText(Wme textWme, Element element) {
        Text text = element.getOwnerDocument().createTextNode(textWme.getValue().toString());
        element.appendChild(text);
    }

    private void processNormalWme(Wme wme, Element element) {
        Document doc = element.getOwnerDocument();
        Element wmeElement = doc.createElement(wme.getAttribute().toString());
        element.appendChild(wmeElement);
        Identifier idValue = wme.getValue().asIdentifier();
        if (idValue != null) {
            Element valueElement = this.idMap.get(idValue);
            if (valueElement != null) {
                logger.warn("Don't know what to do with non-tree memory structure: " + wme);
                wmeElement.setTextContent(idValue.toString());
            } else {
                this.toXml(idValue, wmeElement);
            }
        } else {
            String value = wme.getValue().toString();
            wmeElement.setTextContent(value);
        }
    }

    public Element toXml(Identifier root, Element element) {
        this.idMap.put(root, element);
        Iterator<Wme> it = root.getWmes();
        while (it.hasNext()) {
            Wme wme = it.next();
            String attr = wme.getAttribute().toString();
            if (ATTRS.equals(attr)) {
                this.processAttrs(wme, element);
                continue;
            }
            if (TEXT.equals(attr)) {
                this.processText(wme, element);
                continue;
            }
            if (NEXT.equals(attr)) continue;
            this.processNormalWme(wme, element);
        }
        return element;
    }
}

