/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.io.xml;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.jsoar.kernel.io.InputOutput;
import org.jsoar.kernel.io.xml.AbstractXmlFileToWme;
import org.jsoar.kernel.io.xml.TagAlreadyAddedException;
import org.jsoar.kernel.io.xml.XmlPath;
import org.jsoar.kernel.memory.WmeBuilder;
import org.jsoar.kernel.memory.WmeFactory;
import org.jsoar.kernel.symbols.Identifier;
import org.jsoar.kernel.symbols.SymbolFactory;
import org.jsoar.kernel.symbols.Symbols;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ManualTypeXmlToWme
extends AbstractXmlFileToWme {
    private XmlPath xmlPath = new XmlPath();
    private Set<String> floatTags = new HashSet<String>();
    private Set<String> intTags = new HashSet<String>();

    public ManualTypeXmlToWme(InputOutput io) {
        super(io);
    }

    public ManualTypeXmlToWme(WmeFactory<?> wmeFactory) {
        super(wmeFactory);
    }

    @Override
    public void xmlToWme(File file, InputOutput io) {
        Element root = ManualTypeXmlToWme.getRootElement(file);
        Identifier ret = this.fromXml(root);
        SymbolFactory sf = io.getSymbols();
        io.addInputWme(io.getInputLink(), Symbols.create(sf, root.getNodeName()), ret);
    }

    @Override
    public Identifier fromXml(Element element) {
        this.xmlPath.pushTag(element.getNodeName());
        Identifier ret = super.fromXml(element);
        this.xmlPath.popTag();
        return ret;
    }

    @Override
    protected void getXmlTree(NodeList nodeList, WmeBuilder<?> builder) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node current = nodeList.item(i);
            if (current.getNodeType() != 1) continue;
            this.xmlPath.pushTag(current.getNodeName());
            boolean pushed = false;
            if (current.hasAttributes()) {
                pushed = true;
                builder = builder.push(current.getNodeName());
                this.addAttributes(current.getAttributes(), builder);
            }
            if (current.getChildNodes().getLength() == 1 && current.getFirstChild().getNodeValue() != null) {
                if (pushed) {
                    builder = builder.pop();
                }
                this.addWme(builder, current.getNodeName(), current.getFirstChild().getNodeValue().trim());
            } else if (!current.hasChildNodes() && !current.hasAttributes()) {
                if (pushed) {
                    builder = builder.pop();
                }
                this.addWme(builder, current.getNodeName(), "");
            } else if (current.hasChildNodes() && current.getNodeName() != null) {
                if (!pushed) {
                    builder = builder.push(current.getNodeName());
                }
                this.getXmlTree(current.getChildNodes(), builder);
                builder = builder.pop();
            } else if (pushed) {
                builder = builder.pop();
            }
            this.xmlPath.popTag();
        }
    }

    @Override
    protected void addAttributes(NamedNodeMap nnm, WmeBuilder<?> builder) {
        for (int i = 0; i < nnm.getLength(); ++i) {
            Node n = nnm.item(i);
            this.xmlPath.pushTag(n.getNodeName());
            this.addWme(builder, n.getNodeName(), n.getNodeValue());
            this.xmlPath.popTag();
        }
    }

    public void addFloatTag(String path) throws TagAlreadyAddedException {
        if (!this.intTags.contains(path)) {
            this.floatTags.add(path);
            return;
        }
        throw new TagAlreadyAddedException(path + " already added as integer.");
    }

    public void addIntTag(String path) throws TagAlreadyAddedException {
        if (!this.floatTags.contains(path)) {
            this.intTags.add(path);
            return;
        }
        throw new TagAlreadyAddedException(path + " already added as float.");
    }

    private void addWme(WmeBuilder<?> builder, String attribute, String value) {
        String path = this.xmlPath.toString();
        if (this.floatTags.contains(path)) {
            Double doubleVal = Double.parseDouble(value);
            builder = builder.add(attribute, doubleVal);
        } else if (this.intTags.contains(path)) {
            Long intVal = Long.parseLong(value);
            builder = builder.add(attribute, intVal);
        } else {
            builder = builder.add(attribute, value);
        }
    }
}

