/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.io.xml;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import org.jsoar.kernel.memory.Wme;
import org.jsoar.kernel.symbols.Identifier;
import org.jsoar.kernel.symbols.Symbol;
import org.jsoar.util.XmlTools;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SoarTechWmeToXml {
    public static final String TYPE = "type";
    public static final String VALUE = "value";
    public static final String INTEGER = "integer";
    public static final String DOUBLE = "double";
    public static final String LINK = "link";
    public static final String LINK_ID = "link-id";
    private static final DocumentBuilder builder = XmlTools.createDocumentBuilder();
    private final Map<Identifier, Element> idMap = new HashMap<Identifier, Element>();

    public Document toXml(Identifier root, String rootName) {
        Document doc = builder.getDOMImplementation().createDocument(null, rootName, null);
        this.toXml(root, doc.getDocumentElement());
        return doc;
    }

    public Element toXml(Identifier root, Element element) {
        this.idMap.put(root, element);
        Document doc = element.getOwnerDocument();
        Iterator<Wme> it = root.getWmes();
        while (it.hasNext()) {
            Wme wme = it.next();
            Element wmeElement = doc.createElement(wme.getAttribute().toString());
            element.appendChild(wmeElement);
            Identifier idValue = wme.getValue().asIdentifier();
            if (idValue != null) {
                Element valueElement = this.idMap.get(idValue);
                if (valueElement != null) {
                    wmeElement.setAttribute(LINK, idValue.toString());
                    valueElement.setAttribute(LINK_ID, idValue.toString());
                    continue;
                }
                this.toXml(idValue, wmeElement);
                continue;
            }
            this.writeNonIdValue(wme.getValue(), wmeElement);
        }
        return element;
    }

    private void writeNonIdValue(Symbol value, Element element) {
        if (value.asDouble() != null) {
            element.setAttribute(TYPE, DOUBLE);
        } else if (value.asInteger() != null) {
            element.setAttribute(TYPE, INTEGER);
        }
        element.setTextContent(value.toString());
    }
}

