/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.io.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import org.jsoar.kernel.events.BeforeInitSoarEvent;
import org.jsoar.kernel.events.InputEvent;
import org.jsoar.kernel.io.InputOutput;
import org.jsoar.kernel.io.InputWme;
import org.jsoar.kernel.io.InputWmes;
import org.jsoar.kernel.io.xml.DefaultXmlToWme;
import org.jsoar.kernel.io.xml.XmlToWme;
import org.jsoar.kernel.symbols.Identifier;
import org.jsoar.kernel.symbols.Symbols;
import org.jsoar.util.Arguments;
import org.jsoar.util.events.SoarEvent;
import org.jsoar.util.events.SoarEventListener;
import org.w3c.dom.Element;

public class XmlMessageQueue {
    private final InputOutput io;
    private final XmlToWme converter;
    private final long timeToLive;
    private final String queueName;
    private final Listener listener = new Listener();
    private final ConcurrentLinkedQueue<NewMessage> newMessages = new ConcurrentLinkedQueue();
    private final LinkedList<Entry> entries = new LinkedList();
    private final AtomicReference<InputWme> queueWme = new AtomicReference();

    public static Builder newBuilder(InputOutput io) {
        return new Builder(io);
    }

    private XmlMessageQueue(Builder builder) {
        Arguments.checkNotNull(builder, "builder");
        this.io = builder.io;
        this.converter = builder.converter != null ? builder.converter : DefaultXmlToWme.forInput(this.io);
        this.queueName = builder.queueName;
        this.timeToLive = builder.timeToLive;
        this.io.getEvents().addListener(InputEvent.class, this.listener);
        this.io.getEvents().addListener(BeforeInitSoarEvent.class, this.listener);
    }

    public XmlMessageQueue dispose() {
        this.io.getEvents().removeListener(null, this.listener);
        InputWme wme = this.queueWme.getAndSet(null);
        if (wme != null) {
            wme.remove();
        }
        this.newMessages.clear();
        this.entries.clear();
        return this;
    }

    public XmlMessageQueue add(Element message) {
        this.newMessages.add(new NewMessage(message, message.getTagName()));
        this.io.asynchronousInputReady();
        return this;
    }

    private void update(InputEvent inputEvent) {
        this.removeExpiredMessages();
        this.createQueueWme();
        this.processNewMessages();
    }

    private void processNewMessages() {
        NewMessage nm = this.newMessages.poll();
        while (nm != null) {
            this.addNewMessage(nm);
            nm = this.newMessages.poll();
        }
    }

    private void removeExpiredMessages() {
        Iterator it = this.entries.iterator();
        while (it.hasNext()) {
            Entry entry = (Entry)it.next();
            if (!entry.removeIfExpired()) continue;
            it.remove();
        }
    }

    private void createQueueWme() {
        if (this.queueWme.get() == null) {
            this.queueWme.set(InputWmes.add(this.io, (Object)this.queueName, Symbols.NEW_ID));
        }
    }

    private Entry getLastEntry() {
        return this.entries.isEmpty() ? null : this.entries.getLast();
    }

    private void addNewMessage(NewMessage nm) {
        Identifier queueId = this.queueWme.get().getValue().asIdentifier();
        Identifier messageId = this.converter.fromXml(nm.element);
        InputWme messageWme = InputWmes.add(this.io, queueId, nm.name, messageId);
        Entry lastMessage = this.getLastEntry();
        ArrayList<InputWme> support = new ArrayList<InputWme>();
        if (lastMessage != null) {
            support.add(InputWmes.add(this.io, lastMessage.getId(), "/next", messageId));
            lastMessage.supportWmes.add(InputWmes.add(this.io, messageId, "/previous", lastMessage.getId()));
        }
        this.entries.add(new Entry(messageWme, support, this.timeToLive));
    }

    private void beforeInitSoar(BeforeInitSoarEvent event) {
        this.entries.clear();
        if (!this.newMessages.isEmpty()) {
            this.io.asynchronousInputReady();
        }
    }

    private class Listener
    implements SoarEventListener {
        private Listener() {
        }

        @Override
        public void onEvent(SoarEvent event) {
            if (event instanceof InputEvent) {
                XmlMessageQueue.this.update((InputEvent)event);
            } else if (event instanceof BeforeInitSoarEvent) {
                XmlMessageQueue.this.beforeInitSoar((BeforeInitSoarEvent)event);
            }
        }
    }

    private static class Entry {
        final InputWme wme;
        final List<InputWme> supportWmes;
        long ttl = 50L;

        public Entry(InputWme wme, List<InputWme> supportWmes, long ttl) {
            this.wme = wme;
            this.supportWmes = supportWmes;
            this.ttl = ttl;
        }

        public Identifier getId() {
            return this.wme.getValue().asIdentifier();
        }

        public boolean removeIfExpired() {
            boolean remove;
            --this.ttl;
            boolean bl = remove = this.ttl == 0L;
            if (remove) {
                this.wme.remove();
                for (InputWme wme : this.supportWmes) {
                    wme.remove();
                }
            }
            return remove;
        }
    }

    private static class NewMessage {
        final Element element;
        final String name;

        public NewMessage(Element element, String name) {
            this.element = element;
            this.name = name;
        }
    }

    public static class Builder {
        private final InputOutput io;
        private XmlToWme converter;
        private long timeToLive = 50L;
        private String queueName = "messages";

        private Builder(InputOutput io) {
            Arguments.checkNotNull(io, "io");
            this.io = io;
        }

        public XmlToWme converter() {
            return this.converter;
        }

        public Builder converter(XmlToWme c) {
            this.converter = c;
            return this;
        }

        public long timeToLive() {
            return this.timeToLive;
        }

        public Builder timeToLive(long ttl) {
            this.timeToLive = ttl;
            return this;
        }

        public String queueName() {
            return this.queueName;
        }

        public Builder queueName(String qn) {
            this.queueName = qn;
            return this;
        }

        public XmlMessageQueue create() {
            return new XmlMessageQueue(this);
        }
    }
}

