/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.learning;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import org.jsoar.kernel.Agent;
import org.jsoar.kernel.Decider;
import org.jsoar.kernel.DecisionCycle;
import org.jsoar.kernel.ImpasseType;
import org.jsoar.kernel.PredefinedSymbols;
import org.jsoar.kernel.Production;
import org.jsoar.kernel.ProductionType;
import org.jsoar.kernel.Productions;
import org.jsoar.kernel.SoarProperties;
import org.jsoar.kernel.events.ProductionAddedEvent;
import org.jsoar.kernel.learning.Backtracer;
import org.jsoar.kernel.learning.ChunkCondition;
import org.jsoar.kernel.learning.ChunkConditionSet;
import org.jsoar.kernel.learning.Explain;
import org.jsoar.kernel.learning.ExplainChunk;
import org.jsoar.kernel.lhs.ComplexTest;
import org.jsoar.kernel.lhs.Condition;
import org.jsoar.kernel.lhs.Conditions;
import org.jsoar.kernel.lhs.ConjunctiveNegationCondition;
import org.jsoar.kernel.lhs.ConjunctiveTest;
import org.jsoar.kernel.lhs.EqualityTest;
import org.jsoar.kernel.lhs.GoalIdTest;
import org.jsoar.kernel.lhs.ImpasseIdTest;
import org.jsoar.kernel.lhs.PositiveCondition;
import org.jsoar.kernel.lhs.RelationalTest;
import org.jsoar.kernel.lhs.Test;
import org.jsoar.kernel.lhs.Tests;
import org.jsoar.kernel.lhs.ThreeFieldCondition;
import org.jsoar.kernel.memory.Instantiation;
import org.jsoar.kernel.memory.Preference;
import org.jsoar.kernel.memory.RecognitionMemory;
import org.jsoar.kernel.memory.Slot;
import org.jsoar.kernel.memory.WmeImpl;
import org.jsoar.kernel.rete.NotStruct;
import org.jsoar.kernel.rete.ProductionAddResult;
import org.jsoar.kernel.rete.Rete;
import org.jsoar.kernel.rhs.Action;
import org.jsoar.kernel.rhs.MakeAction;
import org.jsoar.kernel.rhs.ReordererException;
import org.jsoar.kernel.smem.DefaultSemanticMemory;
import org.jsoar.kernel.symbols.IdentifierImpl;
import org.jsoar.kernel.symbols.SymbolFactory;
import org.jsoar.kernel.symbols.SymbolFactoryImpl;
import org.jsoar.kernel.symbols.SymbolImpl;
import org.jsoar.kernel.symbols.Variable;
import org.jsoar.kernel.tracing.Printer;
import org.jsoar.kernel.tracing.Trace;
import org.jsoar.util.ByRef;
import org.jsoar.util.DefaultSourceLocation;
import org.jsoar.util.ListHead;
import org.jsoar.util.ListItem;
import org.jsoar.util.SourceLocation;
import org.jsoar.util.adaptables.Adaptables;
import org.jsoar.util.markers.DefaultMarker;
import org.jsoar.util.markers.Marker;
import org.jsoar.util.properties.BooleanPropertyProvider;

public class Chunker {
    private static final SourceLocation NEW_PRODUCTION_SOURCE = DefaultSourceLocation.newBuilder().file("*chunker*").build();
    private final Agent context;
    private Decider decider;
    private Backtracer backtrace;
    private PredefinedSymbols predefinedSyms;
    Explain explain;
    private DecisionCycle decisionCycle;
    private Rete rete;
    private RecognitionMemory recMemory;
    public int chunks_this_d_cycle;
    private int maxChunks = 50;
    private boolean maxChunksReached = false;
    private int results_match_goal_level;
    private Marker results_tc_number;
    private Preference results;
    private Preference extra_result_prefs_from_instantiation;
    public Marker variablization_tc;
    final ChunkConditionSet negated_set = new ChunkConditionSet();
    private boolean chunkThroughLocalNegations = true;
    public boolean chunkThroughEvaluationRules = false;
    boolean quiescence_t_flag = false;
    private boolean useLongChunkNames = true;
    private String chunk_name_prefix = "chunk";
    private ByRef<Integer> chunk_count = ByRef.create(1);
    private ByRef<Integer> justification_count = ByRef.create(1);
    private BooleanPropertyProvider learningOn = new BooleanPropertyProvider(SoarProperties.LEARNING_ON);
    private boolean learningAllGoals = true;
    private boolean learningExcept = false;
    private boolean learningOnly = false;
    private final LinkedList<IdentifierImpl> chunk_free_problem_spaces = new LinkedList();
    private final LinkedList<IdentifierImpl> chunky_problem_spaces = new LinkedList();
    final LinkedList<Instantiation> instantiations_with_nots = new LinkedList();

    public Chunker(Agent context) {
        this.context = context;
        this.context.getProperties().setProvider(SoarProperties.LEARNING_ON, this.learningOn);
    }

    public void initialize() {
        this.predefinedSyms = Adaptables.adapt(this.context, PredefinedSymbols.class);
        this.decider = Adaptables.adapt(this.context, Decider.class);
        this.explain = Adaptables.adapt(this.context, Explain.class);
        this.backtrace = new Backtracer(this.context);
        this.backtrace.initialize();
        this.decisionCycle = Adaptables.adapt(this.context, DecisionCycle.class);
        this.rete = Adaptables.adapt(this.context, Rete.class);
        this.recMemory = Adaptables.adapt(this.context, RecognitionMemory.class);
    }

    public void reset() {
        this.chunk_free_problem_spaces.clear();
        this.chunky_problem_spaces.clear();
    }

    public boolean isLearningOn() {
        return this.learningOn.value.get();
    }

    public boolean isMaxChunksReached() {
        return this.maxChunksReached;
    }

    public void removeGoalFromChunkyProblemSpaces(IdentifierImpl goal) {
        Iterator it = this.chunky_problem_spaces.iterator();
        while (it.hasNext()) {
            IdentifierImpl id = (IdentifierImpl)it.next();
            if (id != goal) continue;
            it.remove();
        }
    }

    public void removeGoalFromChunkFreeProblemSpaces(IdentifierImpl goal) {
        Iterator it = this.chunk_free_problem_spaces.iterator();
        while (it.hasNext()) {
            IdentifierImpl id = (IdentifierImpl)it.next();
            if (id != goal) continue;
            it.remove();
        }
    }

    private void add_results_if_needed(SymbolImpl sym) {
        IdentifierImpl id = sym.asIdentifier();
        if (id != null && id.level >= this.results_match_goal_level && id.tc_number != this.results_tc_number) {
            this.add_results_for_id(id);
        }
    }

    private void add_pref_to_results(Preference pref) {
        Preference p = this.results;
        while (p != null) {
            if (p.id == pref.id && p.attr == pref.attr && p.value == pref.value && p.type == pref.type) {
                if (pref.type.isUnary()) {
                    return;
                }
                if (p.referent == pref.referent) {
                    return;
                }
            }
            p = p.next_result;
        }
        if (pref.inst.match_goal_level != this.results_match_goal_level) {
            p = null;
            p = pref.next_clone;
            while (p != null && p.inst.match_goal_level != this.results_match_goal_level) {
                p = p.next_clone;
            }
            if (p == null) {
                p = pref.prev_clone;
                while (p != null && p.inst.match_goal_level != this.results_match_goal_level) {
                    p = p.prev_clone;
                }
            }
            if (p == null) {
                return;
            }
            pref = p;
        }
        pref.next_result = this.results;
        this.results = pref;
        this.add_results_if_needed(pref.value);
        if (pref.type.isBinary()) {
            this.add_results_if_needed(pref.referent);
        }
    }

    private void add_results_for_id(IdentifierImpl id) {
        id.tc_number = this.results_tc_number;
        WmeImpl w = id.getInputWmes();
        while (w != null) {
            this.add_results_if_needed(w.value);
            w = w.next;
        }
        Slot s = id.slots;
        while (s != null) {
            Preference pref = s.getAllPreferences();
            while (pref != null) {
                this.add_pref_to_results(pref);
                pref = pref.nextOfSlot;
            }
            WmeImpl w2 = s.getWmes();
            while (w2 != null) {
                this.add_results_if_needed(w2.value);
                w2 = w2.next;
            }
            s = s.next;
        }
        Preference pref = this.extra_result_prefs_from_instantiation;
        while (pref != null) {
            if (pref.id == id) {
                this.add_pref_to_results(pref);
            }
            pref = pref.inst_next;
        }
    }

    private Preference get_results_for_instantiation(Instantiation inst) {
        this.results = null;
        this.results_match_goal_level = inst.match_goal_level;
        this.results_tc_number = DefaultMarker.create();
        this.extra_result_prefs_from_instantiation = inst.preferences_generated;
        Preference pref = inst.preferences_generated;
        while (pref != null) {
            if (pref.id.level < this.results_match_goal_level && pref.id.tc_number != this.results_tc_number) {
                this.add_pref_to_results(pref);
            }
            pref = pref.inst_next;
        }
        return this.results;
    }

    public SymbolImpl variablize_symbol(SymbolImpl sym) {
        IdentifierImpl id = sym.asIdentifier();
        if (id == null) {
            return sym;
        }
        if (id.smem_lti != 0L) {
            id.tc_number = this.variablization_tc;
            id.variablization = sym;
            return sym;
        }
        if (id.tc_number == this.variablization_tc) {
            return id.variablization;
        }
        id.tc_number = this.variablization_tc;
        Variable var = ((SymbolFactoryImpl)this.context.getSymbols()).getVariableGenerator().generate_new_variable(Character.toString(id.getNameLetter()));
        id.variablization = var;
        return var;
    }

    private Test variablize_test(Test t) {
        if (Tests.isBlank(t)) {
            return t;
        }
        EqualityTest eq = t.asEqualityTest();
        if (eq != null) {
            return SymbolImpl.makeEqualityTest(this.variablize_symbol(eq.getReferent()));
        }
        if (t.asGoalIdTest() != null || t.asImpasseIdTest() != null || t.asDisjunctionTest() != null) {
            return t;
        }
        ConjunctiveTest ct = t.asConjunctiveTest();
        if (ct != null) {
            ListIterator<Test> it = ct.conjunct_list.listIterator();
            while (it.hasNext()) {
                Test c = it.next();
                it.set(this.variablize_test(c));
            }
            return ct;
        }
        RelationalTest rt = t.asRelationalTest();
        return rt.withNewReferent(this.variablize_symbol(rt.referent));
    }

    public void variablize_condition_list(Condition cond) {
        while (cond != null) {
            ConjunctiveNegationCondition ncc;
            ThreeFieldCondition tfc = cond.asThreeFieldCondition();
            if (tfc != null) {
                tfc.id_test = this.variablize_test(tfc.id_test);
                tfc.attr_test = this.variablize_test(tfc.attr_test);
                tfc.value_test = this.variablize_test(tfc.value_test);
            }
            if ((ncc = cond.asConjunctiveNegationCondition()) != null) {
                this.variablize_condition_list(ncc.top);
            }
            cond = cond.next;
        }
    }

    private MakeAction copy_and_variablize_result_list(Preference pref, boolean variablize) {
        if (pref == null) {
            return null;
        }
        MakeAction a = new MakeAction();
        SymbolImpl id = pref.id;
        SymbolImpl attr = pref.attr;
        SymbolImpl val = pref.value;
        SymbolImpl ref = pref.referent;
        if (variablize) {
            id = this.variablize_symbol(id);
            attr = this.variablize_symbol(attr);
            val = this.variablize_symbol(val);
        }
        a.id = id.toRhsValue();
        a.attr = attr.toRhsValue();
        a.value = val.toRhsValue();
        a.preference_type = pref.type;
        if (pref.type.isBinary()) {
            if (variablize) {
                ref = this.variablize_symbol(ref);
            }
            a.referent = this.variablize_symbol(ref).toRhsValue();
        }
        a.next = this.copy_and_variablize_result_list(pref.next_result, variablize);
        return a;
    }

    private void build_chunk_conds_for_grounds_and_add_negateds(ByRef<ChunkCondition> dest_top, ByRef<ChunkCondition> dest_bottom, Marker tc_to_use, ByRef<Boolean> reliable) {
        ChunkCondition cc;
        ListItem<ChunkCondition> first_cc = null;
        ListItem<ChunkCondition> prev_cc = null;
        while (!this.backtrace.grounds.isEmpty()) {
            Condition ground = this.backtrace.grounds.pop();
            cc = new ChunkCondition(ground);
            cc.instantiated_cond = Condition.copy_condition(cc.cond);
            cc.variablized_cond = Condition.copy_condition(cc.cond);
            if (prev_cc != null) {
                prev_cc.next = cc.next_prev;
                cc.next_prev.previous = prev_cc;
                cc.variablized_cond.prev = ((ChunkCondition)prev_cc.item).variablized_cond;
                ((ChunkCondition)prev_cc.item).variablized_cond.next = cc.variablized_cond;
                cc.instantiated_cond.prev = ((ChunkCondition)prev_cc.item).instantiated_cond;
                ((ChunkCondition)prev_cc.item).instantiated_cond.next = cc.instantiated_cond;
            } else {
                first_cc = cc.next_prev;
                cc.next_prev.previous = null;
                cc.variablized_cond.prev = null;
                cc.instantiated_cond.prev = null;
            }
            prev_cc = cc.next_prev;
            ground.add_cond_to_tc(tc_to_use, null, null);
        }
        Trace trace = this.context.getTrace();
        trace.print(Trace.Category.BACKTRACING, "\n\n*** Adding Grounded Negated Conditions ***\n");
        while (!this.negated_set.all.isEmpty()) {
            cc = this.negated_set.all.getFirstItem();
            this.negated_set.remove_from_chunk_cond_set(cc);
            if (cc.cond.cond_is_in_tc(tc_to_use)) {
                trace.print(Trace.Category.BACKTRACING, "\n-.Moving to grounds: %s", cc.cond);
                cc.instantiated_cond = Condition.copy_condition(cc.cond);
                cc.variablized_cond = Condition.copy_condition(cc.cond);
                if (prev_cc != null) {
                    prev_cc.next = cc.next_prev;
                    cc.next_prev.previous = prev_cc;
                    cc.variablized_cond.prev = ((ChunkCondition)prev_cc.item).variablized_cond;
                    ((ChunkCondition)prev_cc.item).variablized_cond.next = cc.variablized_cond;
                    cc.instantiated_cond.prev = ((ChunkCondition)prev_cc.item).instantiated_cond;
                    ((ChunkCondition)prev_cc.item).instantiated_cond.next = cc.instantiated_cond;
                } else {
                    first_cc = cc.next_prev;
                    cc.next_prev.previous = null;
                    cc.variablized_cond.prev = null;
                    cc.instantiated_cond.prev = null;
                }
                prev_cc = cc.next_prev;
                continue;
            }
            if (this.chunkThroughLocalNegations) continue;
            this.backtrace.report_local_negation(cc.cond);
            reliable.value = false;
        }
        if (prev_cc != null) {
            prev_cc.next = null;
            ((ChunkCondition)prev_cc.item).variablized_cond.next = null;
            ((ChunkCondition)prev_cc.item).instantiated_cond.next = null;
        } else {
            first_cc = null;
        }
        dest_top.value = first_cc.item;
        dest_bottom.value = prev_cc.item;
    }

    private NotStruct get_nots_for_instantiated_conditions(LinkedList<Instantiation> instantiations_with_nots, Marker tc_of_grounds) {
        NotStruct collected_nots = null;
        while (!instantiations_with_nots.isEmpty()) {
            Instantiation inst = instantiations_with_nots.pop();
            NotStruct n1 = inst.nots;
            while (n1 != null) {
                if (n1.s1.tc_number == tc_of_grounds && n1.s2.tc_number == tc_of_grounds) {
                    NotStruct n2 = collected_nots;
                    while (!(n2 == null || n2.s1 == n1.s1 && n2.s2 == n1.s2 || n2.s1 == n1.s2 && n2.s2 == n1.s1)) {
                        n2 = n2.next;
                    }
                    if (n2 == null) {
                        NotStruct new_not = new NotStruct(n1.s1, n1.s2);
                        new_not.next = collected_nots;
                        collected_nots = new_not;
                    }
                }
                n1 = n1.next;
            }
        }
        return collected_nots;
    }

    public void variablize_nots_and_insert_into_conditions(NotStruct nots, Condition conds) {
        NotStruct n = nots;
        while (n != null) {
            SymbolImpl var1 = n.s1.variablization;
            SymbolImpl var2 = n.s2.variablization;
            RelationalTest t = new RelationalTest(1, var2);
            boolean added_it = false;
            Condition c = conds;
            while (c != null) {
                PositiveCondition pc = c.asPositiveCondition();
                if (pc != null) {
                    if (Tests.test_includes_equality_test_for_symbol(pc.id_test, var1)) {
                        pc.id_test = Tests.add_new_test_to_test(pc.id_test, t);
                        added_it = true;
                        break;
                    }
                    if (Tests.test_includes_equality_test_for_symbol(pc.attr_test, var1)) {
                        pc.attr_test = Tests.add_new_test_to_test(pc.attr_test, t);
                        added_it = true;
                        break;
                    }
                    if (Tests.test_includes_equality_test_for_symbol(pc.value_test, var1)) {
                        pc.value_test = Tests.add_new_test_to_test(pc.value_test, t);
                        added_it = true;
                        break;
                    }
                }
                c = c.next;
            }
            if (!added_it) {
                throw new IllegalStateException("Internal error: couldn't add Not test to chunk");
            }
            n = n.next;
        }
    }

    private void add_goal_or_impasse_tests(ListItem<ChunkCondition> all_ccs) {
        DefaultMarker tc = DefaultMarker.create();
        ListItem<ChunkCondition> ccIter = all_ccs;
        while (ccIter != null) {
            IdentifierImpl id;
            ChunkCondition cc = (ChunkCondition)ccIter.item;
            PositiveCondition pc = cc.instantiated_cond.asPositiveCondition();
            if (pc != null && (id = pc.id_test.asEqualityTest().getReferent().asIdentifier()).isGoal() && id.tc_number != tc) {
                ComplexTest t = id.isGoal() ? GoalIdTest.INSTANCE : ImpasseIdTest.INSTANCE;
                ThreeFieldCondition tfc = cc.variablized_cond.asThreeFieldCondition();
                tfc.id_test = Tests.add_new_test_to_test(tfc.id_test, t);
                id.tc_number = tc;
            }
            ccIter = ccIter.next;
        }
    }

    private void reorder_instantiated_conditions(ListHead<ChunkCondition> top_cc, ByRef<Condition> dest_inst_top, ByRef<Condition> dest_inst_bottom) {
        ChunkCondition cc;
        ListItem it = top_cc.first;
        while (it != null) {
            cc = (ChunkCondition)it.item;
            cc.saved_prev_pointer_of_variablized_cond = cc.variablized_cond.prev;
            cc.variablized_cond.prev = cc.instantiated_cond;
            it = it.next;
        }
        it = top_cc.first;
        while (it != null) {
            cc = (ChunkCondition)it.item;
            if (cc.variablized_cond.next != null) {
                cc.instantiated_cond.next = cc.variablized_cond.next.prev;
            } else {
                cc.instantiated_cond.next = null;
                dest_inst_bottom.value = cc.instantiated_cond;
            }
            if (cc.saved_prev_pointer_of_variablized_cond != null) {
                cc.instantiated_cond.prev = cc.saved_prev_pointer_of_variablized_cond.prev;
            } else {
                cc.instantiated_cond.prev = null;
                dest_inst_top.value = cc.instantiated_cond;
            }
            it = it.next;
        }
        it = top_cc.first;
        while (it != null) {
            cc = (ChunkCondition)it.item;
            cc.variablized_cond.prev = cc.saved_prev_pointer_of_variablized_cond;
            it = it.next;
        }
    }

    private void make_clones_of_results(Preference results, Instantiation chunk_inst) {
        chunk_inst.preferences_generated = null;
        Preference result_p = results;
        while (result_p != null) {
            Preference p = new Preference(result_p.type, result_p.id, result_p.attr, result_p.value, result_p.referent);
            p.inst = chunk_inst;
            chunk_inst.insertGeneratedPreference(p);
            p.next_clone = result_p;
            p.prev_clone = result_p.prev_clone;
            result_p.prev_clone = p;
            if (p.prev_clone != null) {
                p.prev_clone.next_clone = p;
            }
            result_p = result_p.next_result;
        }
    }

    private static SymbolImpl find_impasse_wme_value(IdentifierImpl id, SymbolImpl attr) {
        WmeImpl w = id.goalInfo.getImpasseWmes();
        while (w != null) {
            if (w.attr == attr) {
                return w.value;
            }
            w = w.next;
        }
        return null;
    }

    private String generate_chunk_name_sym_constant(Instantiation inst) {
        if (!this.useLongChunkNames) {
            return Productions.generateUniqueName(this.context.getProductions(), this.chunk_name_prefix, this.chunk_count);
        }
        int lowest_result_level = this.decider.top_goal.level;
        Preference p = inst.preferences_generated;
        while (p != null) {
            if (p.id.level > lowest_result_level) {
                lowest_result_level = p.id.level;
            }
            p = p.inst_next;
        }
        IdentifierImpl goal = this.decider.find_goal_at_goal_stack_level(lowest_result_level);
        String impass_name = null;
        if (goal != null) {
            ImpasseType impasse_type = this.decider.type_of_existing_impasse(goal);
            switch (impasse_type) {
                case NONE: {
                    impass_name = "unknownimpasse";
                    break;
                }
                case CONSTRAINT_FAILURE: {
                    impass_name = "cfailure";
                    break;
                }
                case CONFLICT: {
                    impass_name = "conflict";
                    break;
                }
                case TIE: {
                    impass_name = "tie";
                    break;
                }
                case NO_CHANGE: {
                    SymbolImpl sym = Chunker.find_impasse_wme_value(goal.goalInfo.lower_goal, this.predefinedSyms.attribute_symbol);
                    if (sym == null) {
                        impass_name = "unknownimpasse";
                        break;
                    }
                    if (sym == this.predefinedSyms.operator_symbol) {
                        impass_name = "opnochange";
                        break;
                    }
                    if (sym == this.predefinedSyms.state_symbol) {
                        impass_name = "snochange";
                        break;
                    }
                    impass_name = "unknownimpasse";
                    break;
                }
                default: {
                    impass_name = "unknownimpasse";
                }
            }
        } else {
            impass_name = "unknownimpasse";
        }
        String name = this.chunk_name_prefix + "-" + this.chunk_count.value + "*d" + this.decisionCycle.d_cycle_count + "*" + impass_name + "*" + this.chunks_this_d_cycle;
        this.chunk_count.value = (Integer)this.chunk_count.value + 1;
        SymbolFactory syms = this.context.getSymbols();
        if (syms.findString(name) != null) {
            int collision_count = 1;
            this.context.getPrinter().warn("Warning: generated chunk name (%s) already exists.  Will find unique name.\n", name);
            do {
                name = this.chunk_name_prefix + "-" + this.chunk_count + "*d" + this.decisionCycle.d_cycle_count + "*" + impass_name + "*" + this.chunks_this_d_cycle + "*" + collision_count++;
            } while (this.context.getProductions().getProduction(name) != null);
        }
        return name;
    }

    boolean should_variablize(Instantiation inst) {
        if (!this.isLearningOn()) {
            return false;
        }
        if (this.learningExcept && this.chunk_free_problem_spaces.contains(inst.match_goal)) {
            return false;
        }
        if (this.learningOnly && !this.chunky_problem_spaces.contains(inst.match_goal)) {
            return false;
        }
        if (!this.learningAllGoals && !inst.match_goal.goalInfo.allow_bottom_up_chunks) {
            return false;
        }
        Preference p = inst.preferences_generated;
        while (p != null) {
            if (p.id.level < inst.match_goal_level - 1) {
                return false;
            }
            p = p.inst_next;
        }
        return true;
    }

    public void chunk_instantiation(Instantiation inst, boolean dont_variablize, ByRef<Instantiation> custom_inst_list) {
        boolean variablize;
        if (inst.match_goal == null) {
            return;
        }
        Preference pref = null;
        Preference i = inst.preferences_generated;
        while (i != null) {
            if (i.id.level < inst.match_goal_level) {
                pref = i;
                break;
            }
            i = i.inst_next;
        }
        if (pref == null) {
            return;
        }
        Preference results = this.get_results_for_instantiation(inst);
        if (results == null) {
            return;
        }
        IdentifierImpl g = inst.match_goal.goalInfo.higher_goal;
        while (g != null && g.goalInfo.allow_bottom_up_chunks) {
            g.goalInfo.allow_bottom_up_chunks = false;
            g = g.goalInfo.higher_goal;
        }
        int grounds_level = inst.match_goal_level - 1;
        ++this.backtrace.backtrace_number;
        if (this.backtrace.backtrace_number == 0) {
            this.backtrace.backtrace_number = 1;
        }
        ++this.backtrace.grounds_tc;
        if (this.backtrace.grounds_tc == 0) {
            this.backtrace.grounds_tc = 1;
        }
        ++this.backtrace.potentials_tc;
        if (this.backtrace.potentials_tc == 0) {
            this.backtrace.potentials_tc = 1;
        }
        ++this.backtrace.locals_tc;
        if (this.backtrace.locals_tc == 0) {
            this.backtrace.locals_tc = 1;
        }
        this.backtrace.grounds.clear();
        this.backtrace.positive_potentials.clear();
        this.backtrace.locals.clear();
        this.instantiations_with_nots.clear();
        ExplainChunk temp_explain_chunk = null;
        if (this.explain.isEnabled()) {
            temp_explain_chunk = new ExplainChunk();
            this.explain.reset_backtrace_list();
        }
        Trace trace = this.context.getTrace();
        ByRef<Boolean> reliable = new ByRef<Boolean>(true);
        pref = results;
        while (pref != null) {
            trace.print(Trace.Category.BACKTRACING, "\nFor result preference %s ", pref);
            this.backtrace.backtrace_through_instantiation(pref.inst, grounds_level, null, reliable, 0);
            pref = pref.next_result;
        }
        do {
            this.backtrace.trace_locals(grounds_level, reliable);
            this.backtrace.trace_grounded_potentials();
        } while (this.backtrace.trace_ungrounded_potentials(grounds_level, reliable));
        this.backtrace.positive_potentials.clear();
        ByRef<Object> top_cc = ByRef.create(null);
        ByRef<Object> bottom_cc = ByRef.create(null);
        NotStruct nots = null;
        DefaultMarker tc_for_grounds = DefaultMarker.create();
        this.build_chunk_conds_for_grounds_and_add_negateds(top_cc, bottom_cc, tc_for_grounds, reliable);
        nots = this.get_nots_for_instantiated_conditions(this.instantiations_with_nots, tc_for_grounds);
        boolean bl = variablize = !dont_variablize && (Boolean)reliable.value != false && this.should_variablize(inst);
        if (variablize && top_cc.value != null) {
            this.variablization_tc = DefaultMarker.create();
            MakeAction rhs = this.copy_and_variablize_result_list(results, true);
            if (!DefaultSemanticMemory.smem_valid_production(((ChunkCondition)top_cc.value).variablized_cond, rhs)) {
                variablize = false;
                trace.print(Trace.Category.BACKTRACING, "\nWarning: LTI validation failed, creating justification instead.");
            }
        }
        String prod_name = null;
        ProductionType prod_type = null;
        boolean print_name = false;
        boolean print_prod = false;
        if (variablize) {
            ++this.chunks_this_d_cycle;
            prod_name = this.generate_chunk_name_sym_constant(inst);
            prod_type = ProductionType.CHUNK;
            print_name = trace.isEnabled(Trace.Category.CHUNK_NAMES);
            trace.print(Trace.Category.CHUNK_NAMES, "Building %s", prod_name);
            print_prod = trace.isEnabled(Trace.Category.CHUNKS);
        } else {
            prod_name = Productions.generateUniqueName(this.context.getProductions(), "justification-", this.justification_count);
            prod_type = ProductionType.JUSTIFICATION;
            print_name = trace.isEnabled(Trace.Category.JUSTIFICATION_NAMES);
            trace.print(Trace.Category.JUSTIFICATION_NAMES, "Building %s", prod_name);
            print_prod = trace.isEnabled(Trace.Category.JUSTIFICATIONS);
        }
        if (top_cc.value == null) {
            this.context.getPrinter().print("Warning: chunk has no grounds, ignoring it.");
            return;
        }
        if (this.chunks_this_d_cycle > this.maxChunks) {
            this.context.getPrinter().warn("\nWarning: reached max-chunks! Halting system.");
            this.maxChunksReached = true;
            return;
        }
        Condition lhs_top = ((ChunkCondition)top_cc.value).variablized_cond;
        Condition lhs_bottom = ((ChunkCondition)bottom_cc.value).variablized_cond;
        if (variablize) {
            this.predefinedSyms.getSyms().getVariableGenerator().reset(lhs_top, null);
            this.variablization_tc = DefaultMarker.create();
            this.variablize_condition_list(lhs_top);
            this.variablize_nots_and_insert_into_conditions(nots, lhs_top);
        }
        MakeAction rhs = this.copy_and_variablize_result_list(results, variablize);
        this.add_goal_or_impasse_tests(((ChunkCondition)top_cc.value).next_prev);
        Production prod = Production.newBuilder().type(prod_type).location(NEW_PRODUCTION_SOURCE).name(prod_name).conditions(lhs_top, lhs_bottom).actions(rhs).build();
        try {
            this.context.getProductions().addChunk(prod);
        }
        catch (ReordererException e) {
            Printer p = this.context.getPrinter();
            p.print("\nUnable to reorder this chunk:\n ");
            Conditions.print_condition_list(p, lhs_top, 2, false);
            p.print("\n -->\n ");
            Action.print_action_list(p, rhs, 3, false);
            p.print("\n\nThis error is likely caused by the reasons outlined section 4 of the Soar\n");
            p.print("manual, subsection \"revising the substructure of a previous result\".\n");
            p.print("\n");
            p.print("Check that the rules are not revising substructure of a result matched only\n");
            p.print("through the local state.\n");
            this.decisionCycle.halt("Bad chunk");
            return;
        }
        Instantiation chunk_inst = null;
        ByRef<Object> inst_lhs_top = ByRef.create(null);
        ByRef<Object> inst_lhs_bottom = ByRef.create(null);
        this.reorder_instantiated_conditions(((ChunkCondition)top_cc.value).next_prev.toListHead(), inst_lhs_top, inst_lhs_bottom);
        if (this.explain.isEnabled()) {
            temp_explain_chunk.all_grounds = (Condition)inst_lhs_top.value;
        }
        chunk_inst = new Instantiation(prod, null, null);
        chunk_inst.top_of_instantiated_conditions = (Condition)inst_lhs_top.value;
        chunk_inst.bottom_of_instantiated_conditions = (Condition)inst_lhs_bottom.value;
        chunk_inst.nots = nots;
        chunk_inst.GDS_evaluated_already = false;
        chunk_inst.reliable = (Boolean)reliable.value;
        chunk_inst.in_ms = true;
        this.make_clones_of_results(results, chunk_inst);
        this.recMemory.fill_in_new_instantiation_stuff(chunk_inst, true);
        if (this.explain.isEnabled()) {
            ByRef<Object> new_top = ByRef.create(null);
            ByRef<Object> new_bottom = ByRef.create(null);
            Condition.copy_condition_list(prod.getFirstCondition(), new_top, new_bottom);
            temp_explain_chunk.conds = (Condition)new_top.value;
            temp_explain_chunk.actions = this.copy_and_variablize_result_list(results, variablize);
        }
        ProductionAddResult rete_addition_result = this.rete.add_production_to_rete(prod, chunk_inst, print_name, false);
        if (this.explain.isEnabled() && rete_addition_result != ProductionAddResult.DUPLICATE_PRODUCTION && (prod_type != ProductionType.JUSTIFICATION || rete_addition_result != ProductionAddResult.REFRACTED_INST_DID_NOT_MATCH)) {
            temp_explain_chunk.name = prod_name;
            this.explain.explain_add_temp_to_chunk_list(temp_explain_chunk);
        }
        if (print_prod && rete_addition_result != ProductionAddResult.DUPLICATE_PRODUCTION) {
            this.context.getPrinter().print("\n");
            prod.print(this.context.getPrinter(), false);
        }
        if (rete_addition_result == ProductionAddResult.DUPLICATE_PRODUCTION) {
            this.context.getProductions().exciseProduction(prod, false);
        } else if (prod_type == ProductionType.JUSTIFICATION && rete_addition_result == ProductionAddResult.REFRACTED_INST_DID_NOT_MATCH) {
            this.context.getProductions().exciseProduction(prod, false);
        }
        if (rete_addition_result != ProductionAddResult.REFRACTED_INST_MATCHED) {
            chunk_inst.in_ms = false;
        }
        if (rete_addition_result != ProductionAddResult.DUPLICATE_PRODUCTION) {
            this.context.getEvents().fireEvent(new ProductionAddedEvent(this.context, prod));
        }
        custom_inst_list.value = chunk_inst.insertAtHeadOfProdList((Instantiation)custom_inst_list.value);
        if (!this.maxChunksReached) {
            this.chunk_instantiation(chunk_inst, dont_variablize, custom_inst_list);
        }
    }
}

