/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.learning;

import org.jsoar.kernel.learning.Backtrace;
import org.jsoar.kernel.lhs.Condition;
import org.jsoar.kernel.lhs.Conditions;
import org.jsoar.kernel.rhs.Action;
import org.jsoar.kernel.tracing.Printer;

public class ExplainChunk {
    String name = "";
    Condition conds;
    Action actions;
    Backtrace backtrace;
    ExplainChunk next_chunk;
    Condition all_grounds;

    Condition find_ground(Printer printer, int number) {
        Condition ground = null;
        Condition cond = this.all_grounds;
        while (cond != null) {
            if (--number == 0) {
                ground = cond;
            }
            cond = cond.next;
        }
        if (number > 0) {
            printer.print("Could not find this condition.\n");
            return null;
        }
        return ground;
    }

    void explain_trace_chunk(Printer printer) {
        printer.print("Chunk : %s\n", this.name);
        Backtrace prod = this.backtrace;
        while (prod != null) {
            printer.print("Backtrace production : %s\n", prod.prod_name);
            printer.print("Result : %s\n", prod.result);
            if (prod.trace_cond != null) {
                printer.print("Trace condition : %s", prod.trace_cond);
            } else {
                printer.print("The result preference is not stored, sorry.\n");
            }
            printer.print("\nGrounds:\n");
            Conditions.print_list_of_conditions(printer, prod.grounds);
            printer.print("\nPotentials:\n");
            Conditions.print_list_of_conditions(printer, prod.potentials);
            printer.print("\nLocals:\n");
            Conditions.print_list_of_conditions(printer, prod.locals);
            printer.print("\nNegateds:\n");
            Conditions.print_list_of_conditions(printer, prod.negated);
            prod = prod.next_backtrace;
            printer.print("\n\n");
        }
    }
}

