/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.lhs;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jsoar.kernel.lhs.ComplexTest;
import org.jsoar.kernel.lhs.Condition;
import org.jsoar.kernel.lhs.Conditions;
import org.jsoar.kernel.lhs.ConjunctiveNegationCondition;
import org.jsoar.kernel.lhs.ConjunctiveTest;
import org.jsoar.kernel.lhs.EqualityTest;
import org.jsoar.kernel.lhs.MultiAttributes;
import org.jsoar.kernel.lhs.NegativeCondition;
import org.jsoar.kernel.lhs.PositiveCondition;
import org.jsoar.kernel.lhs.RelationalTest;
import org.jsoar.kernel.lhs.Test;
import org.jsoar.kernel.lhs.Tests;
import org.jsoar.kernel.lhs.ThreeFieldCondition;
import org.jsoar.kernel.rhs.ReordererException;
import org.jsoar.kernel.symbols.SymbolImpl;
import org.jsoar.kernel.symbols.Variable;
import org.jsoar.kernel.symbols.VariableGenerator;
import org.jsoar.kernel.tracing.Printer;
import org.jsoar.kernel.tracing.Trace;
import org.jsoar.util.Arguments;
import org.jsoar.util.ByRef;
import org.jsoar.util.ListHead;
import org.jsoar.util.ListItem;
import org.jsoar.util.markers.DefaultMarker;
import org.jsoar.util.markers.Marker;

public class ConditionReorderer {
    private static final int MAX_COST = 10000005;
    private static final int BF_FOR_ACCEPTABLE_PREFS = 8;
    private static final int BF_FOR_VALUES = 8;
    private static final int BF_FOR_ATTRIBUTES = 8;
    private final VariableGenerator vars;
    private final Trace trace;
    private final MultiAttributes multiAttrs;
    private String prodName;
    private final Map<Condition, List<Variable>> reorder_vars_requiring_bindings = new HashMap<Condition, List<Variable>>();

    public ConditionReorderer(VariableGenerator vars, Trace trace, MultiAttributes multiAttrs, String prodName) {
        this.vars = vars;
        this.trace = trace;
        this.multiAttrs = multiAttrs;
        this.prodName = prodName;
    }

    public void reorder_lhs(ByRef<Condition> lhs_top, ByRef<Condition> lhs_bottom, boolean reorder_nccs) throws ReordererException {
        DefaultMarker tc = DefaultMarker.create();
        ListHead<Variable> roots = Conditions.collect_root_variables((Condition)lhs_top.value, tc, this.trace.getPrinter(), this.prodName);
        if (!roots.isEmpty()) {
            this.remove_isa_state_tests_for_non_roots(lhs_top, lhs_bottom, roots);
        }
        if (roots.isEmpty()) {
            Condition cond = (Condition)lhs_top.value;
            while (cond != null) {
                PositiveCondition pc = cond.asPositiveCondition();
                if (pc != null && Tests.test_includes_goal_or_impasse_id_test(pc.id_test, true, false)) {
                    pc.id_test.addBoundVariables(tc, roots);
                    if (!roots.isEmpty()) break;
                }
                cond = cond.next;
            }
        }
        if (roots.isEmpty()) {
            String message = String.format("Error: in production %s,\n The LHS has no roots.\n", this.prodName);
            this.trace.getPrinter().print(message);
            throw new ReordererException(message);
        }
        this.fill_in_vars_requiring_bindings((Condition)lhs_top.value, tc);
        this.reorder_condition_list(lhs_top, lhs_bottom, roots, tc, reorder_nccs);
        this.remove_vars_requiring_bindings((Condition)lhs_top.value);
        this.check_negative_relational_test_bindings((Condition)lhs_top.value, DefaultMarker.create());
    }

    private void reorder_condition_list(ByRef<Condition> top_of_conds, ByRef<Condition> bottom_of_conds, ListHead<Variable> roots, Marker tc, boolean reorder_nccs) {
        SavedTest saved_tests = this.simplify_condition_list((Condition)top_of_conds.value);
        this.reorder_simplified_conditions(top_of_conds, bottom_of_conds, roots, tc, reorder_nccs);
        this.restore_and_deallocate_saved_tests((Condition)top_of_conds.value, tc, saved_tests);
    }

    private void restore_and_deallocate_saved_tests(Condition conds_list, Marker tc, SavedTest tests_to_restore) {
        Printer p;
        ListHead<Variable> new_vars = ListHead.newInstance();
        Condition cond = conds_list;
        while (cond != null) {
            if (cond.asPositiveCondition() != null) {
                PositiveCondition pc = cond.asPositiveCondition();
                ByRef<Test> id_test = ByRef.create(pc.id_test);
                tests_to_restore = this.restore_saved_tests_to_test(id_test, true, tc, tests_to_restore, false);
                pc.id_test = (Test)id_test.value;
                pc.id_test.addBoundVariables(tc, new_vars);
                ByRef<Test> attr_test = ByRef.create(pc.attr_test);
                tests_to_restore = this.restore_saved_tests_to_test(attr_test, false, tc, tests_to_restore, false);
                pc.attr_test = (Test)attr_test.value;
                pc.attr_test.addBoundVariables(tc, new_vars);
                ByRef<Test> value_test = ByRef.create(pc.value_test);
                tests_to_restore = this.restore_saved_tests_to_test(value_test, false, tc, tests_to_restore, false);
                pc.value_test = (Test)value_test.value;
                pc.value_test.addBoundVariables(tc, new_vars);
            }
            cond = cond.next;
        }
        if (tests_to_restore != null && (p = this.trace.getPrinter()).isPrintWarnings()) {
            p.warn("\nWarning: in production %s,\n ignoring test(s) whose referent is unbound:\n", this.prodName);
        }
        Variable.unmark(new_vars);
    }

    private SavedTest restore_saved_tests_to_test(ByRef<Test> t, boolean is_id_field, Marker bound_vars_tc_number, SavedTest tests_to_restore, boolean neg) {
        SavedTest prev_st = null;
        SavedTest next_st = null;
        SavedTest st = tests_to_restore;
        while (st != null) {
            RelationalTest rt;
            next_st = st.next;
            boolean added_it = false;
            if ((is_id_field && (st.the_test.asGoalIdTest() != null || st.the_test.asImpasseIdTest() != null) || st.the_test.asDisjunctionTest() != null) && Tests.test_includes_equality_test_for_symbol((Test)t.value, st.var)) {
                t.value = Tests.add_new_test_to_test_if_not_already_there((Test)t.value, st.the_test, neg);
                added_it = true;
            }
            if ((rt = st.the_test.asRelationalTest()) != null) {
                SymbolImpl referent = rt.referent;
                if (Tests.test_includes_equality_test_for_symbol((Test)t.value, st.var)) {
                    if (ConditionReorderer.symbol_is_constant_or_marked_variable(referent, bound_vars_tc_number) || st.var == referent) {
                        t.value = Tests.add_new_test_to_test_if_not_already_there((Test)t.value, st.the_test, neg);
                        added_it = true;
                    }
                } else if (Tests.test_includes_equality_test_for_symbol((Test)t.value, referent) && (ConditionReorderer.symbol_is_constant_or_marked_variable(st.var, bound_vars_tc_number) || st.var == referent)) {
                    rt.type = RelationalTest.reverse_direction_of_relational_test(rt.type);
                    rt.referent = st.var;
                    st.var = referent;
                    t.value = Tests.add_new_test_to_test_if_not_already_there((Test)t.value, st.the_test, neg);
                    added_it = true;
                }
            }
            if (added_it) {
                if (prev_st != null) {
                    prev_st.next = next_st;
                } else {
                    tests_to_restore = next_st;
                }
            } else {
                prev_st = st;
            }
            st = next_st;
        }
        return tests_to_restore;
    }

    private static boolean symbol_is_constant_or_marked_variable(SymbolImpl referent, Marker bound_vars_tc_number) {
        Variable var = referent.asVariable();
        return var == null || var.tc_number == bound_vars_tc_number;
    }

    private void reorder_simplified_conditions(ByRef<Condition> top_of_conds, ByRef<Condition> bottom_of_conds, ListHead<Variable> roots, Marker bound_vars_tc_number, boolean reorder_nccs) {
        HashMap<Condition, Condition> reorder_next_min_cost = new HashMap<Condition, Condition>();
        Condition remaining_conds = (Condition)top_of_conds.value;
        Condition first_cond = null;
        Condition last_cond = null;
        ListHead<Variable> new_vars = ListHead.newInstance();
        while (remaining_conds != null) {
            Condition min_cost_conds = null;
            int min_cost = 0;
            int cost = 0;
            Condition cond = remaining_conds;
            while (cond != null) {
                cost = this.cost_of_adding_condition(cond, bound_vars_tc_number, roots);
                if (min_cost_conds == null || cost < min_cost) {
                    min_cost = cost;
                    min_cost_conds = cond;
                    reorder_next_min_cost.put(cond, null);
                } else if (cost == min_cost) {
                    reorder_next_min_cost.put(cond, min_cost_conds);
                    min_cost_conds = cond;
                }
                cond = cond.next;
            }
            if (min_cost == 10000005) {
                this.trace.getPrinter().warn("Warning: in production %s,\n The LHS conditions are not all connected.\n", this.prodName);
            }
            if (min_cost > 1 && reorder_next_min_cost.get(min_cost_conds) != null) {
                min_cost = 0x989686;
                cond = min_cost_conds;
                Condition next_cond = (Condition)reorder_next_min_cost.get(cond);
                while (cond != null) {
                    cost = this.find_lowest_cost_lookahead(remaining_conds, cond, bound_vars_tc_number, roots);
                    if (cost < min_cost) {
                        min_cost = cost;
                        min_cost_conds = cond;
                        reorder_next_min_cost.put(cond, null);
                    } else if (cost == min_cost && cond.asPositiveCondition() != null && this.canonical_cond_greater(min_cost_conds, cond)) {
                        min_cost = cost;
                        min_cost_conds = cond;
                        reorder_next_min_cost.put(cond, null);
                    }
                    cond = next_cond;
                    next_cond = cond != null ? (Condition)reorder_next_min_cost.get(cond) : null;
                }
            }
            if (min_cost == 1 && reorder_next_min_cost.get(min_cost_conds) != null) {
                cond = min_cost_conds;
                while (cond != null) {
                    if (cond.asPositiveCondition() != null && min_cost_conds.asPositiveCondition() != null && this.canonical_cond_greater(min_cost_conds, cond)) {
                        min_cost = cost;
                        min_cost_conds = cond;
                    } else if (cond.asPositiveCondition() == null && min_cost_conds.asPositiveCondition() != null) {
                        min_cost = cost;
                        min_cost_conds = cond;
                    }
                    cond = (Condition)reorder_next_min_cost.get(cond);
                }
            }
            Condition chosen = min_cost_conds;
            remaining_conds = Condition.removeFromList(remaining_conds, chosen);
            if (first_cond == null) {
                first_cond = chosen;
            }
            last_cond = Condition.insertAtEnd(last_cond, chosen);
            ConjunctiveNegationCondition ncc = chosen.asConjunctiveNegationCondition();
            if (ncc != null && reorder_nccs) {
                ListHead<Variable> ncc_roots = Conditions.collect_root_variables(ncc.top, bound_vars_tc_number, this.trace.getPrinter(), this.prodName);
                ByRef<Condition> top = ByRef.create(ncc.top);
                ByRef<Condition> bottom = ByRef.create(ncc.bottom);
                this.reorder_condition_list(top, bottom, ncc_roots, bound_vars_tc_number, reorder_nccs);
                ncc.top = (Condition)top.value;
                ncc.bottom = (Condition)bottom.value;
            }
            chosen.addBoundVariables(bound_vars_tc_number, new_vars);
            if (roots.isEmpty()) continue;
            boolean allBound = true;
            ListItem v = roots.first;
            while (v != null) {
                if (((Variable)v.item).tc_number != bound_vars_tc_number) {
                    allBound = false;
                    break;
                }
                v = v.next;
            }
            if (!allBound) continue;
            roots.clear();
        }
        Variable.unmark(new_vars);
        top_of_conds.value = first_cond;
        bottom_of_conds.value = last_cond;
    }

    private int canonical_test(Test t) {
        boolean NON_EQUAL_TEST_RETURN_VAL = false;
        if (Tests.isBlank(t)) {
            return 0;
        }
        EqualityTest eq = t.asEqualityTest();
        if (eq != null) {
            SymbolImpl sym = eq.getReferent();
            if (sym.asString() != null || sym.asInteger() != null || sym.asDouble() != null) {
                return sym.hash_id;
            }
            return 0;
        }
        return 0;
    }

    private boolean canonical_cond_greater(Condition c1, Condition c2) {
        int test_order_2;
        int test_order_1 = this.canonical_test(c1.asPositiveCondition().attr_test);
        if (test_order_1 < (test_order_2 = this.canonical_test(c2.asPositiveCondition().attr_test))) {
            return true;
        }
        return test_order_1 == test_order_2 && this.canonical_test(c1.asPositiveCondition().value_test) < this.canonical_test(c2.asPositiveCondition().value_test);
    }

    private int find_lowest_cost_lookahead(Condition candidates, Condition chosen, Marker tc, ListHead<Variable> root_vars_not_bound_yet) {
        ListHead<Variable> new_vars = ListHead.newInstance();
        chosen.addBoundVariables(tc, new_vars);
        int min_cost = 0x989686;
        Condition c = candidates;
        while (c != null) {
            int cost;
            if (c != chosen && (cost = this.cost_of_adding_condition(c, tc, root_vars_not_bound_yet)) < min_cost) {
                min_cost = cost;
                if (cost <= 1) break;
            }
            c = c.next;
        }
        Variable.unmark(new_vars);
        return min_cost;
    }

    private int cost_of_adding_condition(Condition cond, Marker tc, ListHead<Variable> root_vars_not_bound_yet) {
        PositiveCondition pc = cond.asPositiveCondition();
        if (root_vars_not_bound_yet.isEmpty() && pc != null && !Tests.isBlank(pc.id_test) && !Tests.isBlank(pc.attr_test) && !Tests.isBlank(pc.value_test) && pc.id_test.asEqualityTest() != null && pc.attr_test.asEqualityTest() != null && pc.value_test.asEqualityTest() != null) {
            if (!ConditionReorderer.symbol_is_constant_or_marked_variable(pc.id_test.asEqualityTest().getReferent(), tc)) {
                return 10000005;
            }
            int result = ConditionReorderer.symbol_is_constant_or_marked_variable(pc.attr_test.asEqualityTest().getReferent(), tc) ? this.multiAttrs.getCost(pc.attr_test.asEqualityTest().getReferent(), 1) : 8;
            if (!ConditionReorderer.symbol_is_constant_or_marked_variable(pc.value_test.asEqualityTest().getReferent(), tc)) {
                result = pc.test_for_acceptable_preference ? (result *= 8) : (result *= 8);
            }
            return result;
        }
        if (pc != null) {
            if (!this.test_covered_by_bound_vars(pc.id_test, tc, root_vars_not_bound_yet)) {
                return 10000005;
            }
            int result = this.test_covered_by_bound_vars(pc.attr_test, tc, root_vars_not_bound_yet) ? 1 : 8;
            if (!this.test_covered_by_bound_vars(pc.value_test, tc, root_vars_not_bound_yet)) {
                result = pc.test_for_acceptable_preference ? (result *= 8) : (result *= 8);
            }
            return result;
        }
        for (Variable v : this.reorder_vars_requiring_bindings.get(cond)) {
            if (v.tc_number == tc) continue;
            return 10000005;
        }
        return 1;
    }

    private boolean test_covered_by_bound_vars(Test t, Marker tc, ListHead<Variable> extra_vars) {
        if (Tests.isBlank(t)) {
            return false;
        }
        EqualityTest eq = t.asEqualityTest();
        if (eq != null) {
            SymbolImpl referent = eq.getReferent();
            if (ConditionReorderer.symbol_is_constant_or_marked_variable(referent, tc)) {
                return true;
            }
            return extra_vars.contains(referent);
        }
        ConjunctiveTest ct = t.asConjunctiveTest();
        if (ct != null) {
            for (Test child : ct.conjunct_list) {
                if (!this.test_covered_by_bound_vars(child, tc, extra_vars)) continue;
                return true;
            }
        }
        return false;
    }

    private SavedTest simplify_condition_list(Condition conds_list) {
        SavedTest sts = null;
        Condition c = conds_list;
        while (c != null) {
            if (c.asPositiveCondition() != null) {
                PositiveCondition pc = c.asPositiveCondition();
                ByRef<Test> id_test = ByRef.create(pc.id_test);
                sts = this.simplify_test(id_test, sts);
                pc.id_test = (Test)id_test.value;
                ByRef<Test> attr_test = ByRef.create(pc.attr_test);
                sts = this.simplify_test(attr_test, sts);
                pc.attr_test = (Test)attr_test.value;
                ByRef<Test> value_test = ByRef.create(pc.value_test);
                sts = this.simplify_test(value_test, sts);
                pc.value_test = (Test)value_test.value;
            }
            c = c.next;
        }
        return sts;
    }

    private SavedTest simplify_test(ByRef<Test> t, SavedTest old_sts) {
        if (Tests.isBlank((Test)t.value)) {
            Variable sym = this.vars.generate_new_variable("dummy-");
            t.value = SymbolImpl.makeEqualityTest(sym);
            return old_sts;
        }
        if (((Test)t.value).asEqualityTest() != null) {
            return old_sts;
        }
        ConjunctiveTest ct = ((Test)t.value).asConjunctiveTest();
        if (ct != null) {
            SymbolImpl sym = null;
            for (Test subtest : ct.conjunct_list) {
                EqualityTest eq = subtest.asEqualityTest();
                if (eq == null) continue;
                sym = eq.getReferent();
            }
            if (sym == null) {
                sym = this.vars.generate_new_variable("dummy-");
                EqualityTest newTest = SymbolImpl.makeEqualityTest(sym);
                ct.conjunct_list.add(0, newTest);
            }
            Iterator<Test> it = ct.conjunct_list.iterator();
            while (it.hasNext()) {
                SavedTest saved;
                Test subtest;
                subtest = it.next();
                if (subtest.asEqualityTest() != null) continue;
                old_sts = saved = new SavedTest(old_sts, sym, subtest.asComplexTest());
                it.remove();
            }
        } else {
            SavedTest saved;
            Variable var = this.vars.generate_new_variable("dummy-");
            EqualityTest New = SymbolImpl.makeEqualityTest(var);
            old_sts = saved = new SavedTest(old_sts, var, ((Test)t.value).asComplexTest());
            t.value = New;
        }
        return old_sts;
    }

    private void remove_vars_requiring_bindings(Condition cond_list) {
        Condition c = cond_list;
        while (c != null) {
            ConjunctiveNegationCondition ncc;
            PositiveCondition pc = c.asPositiveCondition();
            if (pc == null) {
                this.reorder_vars_requiring_bindings.get(c).clear();
            }
            if ((ncc = c.asConjunctiveNegationCondition()) != null) {
                this.remove_vars_requiring_bindings(ncc.top);
            }
            c = c.next;
        }
    }

    private void remove_isa_state_tests_for_non_roots(ByRef<Condition> lhs_top, ByRef<Condition> lhs_bottom, ListHead<Variable> roots) {
        ByRef<Boolean> a = ByRef.create(false);
        ByRef<Boolean> b = ByRef.create(false);
        Condition cond = (Condition)lhs_top.value;
        while (cond != null) {
            PositiveCondition pc = cond.asPositiveCondition();
            if (pc != null && pc.id_test.asComplexTest() != null && Tests.test_includes_goal_or_impasse_id_test(pc.id_test, true, false) && !Tests.test_tests_for_root(pc.id_test, roots)) {
                pc.id_test = Tests.copy_test_removing_goal_impasse_tests(pc.id_test, a, b);
            }
            cond = cond.next;
        }
    }

    private void fill_in_vars_requiring_bindings(Condition cond_list, Marker tc) {
        PositiveCondition pc;
        ListHead<Variable> new_bound_vars = ListHead.newInstance();
        Condition c = cond_list;
        while (c != null) {
            pc = c.asPositiveCondition();
            if (pc != null) {
                pc.addBoundVariables(tc, new_bound_vars);
            }
            c = c.next;
        }
        c = cond_list;
        while (c != null) {
            ConjunctiveNegationCondition ncc;
            pc = c.asPositiveCondition();
            if (pc == null) {
                this.reorder_vars_requiring_bindings.put(c, this.collect_vars_tested_by_cond_that_are_bound(c, tc, new LinkedList<Variable>()));
            }
            if ((ncc = c.asConjunctiveNegationCondition()) != null) {
                this.fill_in_vars_requiring_bindings(ncc.top, tc);
            }
            c = c.next;
        }
        Variable.unmark(new_bound_vars);
    }

    private LinkedList<Variable> collect_vars_tested_by_cond_that_are_bound(Condition cond, Marker tc, LinkedList<Variable> starting_list) {
        ThreeFieldCondition tfc;
        Arguments.checkNotNull(starting_list, "startingList");
        ConjunctiveNegationCondition ncc = cond.asConjunctiveNegationCondition();
        if (ncc != null) {
            Condition c = ncc.top;
            while (c != null) {
                this.collect_vars_tested_by_cond_that_are_bound(c, tc, starting_list);
                c = c.next;
            }
        }
        if ((tfc = cond.asThreeFieldCondition()) != null) {
            this.collect_vars_tested_by_test_that_are_bound(tfc.id_test, tc, starting_list);
            this.collect_vars_tested_by_test_that_are_bound(tfc.attr_test, tc, starting_list);
            this.collect_vars_tested_by_test_that_are_bound(tfc.value_test, tc, starting_list);
        }
        return starting_list;
    }

    private void collect_vars_tested_by_test_that_are_bound(Test t, Marker tc, LinkedList<Variable> starting_list) {
        Variable referent;
        Arguments.checkNotNull(starting_list, "starting_list");
        if (Tests.isBlank(t)) {
            return;
        }
        EqualityTest eq = t.asEqualityTest();
        if (eq != null) {
            Variable referent2 = eq.getReferent().asVariable();
            if (referent2 != null && referent2.tc_number == tc && !starting_list.contains(referent2)) {
                starting_list.push(referent2);
            }
            return;
        }
        ConjunctiveTest ct = t.asConjunctiveTest();
        if (ct != null) {
            for (Test c : ct.conjunct_list) {
                this.collect_vars_tested_by_test_that_are_bound(c, tc, starting_list);
            }
            return;
        }
        RelationalTest rt = t.asRelationalTest();
        if (rt != null && (referent = rt.referent.asVariable()) != null && referent.tc_number == tc && !starting_list.contains(referent)) {
            starting_list.add(referent);
        }
    }

    private void check_negative_relational_test_bindings(Condition cond_list, Marker tc) throws ReordererException {
        ListHead<Variable> bound_vars = ListHead.newInstance();
        Condition c = cond_list;
        while (c != null) {
            PositiveCondition pc = c.asPositiveCondition();
            if (pc != null) {
                PositiveCondition.addBoundVariables(c, tc, bound_vars);
            } else {
                ConjunctiveNegationCondition ncc = c.asConjunctiveNegationCondition();
                if (ncc != null) {
                    this.check_negative_relational_test_bindings(ncc.top, tc);
                }
            }
            c = c.next;
        }
        c = cond_list;
        while (c != null) {
            NegativeCondition nc = c.asNegativeCondition();
            if (nc != null) {
                this.check_unbound_negative_relational_test_referents(nc.id_test, tc);
                this.check_unbound_negative_relational_test_referents(nc.attr_test, tc);
                this.check_unbound_negative_relational_test_referents(nc.value_test, tc);
            }
            c = c.next;
        }
        Variable.unmark(bound_vars);
    }

    private void check_unbound_negative_relational_test_referents(Test t, Marker tc) throws ReordererException {
        Variable referent;
        RelationalTest rt;
        if (Tests.isBlank(t)) {
            return;
        }
        EqualityTest eq = t.asEqualityTest();
        if (eq != null) {
            return;
        }
        ConjunctiveTest ct = t.asConjunctiveTest();
        if (ct != null) {
            for (Test subtest : ct.conjunct_list) {
                this.check_unbound_negative_relational_test_referents(subtest, tc);
            }
        }
        if ((rt = t.asRelationalTest()) != null && (referent = rt.referent.asVariable()) != null && referent.tc_number != tc) {
            String message = String.format("Error: production %s has an unbound referent in negated relational test %s", this.prodName, t);
            this.trace.getPrinter().print(message);
            throw new ReordererException(message);
        }
    }

    private static class SavedTest {
        SavedTest next;
        SymbolImpl var;
        ComplexTest the_test;

        public SavedTest(SavedTest old_sts, SymbolImpl var, ComplexTest the_test) {
            assert (var != null);
            assert (the_test != null);
            this.next = old_sts;
            this.var = var;
            this.the_test = the_test;
        }
    }
}

