/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.lhs;

import java.util.Iterator;
import java.util.LinkedList;
import org.jsoar.kernel.lhs.Condition;
import org.jsoar.kernel.lhs.ConjunctiveNegationCondition;
import org.jsoar.kernel.lhs.EqualityTest;
import org.jsoar.kernel.lhs.PositiveCondition;
import org.jsoar.kernel.lhs.Test;
import org.jsoar.kernel.lhs.Tests;
import org.jsoar.kernel.lhs.ThreeFieldCondition;
import org.jsoar.kernel.symbols.SymbolImpl;
import org.jsoar.kernel.symbols.Variable;
import org.jsoar.kernel.tracing.Printer;
import org.jsoar.util.ByRef;
import org.jsoar.util.ListHead;
import org.jsoar.util.ListItem;
import org.jsoar.util.markers.Marker;

public class Conditions {
    private Conditions() {
    }

    public static ListHead<Variable> collect_root_variables(Condition cond_list, Marker tc, Printer printer, String name_of_production_being_reordered) {
        ListHead<Variable> new_vars_from_value_slot = ListHead.newInstance();
        Condition cond = cond_list;
        while (cond != null) {
            PositiveCondition pc = cond.asPositiveCondition();
            if (pc != null) {
                pc.value_test.addBoundVariables(tc, new_vars_from_value_slot);
            }
            cond = cond.next;
        }
        ListHead<Variable> new_vars_from_id_slot = ListHead.newInstance();
        Condition cond2 = cond_list;
        while (cond2 != null) {
            PositiveCondition pc = cond2.asPositiveCondition();
            if (pc != null) {
                pc.id_test.addBoundVariables(tc, new_vars_from_id_slot);
            }
            cond2 = cond2.next;
        }
        Variable.unmark(new_vars_from_value_slot);
        new_vars_from_value_slot = null;
        Variable.unmark(new_vars_from_id_slot);
        if (printer != null && printer.isPrintWarnings()) {
            ListItem var = new_vars_from_id_slot.first;
            while (var != null) {
                boolean found_goal_impasse_test = false;
                Condition cond3 = cond_list;
                while (cond3 != null) {
                    PositiveCondition pc = cond3.asPositiveCondition();
                    if (pc != null && Tests.test_includes_equality_test_for_symbol(pc.id_test, (SymbolImpl)var.item) && Tests.test_includes_goal_or_impasse_id_test(pc.id_test, true, true)) {
                        found_goal_impasse_test = true;
                        break;
                    }
                    cond3 = cond3.next;
                }
                if (!found_goal_impasse_test) {
                    printer.warn("\nWarning: On the LHS of production %s, identifier %s is not connected to any goal or impasse.\n", name_of_production_being_reordered, var.item);
                }
                var = var.next;
            }
        }
        return new_vars_from_id_slot;
    }

    public static void print_list_of_conditions(Printer printer, Condition cond) {
        while (cond != null) {
            printer.print("%s\n", cond);
            cond = cond.next;
        }
    }

    public static void print_condition_list(Printer printer, Condition conds, int indent, boolean internal) {
        if (conds == null) {
            return;
        }
        LinkedList<Condition> conds_not_yet_printed = new LinkedList<Condition>();
        Condition c = conds;
        while (c != null) {
            conds_not_yet_printed.add(c);
            c = c.next;
        }
        boolean did_one_line_already = false;
        while (!conds_not_yet_printed.isEmpty()) {
            if (did_one_line_already) {
                printer.print("\n").spaces(indent);
            } else {
                did_one_line_already = true;
            }
            Condition c2 = (Condition)conds_not_yet_printed.pop();
            ConjunctiveNegationCondition ncc = c2.asConjunctiveNegationCondition();
            if (ncc != null) {
                printer.print("-{");
                Conditions.print_condition_list(printer, ncc.top, indent + 2, internal);
                printer.print("}");
                continue;
            }
            ThreeFieldCondition tfc = c2.asThreeFieldCondition();
            ByRef<Boolean> removed_goal_test = ByRef.create(false);
            ByRef<Boolean> removed_impasse_test = ByRef.create(false);
            Test id_test = Tests.copy_test_removing_goal_impasse_tests(tfc.id_test, removed_goal_test, removed_impasse_test);
            EqualityTest id_test_to_match = Tests.copy_of_equality_test_found_in_test(id_test);
            LinkedList<ThreeFieldCondition> conds_for_this_id = new LinkedList<ThreeFieldCondition>();
            conds_for_this_id.add(tfc);
            if (!internal) {
                Iterator it = conds_not_yet_printed.iterator();
                while (it.hasNext()) {
                    Condition n = (Condition)it.next();
                    ThreeFieldCondition ntfc = n.asThreeFieldCondition();
                    if (ntfc == null || !Tests.tests_are_equal(id_test_to_match, ntfc.id_test, false)) continue;
                    conds_for_this_id.add(ntfc);
                    it.remove();
                }
            }
            printer.print(" (");
            if (((Boolean)removed_goal_test.value).booleanValue()) {
                printer.print("state ");
            }
            if (((Boolean)removed_impasse_test.value).booleanValue()) {
                printer.print("impasse ");
            }
            printer.print("%s", id_test);
            while (!conds_for_this_id.isEmpty()) {
                ThreeFieldCondition tc = (ThreeFieldCondition)conds_for_this_id.pop();
                StringBuilder gs = new StringBuilder();
                gs.append(" ");
                if (tc.asNegativeCondition() != null) {
                    gs.append("-");
                }
                gs.append("^");
                gs.append(String.format("%s", tc.attr_test));
                if (!Tests.isBlank(tc.value_test)) {
                    gs.append(String.format(" %s", tc.value_test));
                    if (tc.test_for_acceptable_preference) {
                        gs.append(" +");
                    }
                }
                printer.print(gs.toString());
            }
            printer.print(")");
        }
    }
}

