/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.lhs;

import java.util.Formatter;
import org.jsoar.kernel.lhs.ComplexTest;
import org.jsoar.kernel.lhs.Test;
import org.jsoar.kernel.symbols.SymbolImpl;
import org.jsoar.kernel.symbols.Variable;
import org.jsoar.util.ListHead;
import org.jsoar.util.markers.Marker;

public class RelationalTest
extends ComplexTest {
    public static final int NOT_EQUAL_TEST = 1;
    public static final int LESS_TEST = 2;
    public static final int GREATER_TEST = 3;
    public static final int LESS_OR_EQUAL_TEST = 4;
    public static final int GREATER_OR_EQUAL_TEST = 5;
    public static final int SAME_TYPE_TEST = 6;
    public int type;
    public SymbolImpl referent;

    public static int reverse_direction_of_relational_test(int type) {
        switch (type) {
            case 1: {
                return 1;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 5;
            }
            case 5: {
                return 4;
            }
            case 6: {
                return 6;
            }
        }
        throw new IllegalArgumentException("Unknown RelationalTest type " + type);
    }

    public RelationalTest(int type, SymbolImpl referent) {
        this.type = type;
        this.referent = referent;
    }

    private RelationalTest(RelationalTest other) {
        this.type = other.type;
        this.referent = other.referent;
    }

    @Override
    public RelationalTest asRelationalTest() {
        return this;
    }

    public RelationalTest withNewReferent(SymbolImpl referent) {
        if (referent == this.referent) {
            return this;
        }
        return new RelationalTest(this.type, referent);
    }

    @Override
    public Test copy() {
        return new RelationalTest(this);
    }

    @Override
    public void addAllVariables(Marker tc_number, ListHead<Variable> var_list) {
        Variable var = this.referent.asVariable();
        if (var != null) {
            var.markIfUnmarked(tc_number, var_list);
        }
    }

    @Override
    public void formatTo(Formatter formatter, int flags, int width, int precision) {
        String op = "???";
        switch (this.type) {
            case 1: {
                op = "<>";
                break;
            }
            case 2: {
                op = "<";
                break;
            }
            case 3: {
                op = ">";
                break;
            }
            case 4: {
                op = "<=";
                break;
            }
            case 5: {
                op = ">=";
                break;
            }
            case 6: {
                op = "<=>";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown RelationalTest type " + this.type);
            }
        }
        formatter.format("%s %s", op, this.referent);
    }
}

