/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.memory;

import java.util.Formattable;
import java.util.Formatter;
import java.util.Set;
import org.jsoar.kernel.memory.Instantiation;
import org.jsoar.kernel.memory.PreferenceType;
import org.jsoar.kernel.memory.RecognitionMemory;
import org.jsoar.kernel.memory.Slot;
import org.jsoar.kernel.memory.Wme;
import org.jsoar.kernel.symbols.IdentifierImpl;
import org.jsoar.kernel.symbols.SymbolImpl;

public class Preference
implements Formattable {
    public final PreferenceType type;
    public final IdentifierImpl id;
    public final SymbolImpl attr;
    public final SymbolImpl value;
    public SymbolImpl referent;
    public boolean o_supported = false;
    public boolean on_goal_list = false;
    public int reference_count = 0;
    public Slot slot = null;
    public Preference next;
    Preference previous;
    public Preference nextOfSlot;
    Preference previousOfSlot;
    public Preference all_of_goal_next;
    public Preference all_of_goal_prev;
    public Preference next_clone;
    public Preference prev_clone;
    public Instantiation inst;
    public Preference inst_next;
    public Preference inst_prev;
    public Preference next_candidate;
    public Preference next_result;
    public int total_preferences_for_candidate = 0;
    public double numeric_value = 0.0;
    boolean deallocated = false;
    public boolean rl_contribution = false;
    public Set<Wme> wma_o_set;

    public Preference(PreferenceType type, IdentifierImpl id, SymbolImpl attr, SymbolImpl value, SymbolImpl referent) {
        this.type = type;
        this.id = id;
        this.attr = attr;
        this.value = value;
        this.referent = referent;
        this.total_preferences_for_candidate = 0;
        this.numeric_value = 0.0;
    }

    public static int countCandidates(Preference start) {
        int count = 0;
        while (start != null) {
            start = start.next_candidate;
            ++count;
        }
        return count;
    }

    public static Preference getCandidate(Preference start, int index) {
        for (int i = 0; start != null && i < index; ++i) {
            start = start.next_candidate;
        }
        return start;
    }

    public void setInstantiation(Instantiation inst) {
        assert (!this.deallocated);
        assert (this.inst == null);
        this.inst = inst;
        inst.insertGeneratedPreference(this);
    }

    public boolean isInTempMemory() {
        assert (!this.deallocated);
        return this.slot != null;
    }

    public void preference_add_ref() {
        assert (!this.deallocated);
        ++this.reference_count;
    }

    public void preference_remove_ref(RecognitionMemory recMemory) {
        assert (!this.deallocated);
        assert (this.reference_count > 0);
        --this.reference_count;
        if (this.reference_count == 0) {
            this.possibly_deallocate_preference_and_clones(this, recMemory);
        }
    }

    @Override
    public void formatTo(Formatter formatter, int flags, int width, int precision) {
        formatter.format("(%s ^%s %s %c", this.id, this.attr, this.value, Character.valueOf(this.type.getIndicator()));
        if (this.type.isBinary()) {
            formatter.format(" %s", this.referent);
        }
        if (this.o_supported) {
            formatter.format("  :O ", new Object[0]);
        }
        formatter.format(")\n", new Object[0]);
    }

    public String toString() {
        return String.format("%s", this);
    }

    public static Preference find_clone_for_level(Preference p, int level) {
        if (p == null) {
            return null;
        }
        if (p.inst.match_goal_level == level) {
            return p;
        }
        Preference clone = p.next_clone;
        while (clone != null) {
            if (clone.inst.match_goal_level == level) {
                return clone;
            }
            clone = clone.next_clone;
        }
        clone = p.prev_clone;
        while (clone != null) {
            if (clone.inst.match_goal_level == level) {
                return clone;
            }
            clone = clone.prev_clone;
        }
        return null;
    }

    public static void deallocate_preference(Preference pref, RecognitionMemory recMemory) {
        assert (!pref.deallocated);
        assert (pref.reference_count == 0);
        if (pref.on_goal_list) {
            pref.inst.match_goal.goalInfo.removeGoalPreference(pref);
        }
        pref.inst.removeGeneratedPreferece(pref);
        recMemory.possibly_deallocate_instantiation(pref.inst);
        pref.deallocated = true;
        pref.destroy();
    }

    boolean possibly_deallocate_preference_and_clones(Preference pref, RecognitionMemory recMemory) {
        Preference next;
        assert (!this.deallocated);
        if (pref.reference_count > 0) {
            return false;
        }
        Preference clone = pref.next_clone;
        while (clone != null) {
            if (clone.reference_count > 0) {
                return false;
            }
            clone = clone.next_clone;
        }
        clone = pref.prev_clone;
        while (clone != null) {
            if (clone.reference_count > 0) {
                return false;
            }
            clone = clone.prev_clone;
        }
        clone = pref.next_clone;
        while (clone != null) {
            next = clone.next_clone;
            Preference.deallocate_preference(clone, recMemory);
            clone = next;
        }
        clone = pref.prev_clone;
        while (clone != null) {
            next = clone.prev_clone;
            Preference.deallocate_preference(clone, recMemory);
            clone = next;
        }
        Preference.deallocate_preference(pref, recMemory);
        return true;
    }

    public boolean remove_preference_from_clones(RecognitionMemory recMemory) {
        assert (!this.deallocated);
        Preference pref = this;
        Preference any_clone = null;
        if (this.next_clone != null) {
            any_clone = pref.next_clone;
            pref.next_clone.prev_clone = pref.prev_clone;
        }
        if (pref.prev_clone != null) {
            any_clone = pref.prev_clone;
            pref.prev_clone.next_clone = pref.next_clone;
        }
        pref.prev_clone = null;
        pref.next_clone = null;
        if (any_clone != null) {
            this.possibly_deallocate_preference_and_clones(any_clone, recMemory);
        }
        if (pref.reference_count == 0) {
            Preference.deallocate_preference(pref, recMemory);
            return true;
        }
        return false;
    }

    private void destroy() {
        this.referent = null;
        this.slot = null;
        this.next = null;
        this.previous = null;
        this.nextOfSlot = null;
        this.previousOfSlot = null;
        this.all_of_goal_next = null;
        this.all_of_goal_prev = null;
        this.next_clone = null;
        this.prev_clone = null;
        this.inst = null;
        this.inst_next = null;
        this.inst_prev = null;
        this.next_candidate = null;
        this.next_result = null;
        this.wma_o_set = null;
    }
}

