/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.memory;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jsoar.kernel.memory.Preference;
import org.jsoar.kernel.memory.Slot;
import org.jsoar.kernel.memory.WmeImpl;
import org.jsoar.kernel.symbols.Symbol;

class WmePreferenceIterator
implements Iterator<Preference> {
    private final Symbol value;
    private Preference next;

    public WmePreferenceIterator(WmeImpl wme) {
        this.value = wme.value;
        Slot slot = Slot.find_slot(wme.id, wme.attr);
        this.next = slot != null ? WmePreferenceIterator.getNext(slot.getAllPreferences(), this.value) : null;
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public Preference next() {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        Preference result = this.next;
        this.next = WmePreferenceIterator.getNext(this.next.nextOfSlot, this.value);
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private static Preference getNext(Preference start, Symbol value) {
        while (start != null) {
            if (start.value == value) {
                return start;
            }
            start = start.nextOfSlot;
        }
        return null;
    }
}

