/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.memory;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.jsoar.kernel.Agent;
import org.jsoar.kernel.memory.Wme;
import org.jsoar.kernel.memory.WmeFactory;
import org.jsoar.kernel.symbols.Identifier;
import org.jsoar.kernel.symbols.StringSymbol;
import org.jsoar.kernel.symbols.Symbol;
import org.jsoar.kernel.symbols.SymbolFactory;
import org.jsoar.kernel.symbols.Symbols;
import org.jsoar.util.Arguments;
import org.jsoar.util.StringTools;

public class Wmes {
    public static Symbol createLinkedList(WmeFactory<?> context, Iterator<?> values) {
        return Wmes.createLinkedList(context, values, "next", "value");
    }

    public static Symbol createLinkedList(WmeFactory<?> context, Iterator<?> values, String nextName, String valueName) {
        SymbolFactory syms = context.getSymbols();
        StringSymbol nextSym = syms.createString(nextName);
        StringSymbol valueSym = syms.createString(valueName);
        Symbol head = null;
        Identifier last = null;
        while (values.hasNext()) {
            Object o = values.next();
            Identifier current = syms.createIdentifier('N');
            if (head == null) {
                head = current;
            }
            if (last != null) {
                context.addWme(last, nextSym, current);
            }
            context.addWme(current, valueSym, Symbols.create(syms, o));
            last = current;
        }
        if (last != null) {
            context.addWme(last, nextSym, syms.createString("nil"));
        }
        return head != null ? head : syms.createString("nil");
    }

    public static Iterator<Wme> search(Iterator<Wme> wmes, String id, String attr, String value) {
        final Pattern idPattern = Pattern.compile(StringTools.createRegexFromGlob(id).toUpperCase());
        final Pattern attrPattern = Pattern.compile(StringTools.createRegexFromGlob(attr));
        final Pattern valuePattern = Pattern.compile(StringTools.createRegexFromGlob(value));
        Predicate<Wme> predicate = new Predicate<Wme>(){

            public boolean apply(Wme w) {
                return idPattern.matcher(w.getIdentifier().toString()).matches() && attrPattern.matcher(w.getAttribute().toString()).matches() && valuePattern.matcher(w.getValue().toString()).matches();
            }
        };
        return Iterators.filter(wmes, (Predicate)predicate);
    }

    public static List<Wme> search(Agent agent, String id, String attr, String value) {
        return Lists.newArrayList(Wmes.search(agent.getAllWmesInRete().iterator(), id, attr, value));
    }

    public static MatcherBuilder matcher(SymbolFactory syms) {
        return new MatcherBuilder(syms);
    }

    public static MatcherBuilder matcher(Agent agent) {
        return Wmes.matcher(agent.getSymbols());
    }

    public static Predicate<Wme> newMatcher(SymbolFactory syms, Identifier id, Object attr, Object value, int timetag) {
        Arguments.checkNotNull(syms, "syms");
        return new MatcherPredicate(id, attr != null ? Symbols.create(syms, attr) : null, value != null ? Symbols.create(syms, value) : null, timetag);
    }

    public static Wme find(Iterator<Wme> it, Predicate<Wme> pred) {
        while (it.hasNext()) {
            Wme w = it.next();
            if (!pred.apply((Object)w)) continue;
            return w;
        }
        return null;
    }

    public static List<Wme> filter(Iterator<Wme> it, Predicate<Wme> pred) {
        ArrayList<Wme> result = new ArrayList<Wme>();
        while (it.hasNext()) {
            Wme w = it.next();
            if (!pred.apply((Object)w)) continue;
            result.add(w);
        }
        return result;
    }

    public static boolean equal(Collection<Wme> c1, Collection<Wme> c2, boolean ignoreIdentifiers) {
        if (c1.size() != c2.size()) {
            return false;
        }
        for (Wme w1 : c1) {
            boolean foundMatch = false;
            for (Wme w2 : c2) {
                if (!Wmes.equal(w1, w2, ignoreIdentifiers)) continue;
                foundMatch = true;
                break;
            }
            if (foundMatch) continue;
            return false;
        }
        return true;
    }

    public static boolean equal(Wme w1, Wme w2, boolean ignoreIdentifiers) {
        if (!ignoreIdentifiers && w1.getIdentifier() != w2.getIdentifier()) {
            return false;
        }
        if (!(ignoreIdentifiers && w1.getAttribute().asIdentifier() != null || w1.getAttribute() == w2.getAttribute())) {
            return false;
        }
        return ignoreIdentifiers && w1.getValue().asIdentifier() != null || w1.getValue() == w2.getValue();
    }

    public static boolean equalByValue(Wme w1, Wme w2) {
        return Symbols.equalByValue(w1.getIdentifier(), w2.getIdentifier()) && Symbols.equalByValue(w1.getAttribute(), w2.getAttribute()) && Symbols.equalByValue(w1.getValue(), w2.getValue());
    }

    private static class MatcherPredicate
    implements Predicate<Wme> {
        private final Identifier id;
        private final Symbol attr;
        private final Symbol value;
        private final int timetag;

        MatcherPredicate(Identifier id, Symbol attr, Symbol value, int timetag) {
            this.id = id;
            this.attr = attr;
            this.value = value;
            this.timetag = timetag;
        }

        public boolean apply(Wme w) {
            if (this.id != null && this.id != w.getIdentifier()) {
                return false;
            }
            if (this.attr != null && this.attr != w.getAttribute()) {
                return false;
            }
            if (this.value != null && this.value != w.getValue()) {
                return false;
            }
            return this.timetag < 0 || this.timetag == w.getTimetag();
        }
    }

    public static class MatcherBuilder {
        private final SymbolFactory syms;
        private Identifier id;
        private Object attr;
        private Object value;
        private int timetag = -1;

        private MatcherBuilder(SymbolFactory syms) {
            this.syms = syms;
        }

        public MatcherBuilder reset() {
            this.id = null;
            this.attr = null;
            this.value = null;
            this.timetag = -1;
            return this;
        }

        public MatcherBuilder id(Identifier id) {
            this.id = id;
            return this;
        }

        public MatcherBuilder attr(Object attr) {
            this.attr = attr;
            return this;
        }

        public MatcherBuilder value(Object value) {
            this.value = value;
            return this;
        }

        public MatcherBuilder timetag(int timetag) {
            this.timetag = timetag;
            return this;
        }

        public Wme find(Iterator<Wme> it) {
            return Wmes.find(it, this.createPredicate());
        }

        public Wme find(Identifier id) {
            return this.find(id.getWmes());
        }

        public Wme find(Wme parent) {
            return this.find(parent.getChildren());
        }

        public Wme find(Collection<Wme> wmes) {
            return this.find(wmes.iterator());
        }

        public List<Wme> filter(Iterator<Wme> it) {
            return Wmes.filter(it, this.createPredicate());
        }

        public List<Wme> filter(Identifier id) {
            return this.filter(id.getWmes());
        }

        public List<Wme> filter(Wme parent) {
            return this.filter(parent.getChildren());
        }

        public List<Wme> filter(Collection<Wme> wmes) {
            return this.filter(wmes.iterator());
        }

        public Predicate<Wme> createPredicate() {
            return Wmes.newMatcher(this.syms, this.id, this.attr, this.value, this.timetag);
        }
    }
}

