/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.modules;

import com.google.common.base.Predicate;

public class Predicates {
    public static Predicate<Double> betweenDouble(final double min, final double max, final boolean inclusive) {
        return new Predicate<Double>(){

            public boolean apply(Double val) {
                return inclusive ? val >= min && val <= max : val > min && val < max;
            }
        };
    }

    public static Predicate<Double> greaterThanDouble(double min, boolean inclusive) {
        return Predicates.betweenDouble(min, Double.POSITIVE_INFINITY, inclusive);
    }

    public static Predicate<Double> lessThanDouble(double max, boolean inclusive) {
        return Predicates.betweenDouble(Double.NEGATIVE_INFINITY, max, inclusive);
    }

    public static Predicate<Integer> betweenInteger(final int min, final int max, final boolean inclusive) {
        return new Predicate<Integer>(){

            public boolean apply(Integer val) {
                return inclusive ? val >= min && val <= max : val > min && val < max;
            }
        };
    }

    public static Predicate<Integer> greaterThanInteger(Integer min, boolean inclusive) {
        return Predicates.betweenInteger(min, Integer.MAX_VALUE, inclusive);
    }

    public static Predicate<Integer> lessThanInteger(Integer max, boolean inclusive) {
        return Predicates.betweenInteger(Integer.MIN_VALUE, max, inclusive);
    }
}

